/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.task;

import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.model.AssignmentNodeModel;
import com.projectlibre1.grouping.core.model.DefaultNodeModel;
import com.projectlibre1.grouping.core.summaries.DeepChildWalker;
import com.projectlibre1.job.Job;
import com.projectlibre1.job.JobRunnable;
import com.projectlibre1.pm.resource.ResourcePool;
import com.projectlibre1.pm.resource.ResourcePoolFactory;
import com.projectlibre1.pm.task.Portfolio;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.pm.task.SubProj;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.server.data.DataUtil;
import com.projectlibre1.session.CreateOptions;
import com.projectlibre1.session.LoadOptions;
import com.projectlibre1.session.LocalSession;
import com.projectlibre1.session.SaveOptions;
import com.projectlibre1.session.Session;
import com.projectlibre1.session.SessionFactory;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.undo.DataFactoryUndoController;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.Environment;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.Closure;

public class ProjectFactory {
    private static int untitledCount = 0;
    private String server = null;
    Portfolio portfolio;
    private static ProjectFactory projectFactory;
    protected Set loadingProjects = new HashSet();
    protected Set closingProjects = new HashSet();

    public static ProjectFactory getInstance() {
        if (projectFactory == null) {
            projectFactory = new ProjectFactory();
        }
        return projectFactory;
    }

    public static ProjectFactory createInstance() {
        return new ProjectFactory();
    }

    private ProjectFactory() {
        this.portfolio = new Portfolio(this);
    }

    public Project createProject() {
        CreateOptions createOptions = new CreateOptions();
        createOptions.setLocal(Environment.getStandAlone());
        createOptions.setName(Messages.getString("Text.Untitled") + " " + ++untitledCount);
        return this.createProject(createOptions);
    }

    private Project createProjectAsync(CreateOptions createOptions) {
        DataFactoryUndoController dataFactoryUndoController = new DataFactoryUndoController();
        ResourcePool resourcePool = createOptions.getResourcePool();
        if (resourcePool == null) {
            resourcePool = ResourcePoolFactory.getInstance().createResourcePool(createOptions.getName(), dataFactoryUndoController);
            resourcePool.setLocal(createOptions.isLocal());
        }
        Project project = Project.createProject(resourcePool, dataFactoryUndoController);
        dataFactoryUndoController.setDataFactory(project);
        project.setName(createOptions.getName());
        if (createOptions.isLocal()) {
            project.setMaster(true);
        }
        if (createOptions.isAddResources() && !project.isLocal()) {
            try {
                List list;
                Session session = SessionFactory.getInstance().getSession(false);
                if (((Boolean)SessionFactory.callNoEx(session, "isLocalAccess", null, null)).booleanValue()) {
                    list = (List)SessionFactory.call(session, "retrieveResourceHierarchy", null, null);
                } else {
                    list = new ArrayList();
                    Job job = (Job)SessionFactory.callNoEx(session, "getLoadResourceHierarchyJob", new Class[]{Boolean.TYPE, List.class}, new Object[]{true, list});
                    job.addSync();
                    session.schedule(job);
                }
                DataUtil.setEnterpriseResources(list, resourcePool);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        project.setInitialized(true);
        ((DefaultNodeModel)project.getTaskOutline()).setDataFactory(project);
        this.addProject(project, !createOptions.isSync(), createOptions.isVerify());
        System.out.println("Project returned");
        return project;
    }

    public Project createProject(final CreateOptions createOptions) {
        JobRunnable jobRunnable = new JobRunnable(this, "Local: create Project"){
            final /* synthetic */ ProjectFactory this$0;
            {
                this.this$0 = projectFactory;
                super(string);
            }

            @Override
            public Object run() throws Exception {
                return this.this$0.createProjectAsync(createOptions);
            }
        };
        if (createOptions.isSync()) {
            Job job = new Job(SessionFactory.getInstance().getJobQueue(), "createProject", "Creating project...", false);
            job.addRunnable(jobRunnable);
            job.addSync();
            SessionFactory.getInstance().schedule(job);
            try {
                Project project = (Project)job.waitResult();
                System.out.println("Project returned end lock");
                return project;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        try {
            return (Project)jobRunnable.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void addProject(Project project, boolean bl) {
        this.addProject(project, true, bl);
    }

    public void addProject(Project project, boolean bl, boolean bl2) {
        this.portfolio.addProject(project, bl, bl2);
    }

    public synchronized Set getOpenOrLoadingProjects() {
        final HashSet hashSet = new HashSet();
        ProjectFactory.getInstance().getPortfolio().forProjects(new Closure(){

            @Override
            public void execute(Object object) {
                Project project = (Project)object;
                hashSet.add(new Long(project.getUniqueId()));
            }
        });
        hashSet.addAll(this.loadingProjects);
        hashSet.removeAll(this.closingProjects);
        return hashSet;
    }

    public synchronized void addLoadingProject(long l) {
        this.loadingProjects.add(new Long(l));
    }

    public synchronized void removeLoadingProject(long l) {
        this.loadingProjects.remove(new Long(l));
    }

    public synchronized void addClosingProjects(Collection collection) {
        this.closingProjects.addAll(collection);
    }

    public synchronized void addClosingProject(long l) {
        this.closingProjects.add(new Long(l));
    }

    public synchronized void removeClosingProject(long l) {
        this.closingProjects.remove(new Long(l));
    }

    public Project openProject(final LoadOptions loadOptions) {
        boolean bl;
        Session session = SessionFactory.getInstance().getSession(loadOptions.isLocal());
        Job job = null;
        if (loadOptions.getId() > 0L) {
            Project project = this.findFromId(loadOptions.getId());
            if (project != null && !loadOptions.isOpenAs()) {
                job = session.getEmptyJob("Recover project", project);
                bl = true;
            } else {
                this.addLoadingProject(loadOptions.getId());
                bl = false;
            }
        } else {
            bl = false;
        }
        if (job == null) {
            job = session.getLoadProjectJob(loadOptions);
        }
        job.addSwingRunnable(new JobRunnable(this, "Local: addProject"){
            final /* synthetic */ ProjectFactory this$0;
            {
                this.this$0 = projectFactory;
                super(string);
            }

            @Override
            public Object run() throws Exception {
                Project project = (Project)this.getPreviousResult();
                if (!bl) {
                    if (project != null) {
                        this.this$0.addProject(project, false, true);
                    }
                    if (loadOptions.getId() > 0L) {
                        this.this$0.removeLoadingProject(loadOptions.getId());
                    }
                }
                if (loadOptions.getEndSwingClosure() != null) {
                    loadOptions.getEndSwingClosure().execute(project);
                }
                if (project != null && loadOptions.isOpenAs() && project.isMaster()) {
                    project.setReadOnly(true);
                }
                if (project != null && loadOptions.isOpenAs()) {
                    project.setReadOnly(true);
                    project.setLocal(true);
                }
                return project;
            }
        }, false);
        if (loadOptions.isSync()) {
            job.addSync();
        }
        session.schedule(job);
        try {
            return loadOptions.isSync() ? (Project)job.waitResult() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Project findFromId(long l) {
        return this.portfolio.findByUniqueId(l);
    }

    public Project openSubproject(final Project project, final Node node, final boolean bl) {
        final SubProj subProj = (SubProj)node.getImpl();
        final long l = subProj.getSubprojectUniqueId();
        Project project2 = this.portfolio.findByUniqueId(l);
        if (project2 != null) {
            project.getSubprojectHandler().addSubproject(project2, node, bl, true);
            this.portfolio.handleExternalTasks(project2, true, false);
            return project2;
        }
        Session session = SessionFactory.getInstance().getSession(false);
        if (!session.projectExists(l)) {
            Alert.error(Messages.getString("Error.projectDoesNotExist"));
            return null;
        }
        this.addLoadingProject(l);
        LoadOptions loadOptions = new LoadOptions();
        loadOptions.setSubproject(true);
        loadOptions.setId(l);
        Job job = session.getLoadProjectJob(loadOptions);
        subProj.setFetching(true);
        job.addSwingRunnable(new JobRunnable(this, "Local: insertProject"){
            final /* synthetic */ ProjectFactory this$0;
            {
                this.this$0 = projectFactory;
                super(string);
            }

            @Override
            public Object run() throws Exception {
                try {
                    Project project2 = (Project)this.getPreviousResult();
                    AssignmentNodeModel assignmentNodeModel = (AssignmentNodeModel)project2.getTaskOutline();
                    assignmentNodeModel.addAssignments(assignmentNodeModel.iterator());
                    if (project2 != null) {
                        project.getSubprojectHandler().addSubproject(project2, node, bl, false);
                        if (project2.isReadOnly()) {
                            Alert.warn(MessageFormat.format(Messages.getString("Message.readOnlySubproject"), project2.getName()));
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
                finally {
                    subProj.setFetching(false);
                    this.this$0.removeLoadingProject(l);
                }
                return null;
            }
        }, false);
        session.schedule(job);
        return ((Task)((Object)subProj)).getProject();
    }

    public void saveProject(Project project, SaveOptions saveOptions) {
        Job job = this.getSaveProjectJob(project, saveOptions);
        Session session = SessionFactory.getInstance().getSession(saveOptions.isLocal());
        if (job != null) {
            if (saveOptions.isSync()) {
                job.addSync();
            }
            session.schedule(job);
            try {
                if (saveOptions.isSync()) {
                    job.waitResult();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Job getSaveProjectJob(Project project, final SaveOptions saveOptions) {
        final ArrayList<Project> arrayList = new ArrayList<Project>();
        DeepChildWalker.recursivelyTreatBranch(this.portfolio.getNodeModel(), project, new Closure(){
            boolean dirty = false;

            @Override
            public void execute(Object object) {
                Node node = (Node)object;
                Object object2 = node.getImpl();
                if (object2 instanceof Project) {
                    Project project = (Project)object2;
                    if (((Node)node.getParent()).isRoot()) {
                        this.dirty = project.needsSaving();
                    }
                    if (this.dirty || saveOptions.isSaveAs() || saveOptions.getImporter() != null) {
                        project.setEarliestAndLatestDatesFromSchedule();
                        arrayList.add(project);
                    }
                }
            }
        });
        if (arrayList.size() > 0) {
            Session session = SessionFactory.getInstance().getSession(saveOptions.isLocal());
            SaveOptions saveOptions2 = (SaveOptions)saveOptions.clone();
            saveOptions2.setPostSaving(new Closure(){
                final /* synthetic */ ProjectFactory this$0;
                {
                    this.this$0 = projectFactory;
                }

                @Override
                public void execute(Object object) {
                    Project project = (Project)object;
                    project.setAllTasksAsUnchangedFromPersisted(true);
                    project.validateNewDistributionMap();
                    this.this$0.portfolio.handleExternalTasks(project, false, true);
                    if (saveOptions.getPostSaving() != null) {
                        saveOptions.getPostSaving().execute(object);
                    }
                }
            });
            Job job = session.getSaveProjectJob(arrayList, saveOptions2);
            return job;
        }
        return null;
    }

    public Job getCloseProjectsOnServerJob(Project project) {
        final ArrayList arrayList = new ArrayList();
        DeepChildWalker.recursivelyTreatBranch(this.portfolio.getNodeModel(), project, new Closure(){

            @Override
            public void execute(Object object) {
                Object object2 = ((Node)object).getImpl();
                if (object2 instanceof Project) {
                    arrayList.add(object2);
                }
            }
        });
        if (arrayList.size() > 0) {
            Session session = SessionFactory.getInstance().getSession(project.isLocal());
            Job job = session.getCloseProjectsJob(arrayList);
            return job;
        }
        return null;
    }

    public Job getCloseProjectsOnServerJob(Collection collection) {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        ArrayList<Project> arrayList2 = new ArrayList<Project>();
        for (Object object2 : collection) {
            if (((Project)object2).isReadOnly()) continue;
            if (((Project)object2).isLocal()) {
                arrayList.add((Project)object2);
                continue;
            }
            arrayList2.add((Project)object2);
        }
        Object object = null;
        if (arrayList.size() > 0) {
            object = SessionFactory.getInstance().getLocalSession().getCloseProjectsJob(collection);
        }
        if (arrayList2.size() > 0) {
            Object object2;
            object2 = SessionFactory.getInstance().getSession(false).getCloseProjectsJob(collection);
            if (object == null) {
                object = object2;
            } else {
                ((Job)object).addJob((Job)object2);
            }
        }
        return object;
    }

    public int promptForSave(Project project, boolean bl) {
        String string = Messages.getString("Message.saveProjectBeforeClosing1") + " " + project.getName() + " " + Messages.getString("Message.saveProjectBeforeClosing2");
        if (bl) {
            return Alert.confirm(string);
        }
        return Alert.confirmYesNo(string);
    }

    public Job getRemoveProjectJob(final Project project, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Cloneable cloneable;
        Object object2 = null;
        if (bl2 && project.needsSaving()) {
            int n = this.promptForSave(project, bl);
            if (n == 0) {
                cloneable = new SaveOptions();
                ((SaveOptions)cloneable).setLocal(project.isLocal());
                if (project.isLocal()) {
                    object = project.getFileName();
                    if (object == null) {
                        object = SessionFactory.getInstance().getLocalSession().chooseFileName(true, project.getGuessedFileName());
                    }
                    if (object == null) {
                        return null;
                    }
                    project.setFileName((String)object);
                    ((SaveOptions)cloneable).setFileName((String)object);
                    ((SaveOptions)cloneable).setImporter(LocalSession.getImporter(project.getFileType()));
                }
                object2 = this.getSaveProjectJob(project, (SaveOptions)cloneable);
            } else if (n == 2) {
                return null;
            }
        }
        final ArrayList arrayList = new ArrayList();
        cloneable = new ArrayList();
        DeepChildWalker.recursivelyTreatBranch(this.portfolio.getNodeModel(), project, new Closure(){
            final /* synthetic */ ArrayList val$projects;
            {
                this.val$projects = arrayList2;
            }

            @Override
            public void execute(Object object) {
                Node node = (Node)object;
                Object object2 = node.getImpl();
                if (!(object2 instanceof Project)) {
                    return;
                }
                Project project2 = (Project)object2;
                arrayList.add(node);
                if (Environment.getStandAlone() || project.isLockable()) {
                    this.val$projects.add(project2);
                }
            }
        });
        object = this.getCloseProjectsOnServerJob((Collection)((Object)cloneable));
        if (object == null) {
            object = new Job(SessionFactory.getInstance().getJobQueue(), "closeProjects", "Closing...", false);
        }
        if (object2 == null) {
            object2 = object;
        } else {
            ((Job)object2).addJob((Job)object);
        }
        ((Job)object2).addRunnable(new JobRunnable(this, "Local: closeProjects"){
            final /* synthetic */ ProjectFactory this$0;
            {
                this.this$0 = projectFactory;
                super(string);
            }

            @Override
            public Object run() throws Exception {
                for (Node node : arrayList) {
                    Project project2 = (Project)node.getImpl();
                    this.this$0.portfolio.handleExternalTasks(project2, false, false);
                    project2.getResourcePool().removeProject(project2);
                    project2.disconnect();
                    this.this$0.portfolio.getObjectEventManager().fireDeleteEvent(this, project2);
                    this.this$0.portfolio.getNodeModel().remove(node, 1);
                    this.this$0.removeClosingProject(project.getUniqueId());
                }
                System.gc();
                return null;
            }
        }, false, false, bl3, false);
        return object2;
    }

    public void removeProject(Project project, boolean bl, boolean bl2, boolean bl3) {
        Job job = this.getRemoveProjectJob(project, bl, bl2, bl3);
        if (job != null) {
            Session session = SessionFactory.getInstance().getSession(project.isLocal());
            session.schedule(job);
        }
    }

    public void doRemoveProject(Project project, boolean bl) {
        Job job = projectFactory.getPortfolio().getRemoveProjectJob(project, bl);
        if (job != null) {
            SessionFactory.getInstance().getSession(project.isLocal()).schedule(job);
            this.portfolio.handleExternalTasks(project, false, false);
        }
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public final String getServer() {
        return this.server;
    }

    public final void setServer(String string) {
        this.server = string;
    }

    public Collection getDirtyProjectList() {
        return this.portfolio.getDirtyProjectList();
    }

    public Collection getWritableProjectsList() {
        return this.portfolio.getWritableProjectList();
    }

    public static Object getProjectData(long l) {
        Session session = SessionFactory.getInstance().getSession(false);
        return SessionFactory.callNoEx(session, "getProjectData", new Class[]{Long.class}, new Object[]{l});
    }

    public boolean isResourcePoolOpenAndWritable() {
        return this.portfolio.isResourcePoolOpenAndWritable();
    }
}

