/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.strings;

import com.projectlibre1.preference.ConfigurationFile;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;

public class DirectoryClassLoader
extends ClassLoader {
    protected File directory;

    public DirectoryClassLoader() {
        this.directory = ConfigurationFile.getConfDir();
    }

    public DirectoryClassLoader(File file) {
        this.directory = file;
        if (file != null && !file.isDirectory()) {
            file = null;
        }
    }

    public boolean isValid() {
        return this.directory != null;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (this.directory == null) {
            throw new ClassNotFoundException(string);
        }
        try {
            File file = new File(this.directory, string + ".properties");
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            byte[] byArray = new byte[(int)file.length()];
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ClassNotFoundException(string);
        }
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        if (this.directory == null) {
            return null;
        }
        try {
            File file = new File(this.directory, string + "_" + String.valueOf(Locale.getDefault()) + ".properties");
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            return dataInputStream;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

