/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.AbstractIterator;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.LazyZip2;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.generic.SerializeEnd$;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.LazyList$;
import scala.collection.immutable.LazyList$Deferrer$;
import scala.collection.immutable.LazyList$EmptyMarker$;
import scala.collection.immutable.LazyList$MidEvaluation$;
import scala.collection.immutable.LazyList$Uninitialized$;
import scala.collection.immutable.LinearSeq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ReusableBuilder;
import scala.collection.mutable.StringBuilder;
import scala.math.Integral;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class LazyList<A>
extends AbstractSeq<A>
implements LinearSeq<A>,
Serializable {
    private static final long serialVersionUID = 4L;
    private volatile Object _head;
    private Object _tail;

    public static <A> LazyList<A> continually(Function0<A> function0) {
        return LazyList$.MODULE$.continually(function0);
    }

    public static <A> LazyList<A> fill(int n, Function0<A> function0) {
        return LazyList$.MODULE$.fill(n, (Function0)function0);
    }

    public static /* synthetic */ Object fill(int n, Function0 function0) {
        return LazyList$.MODULE$.fill(n, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return LazyList$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return LazyList$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return LazyList$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return LazyList$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static LazyList<Object> from(int n) {
        return LazyList$.MODULE$.from(n);
    }

    public static LazyList<Object> from(int n, int n2) {
        return LazyList$.MODULE$.from(n, n2);
    }

    public static <A> LazyList<A> from(IterableOnce<A> iterableOnce) {
        return LazyList$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static <A> LazyList<A> iterate(Function0<A> function0, Function1<A, A> function1) {
        return LazyList$.MODULE$.iterate(function0, function1);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return LazyList$.MODULE$.iterate(object, n, function1);
    }

    public static <A> Builder<A, LazyList<A>> newBuilder() {
        return LazyList$.MODULE$.newBuilder();
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return LazyList$.MODULE$.range(object, object2, integral);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return LazyList$.MODULE$.range(object, object2, object3, integral);
    }

    public static <A> LazyList<A> tabulate(int n, Function1<Object, A> function1) {
        return LazyList$.MODULE$.tabulate(n, (Function1)function1);
    }

    public static /* synthetic */ Object tabulate(int n, Function1 function1) {
        return LazyList$.MODULE$.tabulate(n, function1);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return LazyList$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return LazyList$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return LazyList$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return LazyList$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static <A> Function0 toDeferrer(Function0<LazyList<A>> function0) {
        return LazyList$.MODULE$.toDeferrer(function0);
    }

    public static SeqOps unapplySeq(SeqOps seqOps) {
        return LazyList$.MODULE$.unapplySeq(seqOps);
    }

    public static <A, S> LazyList<A> unfold(S s, Function1<S, Option<Tuple2<A, S>>> function1) {
        return LazyList$.MODULE$.unfold((Object)s, (Function1)function1);
    }

    public static /* synthetic */ Object unfold(Object object, Function1 function1) {
        return LazyList$.MODULE$.unfold(object, function1);
    }

    public LazyList(Object lazyState) {
        LinearSeqOps.$init$(this);
        scala.collection.LinearSeq.$init$(this);
        LinearSeq.$init$(this);
        this._head = lazyState == LazyList$EmptyMarker$.MODULE$ ? null : LazyList$Uninitialized$.MODULE$;
        this._tail = lazyState == LazyList$EmptyMarker$.MODULE$ ? null : lazyState;
    }

    @Override
    public Option<A> headOption() {
        return LinearSeqOps.headOption$(this);
    }

    @Override
    public int length() {
        return LinearSeqOps.length$(this);
    }

    @Override
    public A last() {
        return (A)LinearSeqOps.last$(this);
    }

    @Override
    public int lengthCompare(int len) {
        return LinearSeqOps.lengthCompare$((LinearSeqOps)this, len);
    }

    @Override
    public int lengthCompare(Iterable<?> that) {
        return LinearSeqOps.lengthCompare$((LinearSeqOps)this, that);
    }

    @Override
    public boolean isDefinedAt(int x) {
        return LinearSeqOps.isDefinedAt$(this, x);
    }

    @Override
    public A apply(int n) throws IndexOutOfBoundsException {
        return (A)LinearSeqOps.apply$(this, n);
    }

    @Override
    public boolean forall(Function1<A, Object> p) {
        return LinearSeqOps.forall$(this, p);
    }

    @Override
    public boolean exists(Function1<A, Object> p) {
        return LinearSeqOps.exists$(this, p);
    }

    @Override
    public <A1> boolean contains(A1 elem) {
        return LinearSeqOps.contains$(this, elem);
    }

    @Override
    public <B> boolean sameElements(IterableOnce<B> that) {
        return LinearSeqOps.sameElements$(this, that);
    }

    @Override
    public int segmentLength(Function1<A, Object> p, int from) {
        return LinearSeqOps.segmentLength$(this, p, from);
    }

    @Override
    public int indexWhere(Function1<A, Object> p, int from) {
        return LinearSeqOps.indexWhere$(this, p, from);
    }

    @Override
    public int lastIndexWhere(Function1<A, Object> p, int end) {
        return LinearSeqOps.lastIndexWhere$(this, p, end);
    }

    @Override
    public Option<A> findLast(Function1<A, Object> p) {
        return LinearSeqOps.findLast$(this, p);
    }

    @Override
    public Iterator<LazyList<A>> tails() {
        return LinearSeqOps.tails$(this);
    }

    @Override
    public String stringPrefix() {
        return scala.collection.LinearSeq.stringPrefix$(this);
    }

    @Override
    public /* synthetic */ boolean scala$collection$LinearSeqOps$$super$sameElements(IterableOnce that) {
        return SeqOps.sameElements$(this, that);
    }

    public LazyList(A head, LazyList<A> tail) {
        this(LazyList$EmptyMarker$.MODULE$);
        this._head = head;
        this._tail = tail;
    }

    private Object rawHead() {
        return this._head;
    }

    private Object rawTail() {
        return this._tail;
    }

    private boolean isEvaluated() {
        return this._head != LazyList$Uninitialized$.MODULE$;
    }

    private void initState() {
        LazyList lazyList = this;
        synchronized (lazyList) {
            if (!this.isEvaluated()) {
                LazyList<A> lazyList2;
                if (this._tail == LazyList$MidEvaluation$.MODULE$) {
                    throw new RuntimeException("LazyList evaluation depends on its own result (self-reference); see docs for more info");
                }
                Function0 fun = (Function0)this._tail;
                this._tail = LazyList$MidEvaluation$.MODULE$;
                try {
                    lazyList2 = ((LazyList)fun.apply()).evaluated();
                }
                finally {
                    this._tail = fun;
                }
                LazyList<A> l = lazyList2;
                this._tail = super.rawTail();
                this._head = super.rawHead();
                v1 = BoxedUnit.UNIT;
            } else {
                v1 = BoxedUnit.UNIT;
            }
        }
    }

    private LazyList<A> evaluated() {
        while (true) {
            if (this.isEvaluated()) {
                if (this._tail == null) {
                    return LazyList$.scala$collection$immutable$LazyList$$$Empty;
                }
                return this;
            }
            this.initState();
        }
    }

    @Override
    public SeqFactory<LazyList> iterableFactory() {
        return LazyList$.MODULE$;
    }

    @Override
    public boolean isEmpty() {
        return this.evaluated() == LazyList$.scala$collection$immutable$LazyList$$$Empty;
    }

    @Override
    public int knownSize() {
        if (this.knownIsEmpty()) {
            return 0;
        }
        return -1;
    }

    @Override
    public A head() {
        if (this.evaluated() == LazyList$.scala$collection$immutable$LazyList$$$Empty) {
            throw new NoSuchElementException("head of empty lazy list");
        }
        return (A)this.rawHead();
    }

    @Override
    public LazyList<A> tail() {
        if (this.evaluated() == LazyList$.scala$collection$immutable$LazyList$$$Empty) {
            throw new UnsupportedOperationException("tail of empty lazy list");
        }
        return (LazyList)this.rawTail();
    }

    private boolean knownIsEmpty() {
        return this.isEvaluated() && this.isEmpty();
    }

    public boolean scala$collection$immutable$LazyList$$knownNonEmpty() {
        return this.isEvaluated() && !this.isEmpty();
    }

    public LazyList<A> force() {
        Object these = this;
        Object those = this;
        if (!((LazyList)these).isEmpty()) {
            these = ((LazyList)these).tail();
        }
        while (those != these) {
            if (((LazyList)these).isEmpty()) {
                return this;
            }
            if (((LazyList)(these = ((LazyList)these).tail())).isEmpty()) {
                return this;
            }
            if ((these = ((LazyList)these).tail()) == those) {
                return this;
            }
            those = ((LazyList)those).tail();
        }
        return this;
    }

    @Override
    public Iterator<A> iterator() {
        if (this.knownIsEmpty()) {
            return Iterator$.MODULE$.empty();
        }
        return new LazyIterator(this);
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        while (!((LazyList)this_).isEmpty()) {
            f.apply(((LazyList)this_).head());
            Object this_ = ((LazyList)this_).tail();
        }
    }

    @Override
    public <B> B foldLeft(B z, Function2<B, A, B> op) {
        while (!((LazyList)this_).isEmpty()) {
            Object object = ((LazyList)this_).tail();
            B b = op.apply(z, ((LazyList)this_).head());
            Object this_ = object;
            z = b;
        }
        return z;
    }

    public Object writeReplace() {
        if (this.scala$collection$immutable$LazyList$$knownNonEmpty()) {
            return new SerializationProxy(this);
        }
        return this;
    }

    @Override
    public String className() {
        return "LazyList";
    }

    public <B> LazyList<B> lazyAppendedAll(Function0<IterableOnce<B>> suffix) {
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.lazyAppendedAll$$anonfun$1(suffix));
    }

    @Override
    public <B> LazyList<B> appendedAll(IterableOnce<B> suffix) {
        if (this.knownIsEmpty()) {
            return LazyList$.MODULE$.from((IterableOnce)suffix);
        }
        return this.lazyAppendedAll(() -> LazyList.appendedAll$$anonfun$1(suffix));
    }

    @Override
    public <B> LazyList<B> appended(B elem) {
        if (this.knownIsEmpty()) {
            return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(elem, LazyList$.scala$collection$immutable$LazyList$$$Empty);
        }
        return this.lazyAppendedAll(() -> LazyList.appended$$anonfun$1(elem));
    }

    @Override
    public <B> LazyList<B> scanLeft(B z, Function2<B, A, B> op) {
        if (this.knownIsEmpty()) {
            return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(z, LazyList$.scala$collection$immutable$LazyList$$$Empty);
        }
        return this.scanLeftImpl(z, op);
    }

    private <B> LazyList<B> scanLeftImpl(B z, Function2<B, A, B> op) {
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(z, LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.scanLeftImpl$$anonfun$1(op, z)));
    }

    @Override
    public <B> B reduceLeft(Function2<B, A, B> f) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.reduceLeft");
        }
        Object reducedRes = this.head();
        Object left = this.tail();
        while (!((LazyList)left).isEmpty()) {
            reducedRes = f.apply(reducedRes, ((LazyList)left).head());
            left = ((LazyList)left).tail();
        }
        return (B)reducedRes;
    }

    @Override
    public Tuple2<LazyList<A>, LazyList<A>> partition(Function1<A, Object> p) {
        return Tuple2$.MODULE$.apply(this.filter((Function1)p), this.filterNot((Function1)p));
    }

    @Override
    public <A1, A2> Tuple2<LazyList<A1>, LazyList<A2>> partitionMap(Function1<A, Either<A1, A2>> f) {
        Tuple2<LazyList<A>, LazyList<A>> tuple2;
        Tuple2<LazyList<A>, LazyList<A>> $1$;
        Tuple2<LazyList<A>, LazyList<A>> tuple22 = $1$ = (tuple2 = ((LazyList)this.map(f)).partition((Function1<Either, Boolean> & Serializable)_$1 -> _$1.isLeft()));
        LazyList<A> left = tuple22._1();
        LazyList<A> right = tuple22._2();
        return Tuple2$.MODULE$.apply(left.map((Function1<Either, Object> & Serializable)(T1 _$2) -> ((Left)_$2).value()), right.map((Function1<Either, Object> & Serializable)(T1 _$3) -> ((Right)_$3).value()));
    }

    @Override
    public LazyList<A> filter(Function1<A, Object> pred) {
        if (this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$filterImpl(this, pred, false);
    }

    @Override
    public LazyList<A> filterNot(Function1<A, Object> pred) {
        if (this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$filterImpl(this, pred, true);
    }

    @Override
    public scala.collection.WithFilter<A, LazyList> withFilter(Function1<A, Object> p) {
        return new WithFilter<A>((LazyList)this.coll(), p);
    }

    @Override
    public <B> LazyList<B> prepended(B elem) {
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(elem, this);
    }

    @Override
    public <B> LazyList<B> prependedAll(IterableOnce<B> prefix) {
        if (this.knownIsEmpty()) {
            return LazyList$.MODULE$.from((IterableOnce)prefix);
        }
        if (prefix.knownSize() == 0) {
            return this;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.prependedAll$$anonfun$1(prefix));
    }

    @Override
    public <B> LazyList<B> map(Function1<A, B> f) {
        if (this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return this.mapImpl(f);
    }

    @Override
    public <U> LazyList<A> tapEach(Function1<A, U> f) {
        return this.map((Function1<Object, Object> & Serializable)(T1 a) -> {
            f.apply(a);
            return a;
        });
    }

    private <B> LazyList<B> mapImpl(Function1<A, B> f) {
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.mapImpl$$anonfun$1(f));
    }

    @Override
    public <B> LazyList<B> collect(PartialFunction<A, B> pf) {
        if (this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$collectImpl(this, pf);
    }

    @Override
    public <B> Option<B> collectFirst(PartialFunction<A, B> pf) {
        Object res;
        while (true) {
            if (((LazyList)this_).isEmpty()) {
                return None$.MODULE$;
            }
            res = pf.applyOrElse(((LazyList)this_).head(), LazyList$.scala$collection$immutable$LazyList$$$anyToMarker);
            if (res != Statics.pfMarker) break;
            Object this_ = ((LazyList)this_).tail();
        }
        return Some$.MODULE$.apply(res);
    }

    @Override
    public Option<A> find(Function1<A, Object> p) {
        while (!((LazyList)this_).isEmpty()) {
            A elem = ((LazyList)this_).head();
            if (BoxesRunTime.unboxToBoolean(p.apply(elem))) {
                return Some$.MODULE$.apply(elem);
            }
            Object this_ = ((LazyList)this_).tail();
        }
        return None$.MODULE$;
    }

    @Override
    public <B> LazyList<B> flatMap(Function1<A, IterableOnce<B>> f) {
        if (this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$flatMapImpl(this, f);
    }

    @Override
    public <B> LazyList<B> flatten(Function1<A, IterableOnce<B>> asIterable) {
        return this.flatMap((Function1)asIterable);
    }

    @Override
    public <B> LazyList<Tuple2<A, B>> zip(IterableOnce<B> that) {
        if (this.knownIsEmpty() || that.knownSize() == 0) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.zip$$anonfun$1(that));
    }

    private <B> LazyList<Tuple2<A, B>> eagerHeadZipImpl(Iterator<B> it) {
        if (this.isEmpty() || !it.hasNext()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(Tuple2$.MODULE$.apply(this.head(), it.next()), LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.eagerHeadZipImpl$$anonfun$1(it)));
    }

    @Override
    public LazyList<Tuple2<A, Object>> zipWithIndex() {
        return this.zip(LazyList$.MODULE$.from(0));
    }

    @Override
    public <A1, B> LazyList<Tuple2<A1, B>> zipAll(Iterable<B> that, A1 thisElem, B thatElem) {
        if (this.knownIsEmpty()) {
            if (that.knownSize() == 0) {
                return LazyList$.scala$collection$immutable$LazyList$$$Empty;
            }
            return LazyList$.MODULE$.continually(() -> LazyList.zipAll$$anonfun$1(thisElem)).zip(that);
        }
        if (that.knownSize() == 0) {
            return this.zip((IterableOnce)LazyList$.MODULE$.continually(() -> LazyList.zipAll$$anonfun$2(thatElem)));
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.zipAll$$anonfun$3(that, thisElem, thatElem));
    }

    private <A1, B> LazyList<Tuple2<A1, B>> eagerHeadZipAllImpl(Iterator<B> it, A1 thisElem, B thatElem) {
        if (it.hasNext()) {
            if (this.isEmpty()) {
                return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(Tuple2$.MODULE$.apply(thisElem, it.next()), LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> LazyList.eagerHeadZipAllImpl$$anonfun$1(thisElem, it)));
            }
            return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(Tuple2$.MODULE$.apply(this.head(), it.next()), LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.eagerHeadZipAllImpl$$anonfun$2(it, thisElem, thatElem)));
        }
        if (this.isEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(Tuple2$.MODULE$.apply(this.head(), thatElem), ((LazyList)this.tail()).zip((IterableOnce)LazyList$.MODULE$.continually(() -> LazyList.eagerHeadZipAllImpl$$anonfun$3(thatElem))));
    }

    @Override
    public <B> LazyZip2<A, B, LazyList<A>> lazyZip(Iterable<B> that) {
        return Iterable.lazyZip$(this, that);
    }

    @Override
    public <A1, A2> Tuple2<LazyList<A1>, LazyList<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return Tuple2$.MODULE$.apply(this.map((Function1<Object, Object> & Serializable)(T1 _$4) -> ((Tuple2)asPair.apply(_$4))._1()), this.map((Function1<Object, Object> & Serializable)(T1 _$5) -> ((Tuple2)asPair.apply(_$5))._2()));
    }

    @Override
    public <A1, A2, A3> Tuple3<LazyList<A1>, LazyList<A2>, LazyList<A3>> unzip3(Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        return Tuple3$.MODULE$.apply(this.map((Function1<Object, Object> & Serializable)(T1 _$6) -> ((Tuple3)asTriple.apply(_$6))._1()), this.map((Function1<Object, Object> & Serializable)(T1 _$7) -> ((Tuple3)asTriple.apply(_$7))._2()), this.map((Function1<Object, Object> & Serializable)(T1 _$8) -> ((Tuple3)asTriple.apply(_$8))._3()));
    }

    @Override
    public LazyList<A> drop(int n) {
        if (n <= 0) {
            return this;
        }
        if (this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$dropImpl(this, n);
    }

    @Override
    public LazyList<A> dropWhile(Function1<A, Object> p) {
        if (this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$dropWhileImpl(this, p);
    }

    @Override
    public LazyList<A> dropRight(int n) {
        if (n <= 0) {
            return this;
        }
        if (this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.dropRight$$anonfun$1(n));
    }

    private LazyList<A> eagerHeadDropRightImpl(LazyList<?> scout) {
        if (scout.isEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(this.head(), LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.eagerHeadDropRightImpl$$anonfun$1(scout)));
    }

    @Override
    public LazyList<A> take(int n) {
        if (this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return this.takeImpl(n);
    }

    private LazyList<A> takeImpl(int n) {
        if (n <= 0) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.takeImpl$$anonfun$1(n));
    }

    @Override
    public LazyList<A> takeWhile(Function1<A, Object> p) {
        if (this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return this.takeWhileImpl(p);
    }

    private LazyList<A> takeWhileImpl(Function1<A, Object> p) {
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.takeWhileImpl$$anonfun$1(p));
    }

    @Override
    public LazyList<A> takeRight(int n) {
        if (n <= 0 || this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$takeRightImpl(this, n);
    }

    @Override
    public LazyList<A> slice(int from, int until) {
        return ((LazyList)this.take(until)).drop(from);
    }

    @Override
    public LazyList<A> reverse() {
        return this.reverseOnto(LazyList$.scala$collection$immutable$LazyList$$$Empty);
    }

    private <B> LazyList<B> reverseOnto(LazyList<B> tl) {
        while (!((LazyList)this_).isEmpty()) {
            Object object = ((LazyList)this_).tail();
            LazyList lazyList = LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> LazyList.reverseOnto$$anonfun$1((LazyList)this_, tl));
            Object this_ = object;
            tl = lazyList;
        }
        return tl;
    }

    @Override
    public <B> LazyList<A> diff(Seq<B> that) {
        if (this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return (LazyList)SeqOps.diff$(this, that);
    }

    @Override
    public <B> LazyList<A> intersect(Seq<B> that) {
        if (this.knownIsEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return (LazyList)SeqOps.intersect$(this, that);
    }

    public boolean scala$collection$immutable$LazyList$$lengthGt(int len) {
        while (len >= 0) {
            if (((LazyList)this_).isEmpty()) {
                return false;
            }
            Object object = ((LazyList)this_).tail();
            int n = len - 1;
            Object this_ = object;
            len = n;
        }
        return true;
    }

    @Override
    public Iterator<LazyList<A>> grouped(int size) {
        Predef$.MODULE$.require(size > 0, () -> LazyList.grouped$$anonfun$1(size));
        return this.slidingImpl(size, size);
    }

    @Override
    public Iterator<LazyList<A>> sliding(int size, int step) {
        Predef$.MODULE$.require(size > 0 && step > 0, () -> LazyList.sliding$$anonfun$1(size, step));
        return this.slidingImpl(size, step);
    }

    private Iterator<LazyList<A>> slidingImpl(int size, int step) {
        if (this.knownIsEmpty()) {
            return Iterator$.MODULE$.empty();
        }
        return new SlidingIterator(this, size, step);
    }

    @Override
    public <B> LazyList<B> padTo(int len, B elem) {
        if (len <= 0) {
            return this;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.padTo$$anonfun$1(len, elem));
    }

    @Override
    public <B> LazyList<B> patch(int from, IterableOnce<B> other, int replaced) {
        if (this.knownIsEmpty()) {
            return LazyList$.MODULE$.from((IterableOnce)other);
        }
        return this.patchImpl(from, other, replaced);
    }

    private <B> LazyList<B> patchImpl(int from, IterableOnce<B> other, int replaced) {
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.patchImpl$$anonfun$1(from, other, replaced));
    }

    @Override
    public <B> LazyList<LazyList<B>> transpose(Function1<A, Iterable<B>> asIterable) {
        return (LazyList)IterableOps.transpose$(this, asIterable);
    }

    @Override
    public <B> LazyList<B> updated(int index, B elem) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(BoxesRunTime.boxToInteger(index)));
        }
        return this.updatedImpl(index, elem, index);
    }

    private <B> LazyList<B> updatedImpl(int index, B elem, int startIndex) {
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> this.updatedImpl$$anonfun$1(index, elem, startIndex));
    }

    @Override
    public StringBuilder addString(StringBuilder sb, String start, String sep, String end) {
        this.force();
        this.addStringNoForce(sb.underlying(), start, sep, end);
        return sb;
    }

    private java.lang.StringBuilder addStringNoForce(java.lang.StringBuilder b, String start, String sep, String end) {
        b.append(start);
        if (!this.isEvaluated()) {
            b.append("<not computed>");
        } else if (!this.isEmpty()) {
            b.append(this.head());
            Object cursor = this;
            Object scout = this.tail();
            if (cursor != scout) {
                cursor = scout;
                if (((LazyList)scout).scala$collection$immutable$LazyList$$knownNonEmpty()) {
                    scout = ((LazyList)scout).tail();
                    while (cursor != scout && ((LazyList)scout).scala$collection$immutable$LazyList$$knownNonEmpty()) {
                        LazyList.appendHead$1(b, sep, (LazyList)cursor);
                        cursor = ((LazyList)cursor).tail();
                        if (!((LazyList)(scout = ((LazyList)scout).tail())).scala$collection$immutable$LazyList$$knownNonEmpty()) continue;
                        scout = ((LazyList)scout).tail();
                    }
                }
            }
            if (!((LazyList)scout).scala$collection$immutable$LazyList$$knownNonEmpty()) {
                while (cursor != scout) {
                    LazyList.appendHead$1(b, sep, (LazyList)cursor);
                    cursor = ((LazyList)cursor).tail();
                }
                if (!super.isEvaluated()) {
                    b.append(sep).append("<not computed>");
                }
            } else {
                if (cursor != this) {
                    Object ct;
                    for (Object runner = this; runner != scout; runner = ((LazyList)runner).tail(), scout = ((LazyList)scout).tail()) {
                    }
                    do {
                        if ((ct = ((LazyList)cursor).tail()) == scout) continue;
                        LazyList.appendHead$1(b, sep, (LazyList)cursor);
                    } while ((cursor = ct) != scout);
                }
                b.append(sep).append("<cycle>");
            }
        }
        b.append(end);
        return b;
    }

    @Override
    public String toString() {
        return this.addStringNoForce(new java.lang.StringBuilder(this.className()), "(", ", ", ")").toString();
    }

    @Override
    public boolean hasDefiniteSize() {
        if (!this.isEvaluated()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        Object these = this.tail();
        for (Object those = this; those != these; those = ((LazyList)those).tail()) {
            if (!super.isEvaluated()) {
                return false;
            }
            if (((LazyList)these).isEmpty()) {
                return true;
            }
            if (!super.isEvaluated()) {
                return false;
            }
            if (((LazyList)these).isEmpty()) {
                return true;
            }
            if (those != (these = ((LazyList)these).tail())) continue;
            return false;
        }
        return false;
    }

    private final LazyList lazyAppendedAll$$anonfun$1(Function0 suffix$1) {
        if (this.isEmpty()) {
            IterableOnce iterableOnce = (IterableOnce)suffix$1.apply();
            if (iterableOnce instanceof LazyList) {
                LazyList lazyList;
                LazyList lazyList2 = lazyList = (LazyList)iterableOnce;
                return lazyList2;
            }
            IterableOnce coll = iterableOnce;
            if (coll.knownSize() == 0) {
                return LazyList$.scala$collection$immutable$LazyList$$$Empty;
            }
            IterableOnce coll2 = iterableOnce;
            return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerHeadFromIterator(coll2.iterator());
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(this.head(), ((LazyList)this.tail()).lazyAppendedAll(suffix$1));
    }

    private static final IterableOnce appendedAll$$anonfun$1(IterableOnce suffix$2) {
        return suffix$2;
    }

    private static final IterableOnce appended$$anonfun$1(Object elem$1) {
        return Iterator$.MODULE$.single(elem$1);
    }

    private final LazyList scanLeftImpl$$anonfun$1(Function2 op$1, Object z$1) {
        if (this.isEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return super.scanLeftImpl(op$1.apply(z$1, this.head()), op$1);
    }

    private final LazyList prependedAll$$anonfun$1$$anonfun$1() {
        return this;
    }

    private final LazyList prependedAll$$anonfun$1(IterableOnce prefix$1) {
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerHeadPrependIterator(prefix$1.iterator(), this::prependedAll$$anonfun$1$$anonfun$1);
    }

    private final LazyList mapImpl$$anonfun$1(Function1 f$2) {
        if (this.isEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(f$2.apply(this.head()), super.mapImpl(f$2));
    }

    private final LazyList zip$$anonfun$1(IterableOnce that$1) {
        return this.eagerHeadZipImpl(that$1.iterator());
    }

    private final LazyList eagerHeadZipImpl$$anonfun$1(Iterator it$1) {
        return super.eagerHeadZipImpl(it$1);
    }

    private static final Object zipAll$$anonfun$1(Object thisElem$1) {
        return thisElem$1;
    }

    private static final Object zipAll$$anonfun$2(Object thatElem$1) {
        return thatElem$1;
    }

    private final LazyList zipAll$$anonfun$3(Iterable that$2, Object thisElem$2, Object thatElem$2) {
        return this.eagerHeadZipAllImpl(that$2.iterator(), thisElem$2, thatElem$2);
    }

    private static final Object eagerHeadZipAllImpl$$anonfun$1$$anonfun$1(Object thisElem$4) {
        return thisElem$4;
    }

    private static final LazyList eagerHeadZipAllImpl$$anonfun$1(Object thisElem$3, Iterator it$2) {
        return super.eagerHeadZipImpl(it$2);
    }

    private final LazyList eagerHeadZipAllImpl$$anonfun$2(Iterator it$3, Object thisElem$5, Object thatElem$3) {
        return super.eagerHeadZipAllImpl(it$3, thisElem$5, thatElem$3);
    }

    private static final Object eagerHeadZipAllImpl$$anonfun$3(Object thatElem$4) {
        return thatElem$4;
    }

    private final LazyList dropRight$$anonfun$1(int n$1) {
        Object scout = this;
        int remaining = n$1;
        while (remaining > 0 && !((LazyList)scout).isEmpty()) {
            --remaining;
            scout = ((LazyList)scout).tail();
        }
        return this.eagerHeadDropRightImpl((LazyList<?>)scout);
    }

    private final LazyList eagerHeadDropRightImpl$$anonfun$1(LazyList scout$1) {
        return super.eagerHeadDropRightImpl((LazyList<?>)scout$1.tail());
    }

    private final LazyList takeImpl$$anonfun$1(int n$2) {
        if (this.isEmpty()) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(this.head(), super.takeImpl(n$2 - 1));
    }

    private final LazyList takeWhileImpl$$anonfun$1(Function1 p$1) {
        if (this.isEmpty() || !BoxesRunTime.unboxToBoolean(p$1.apply(this.head()))) {
            return LazyList$.scala$collection$immutable$LazyList$$$Empty;
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(this.head(), super.takeWhileImpl(p$1));
    }

    private static final LazyList reverseOnto$$anonfun$1(LazyList $this$tailLocal5$1, LazyList tl$tailLocal1$1) {
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons($this$tailLocal5$1.head(), tl$tailLocal1$1);
    }

    private static final Object grouped$$anonfun$1(int size$1) {
        return "size must be positive, but was " + size$1;
    }

    private static final Object sliding$$anonfun$1(int size$2, int step$1) {
        return "size=" + size$2 + " and step=" + step$1 + ", but both must be positive";
    }

    private static final Object padTo$$anonfun$1$$anonfun$1(Object elem$3) {
        return elem$3;
    }

    private final LazyList padTo$$anonfun$1(int len$1, Object elem$2) {
        if (this.isEmpty()) {
            return LazyList$.MODULE$.fill(len$1, () -> LazyList.padTo$$anonfun$1$$anonfun$1(elem$2));
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(this.head(), ((LazyList)this.tail()).padTo(len$1 - 1, elem$2));
    }

    private final LazyList patchImpl$$anonfun$1$$anonfun$1(int replaced$2) {
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$dropImpl(this, replaced$2);
    }

    private final LazyList patchImpl$$anonfun$1(int from$1, IterableOnce other$1, int replaced$1) {
        if (from$1 <= 0) {
            return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerHeadPrependIterator(other$1.iterator(), () -> this.patchImpl$$anonfun$1$$anonfun$1(replaced$1));
        }
        if (this.isEmpty()) {
            return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerHeadFromIterator(other$1.iterator());
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(this.head(), super.patchImpl(from$1 - 1, other$1, replaced$1));
    }

    private final LazyList updatedImpl$$anonfun$1(int index$1, Object elem$4, int startIndex$1) {
        if (index$1 <= 0) {
            return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(elem$4, this.tail());
        }
        if (((LazyList)this.tail()).isEmpty()) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(startIndex$1).toString());
        }
        return LazyList$.MODULE$.scala$collection$immutable$LazyList$$$eagerCons(this.head(), super.updatedImpl(index$1 - 1, elem$4, startIndex$1));
    }

    private static final void appendHead$1(java.lang.StringBuilder b$1, String sep$1, LazyList c) {
        b$1.append(sep$1).append(c.head());
    }

    public static final class Deferrer<A> {
        private final Function0<LazyList<A>> l;

        public static <B, A> LazyList<B> $hash$colon$colon$extension(Function0 function0, Function0<B> function02) {
            return LazyList$Deferrer$.MODULE$.$hash$colon$colon$extension(function0, function02);
        }

        public static <B, A> LazyList<B> $hash$colon$colon$colon$extension(Function0 function0, LazyList<B> lazyList) {
            return LazyList$Deferrer$.MODULE$.$hash$colon$colon$colon$extension(function0, lazyList);
        }

        public static <A> boolean equals$extension(Function0 function0, Object object) {
            return LazyList$Deferrer$.MODULE$.equals$extension(function0, object);
        }

        public static <A> int hashCode$extension(Function0 function0) {
            return LazyList$Deferrer$.MODULE$.hashCode$extension(function0);
        }

        public Deferrer(Function0<LazyList<A>> l) {
            this.l = l;
        }

        public int hashCode() {
            return LazyList$Deferrer$.MODULE$.hashCode$extension(this.scala$collection$immutable$LazyList$Deferrer$$l());
        }

        public boolean equals(Object x$0) {
            return LazyList$Deferrer$.MODULE$.equals$extension(this.scala$collection$immutable$LazyList$Deferrer$$l(), x$0);
        }

        public Function0<LazyList<A>> scala$collection$immutable$LazyList$Deferrer$$l() {
            return this.l;
        }

        public <B> LazyList<B> $hash$colon$colon(Function0<B> elem) {
            return LazyList$Deferrer$.MODULE$.$hash$colon$colon$extension(this.scala$collection$immutable$LazyList$Deferrer$$l(), elem);
        }

        public <B> LazyList<B> $hash$colon$colon$colon(LazyList<B> prefix) {
            return LazyList$Deferrer$.MODULE$.$hash$colon$colon$colon$extension(this.scala$collection$immutable$LazyList$Deferrer$$l(), prefix);
        }
    }

    public static final class LazyBuilder<A>
    implements ReusableBuilder<A, LazyList<A>> {
        private DeferredState<A> next;
        private LazyList<A> list;

        public LazyBuilder() {
            Growable.$init$(this);
            Builder.$init$(this);
            this.clear();
        }

        @Override
        public final Growable $plus$eq(Object elem) {
            return Growable.$plus$eq$(this, elem);
        }

        @Override
        public final Growable $plus$eq(Object elem1, Object elem2, scala.collection.immutable.Seq elems) {
            return Growable.$plus$eq$(this, elem1, elem2, elems);
        }

        @Override
        public final Growable $plus$plus$eq(IterableOnce elems) {
            return Growable.$plus$plus$eq$(this, elems);
        }

        @Override
        public int knownSize() {
            return Growable.knownSize$(this);
        }

        @Override
        public void sizeHint(int size) {
            Builder.sizeHint$(this, size);
        }

        @Override
        public final void sizeHint(IterableOnce<?> coll, int delta) {
            Builder.sizeHint$(this, coll, delta);
        }

        @Override
        public int sizeHint$default$2() {
            return Builder.sizeHint$default$2$(this);
        }

        @Override
        public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
            Builder.sizeHintBounded$(this, size, boundingColl);
        }

        @Override
        public <NewTo> Builder<A, NewTo> mapResult(Function1<LazyList<A>, NewTo> f) {
            return Builder.mapResult$(this, f);
        }

        @Override
        public void clear() {
            DeferredState deferred = new DeferredState();
            this.list = LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> LazyList$.scala$collection$immutable$LazyList$LazyBuilder$$_$clear$$anonfun$1(deferred));
            this.next = deferred;
        }

        @Override
        public LazyList<A> result() {
            this.next.init(LazyList$::scala$collection$immutable$LazyList$LazyBuilder$$_$result$$anonfun$1);
            return this.list;
        }

        @Override
        public LazyBuilder<A> addOne(A elem) {
            DeferredState deferred = new DeferredState();
            this.next.init(() -> LazyList$.scala$collection$immutable$LazyList$LazyBuilder$$_$addOne$$anonfun$1(elem, deferred));
            this.next = deferred;
            return this;
        }

        @Override
        public LazyBuilder<A> addAll(IterableOnce<A> xs) {
            if (xs.knownSize() != 0) {
                DeferredState deferred = new DeferredState();
                this.next.init(() -> LazyList$.scala$collection$immutable$LazyList$LazyBuilder$$_$addAll$$anonfun$1(xs, deferred));
                this.next = deferred;
            }
            return this;
        }

        public static final class DeferredState<A> {
            private Function0<LazyList<A>> _tail;

            public LazyList<A> eval() {
                Function0<LazyList<A>> state = this._tail;
                if (state == null) {
                    throw new IllegalStateException("uninitialized");
                }
                return state.apply();
            }

            public void init(Function0<LazyList<A>> state) {
                if (this._tail != null) {
                    throw new IllegalStateException("already initialized");
                }
                this._tail = state;
            }
        }
    }

    public static class LazyIterator<A>
    extends AbstractIterator<A> {
        private LazyList<A> lazyList;

        public LazyIterator(LazyList<A> lazyList) {
            this.lazyList = lazyList;
        }

        private LazyList<A> lazyList() {
            return this.lazyList;
        }

        private void lazyList_$eq(LazyList<A> x$0) {
            this.lazyList = x$0;
        }

        @Override
        public boolean hasNext() {
            return !this.lazyList().isEmpty();
        }

        @Override
        public A next() {
            if (this.lazyList().isEmpty()) {
                return Iterator$.MODULE$.empty().next();
            }
            A res = this.lazyList().head();
            this.lazyList_$eq((LazyList<A>)this.lazyList().tail());
            return res;
        }
    }

    public static final class SerializationProxy<A>
    implements Serializable {
        private static final long serialVersionUID = 4L;
        private transient LazyList<A> coll;

        public SerializationProxy(LazyList<A> coll) {
            this.coll = coll;
        }

        public LazyList<A> coll() {
            return this.coll;
        }

        public void coll_$eq(LazyList<A> x$1) {
            this.coll = x$1;
        }

        private void writeObject(ObjectOutputStream out) {
            out.defaultWriteObject();
            Object these = this.coll();
            while (((LazyList)these).scala$collection$immutable$LazyList$$knownNonEmpty()) {
                out.writeObject(((LazyList)these).head());
                these = ((LazyList)these).tail();
            }
            out.writeObject(SerializeEnd$.MODULE$);
            out.writeObject(these);
        }

        private void readObject(ObjectInputStream in) {
            in.defaultReadObject();
            ListBuffer init2 = new ListBuffer();
            boolean initRead = false;
            while (!initRead) {
                Object object = in.readObject();
                if (SerializeEnd$.MODULE$.equals(object)) {
                    initRead = true;
                    continue;
                }
                Object a = object;
                init2.$plus$eq(a);
            }
            LazyList tail = (LazyList)in.readObject();
            Iterator it = init2.toList().iterator();
            this.coll_$eq(LazyList$.MODULE$.scala$collection$immutable$LazyList$$$newLL(() -> LazyList$.scala$collection$immutable$LazyList$SerializationProxy$$_$readObject$$anonfun$1(it, tail)));
        }

        private Object readResolve() {
            return this.coll();
        }
    }

    public static class SlidingIterator<A>
    extends AbstractIterator<LazyList<A>> {
        private LazyList<A> lazyList;
        private final int size;
        private final int step;
        private final int minLen;
        private boolean first;

        public SlidingIterator(LazyList<A> lazyList, int size, int step) {
            this.lazyList = lazyList;
            this.size = size;
            this.step = step;
            this.minLen = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(size - step), 0);
            this.first = true;
        }

        private LazyList<A> lazyList() {
            return this.lazyList;
        }

        private void lazyList_$eq(LazyList<A> x$0) {
            this.lazyList = x$0;
        }

        @Override
        public boolean hasNext() {
            if (this.first) {
                return !this.lazyList().isEmpty();
            }
            return this.lazyList().scala$collection$immutable$LazyList$$lengthGt(this.minLen);
        }

        @Override
        public LazyList<A> next() {
            if (!this.hasNext()) {
                return (LazyList)Iterator$.MODULE$.empty().next();
            }
            this.first = false;
            LazyList<A> list = this.lazyList();
            this.lazyList_$eq((LazyList<A>)list.drop(this.step));
            return list.take(this.size);
        }
    }

    public static final class WithFilter<A>
    extends scala.collection.WithFilter<A, LazyList> {
        private final LazyList<A> filtered;

        public WithFilter(LazyList<A> lazyList, Function1<A, Object> p) {
            this.filtered = lazyList.filter((Function1)p);
        }

        @Override
        public <B> LazyList<B> map(Function1<A, B> f) {
            return this.filtered.map((Function1)f);
        }

        @Override
        public <B> LazyList<B> flatMap(Function1<A, IterableOnce<B>> f) {
            return this.filtered.flatMap((Function1)f);
        }

        @Override
        public <U> void foreach(Function1<A, U> f) {
            this.filtered.foreach(f);
        }

        @Override
        public scala.collection.WithFilter<A, LazyList> withFilter(Function1<A, Object> q) {
            return new WithFilter<A>(this.filtered, q);
        }
    }
}

