/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class GlobalSatProtocolEncoder
extends StringProtocolEncoder {
    public GlobalSatProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object encodeCommand(Command command) {
        String formattedCommand = null;
        switch (command.getType()) {
            case "custom": {
                formattedCommand = this.formatCommand(command, "GSC,%s,%s", "uniqueId", "data");
                break;
            }
            case "alarmDismiss": {
                formattedCommand = this.formatCommand(command, "GSC,%s,Na", "uniqueId");
                break;
            }
            case "outputControl": {
                formattedCommand = this.formatCommand(command, "GSC,%s,Lo(%s,%s)", "uniqueId", "index", "data");
            }
        }
        if (formattedCommand != null) {
            return formattedCommand + Checksum.nmea(formattedCommand) + "!";
        }
        return null;
    }
}

