/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MoovboxProtocolDecoder
extends BaseHttpProtocolDecoder {
    private final DocumentBuilder documentBuilder;
    private final XPath xPath;
    private final XPathExpression messageExpression;

    public MoovboxProtocolDecoder(Protocol protocol) {
        super(protocol);
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            builderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            builderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            builderFactory.setXIncludeAware(false);
            builderFactory.setExpandEntityReferences(false);
            this.documentBuilder = builderFactory.newDocumentBuilder();
            this.xPath = XPathFactory.newInstance().newXPath();
            this.messageExpression = this.xPath.compile("//gps/coordinates/coordinate");
        }
        catch (ParserConfigurationException | XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        Document document = this.documentBuilder.parse((InputStream)new ByteBufferBackedInputStream(request.content().nioBuffer()));
        String id = document.getDocumentElement().getAttribute("id");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        NodeList nodes = (NodeList)this.messageExpression.evaluate(document, XPathConstants.NODESET);
        LinkedList<Position> positions = new LinkedList<Position>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setValid(true);
            position.setTime(new Date(Long.parseLong(this.xPath.evaluate("time", node)) * 1000L));
            position.setLatitude(Double.parseDouble(this.xPath.evaluate("longitude", node)));
            position.setLongitude(Double.parseDouble(this.xPath.evaluate("latitude", node)));
            position.setAltitude(Double.parseDouble(this.xPath.evaluate("altitude", node)));
            position.setSpeed(Double.parseDouble(this.xPath.evaluate("speed", node)));
            position.set("sat", Integer.parseInt(this.xPath.evaluate("satellites", node)));
            positions.add(position);
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return positions;
    }
}

