/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdgeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class NestedMemberAccess {
    private boolean noSynthFlag;
    private final Map<MethodWrapper, MethodAccess> mapMethodType = new HashMap<MethodWrapper, MethodAccess>();

    public void propagateMemberAccess(ClassesProcessor.ClassNode root) {
        if (root.nested.isEmpty()) {
            return;
        }
        this.noSynthFlag = DecompilerContext.getOption("synthetic-not-set");
        this.computeMethodTypes(root);
        this.eliminateStaticAccess(root);
    }

    private void computeMethodTypes(ClassesProcessor.ClassNode node) {
        if (node.type == ClassesProcessor.ClassNode.Type.LAMBDA) {
            return;
        }
        for (ClassesProcessor.ClassNode nd : node.nested) {
            this.computeMethodTypes(nd);
        }
        for (MethodWrapper method : node.getWrapper().getMethods()) {
            this.computeMethodType(node, method);
        }
    }

    private void computeMethodType(ClassesProcessor.ClassNode node, MethodWrapper method) {
        MethodAccess type = MethodAccess.NORMAL;
        if (method.root != null) {
            DirectGraph graph = method.getOrBuildGraph();
            StructMethod mt = method.methodStruct;
            if ((this.noSynthFlag || mt.isSynthetic()) && mt.hasModifier(8) && graph.nodes.size() == 2) {
                if (graph.first.exprents.size() == 1) {
                    ExitExprent exexpr;
                    Exprent exprent = graph.first.exprents.get(0);
                    MethodDescriptor mtdesc = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                    int parcount = mtdesc.params.length;
                    Exprent exprCore = exprent;
                    if (exprent instanceof ExitExprent && (exexpr = (ExitExprent)exprent).getExitType() == ExitExprent.Type.RETURN && exexpr.getValue() != null) {
                        exprCore = exexpr.getValue();
                    }
                    switch (exprCore.type) {
                        case FIELD: {
                            FieldExprent fexpr = (FieldExprent)exprCore;
                            if ((parcount != 1 || fexpr.isStatic()) && (parcount != 0 || !fexpr.isStatic()) || !fexpr.getClassname().equals(node.classStruct.qualifiedName) || !fexpr.isStatic() && (!(fexpr.getInstance() instanceof VarExprent) || ((VarExprent)fexpr.getInstance()).getIndex() != 0)) break;
                            type = MethodAccess.FIELD_GET;
                            break;
                        }
                        case VAR: {
                            if (parcount != 1 || ((VarExprent)exprCore).getIndex() == 0) break;
                            type = MethodAccess.FIELD_GET;
                            break;
                        }
                        case FUNCTION: {
                            FunctionExprent functionExprent = (FunctionExprent)exprCore;
                            if (!functionExprent.getFuncType().isPPMM() || !(functionExprent.getLstOperands().get(0) instanceof FieldExprent)) break;
                            type = MethodAccess.FUNCTION;
                            break;
                        }
                        case INVOCATION: {
                            type = MethodAccess.METHOD;
                            break;
                        }
                        case ASSIGNMENT: {
                            AssignmentExprent asexpr = (AssignmentExprent)exprCore;
                            if (!(asexpr.getLeft() instanceof FieldExprent) || !(asexpr.getRight() instanceof VarExprent)) break;
                            FieldExprent fexpras = (FieldExprent)asexpr.getLeft();
                            if ((parcount != 2 || fexpras.isStatic()) && (parcount != 1 || !fexpras.isStatic()) || !fexpras.getClassname().equals(node.classStruct.qualifiedName) || !fexpras.isStatic() && (!(fexpras.getInstance() instanceof VarExprent) || ((VarExprent)fexpras.getInstance()).getIndex() != 0) || ((VarExprent)asexpr.getRight()).getIndex() != parcount - 1) break;
                            type = MethodAccess.FIELD_SET;
                        }
                    }
                    if (type == MethodAccess.METHOD) {
                        type = MethodAccess.NORMAL;
                        InvocationExprent invexpr = (InvocationExprent)exprCore;
                        boolean isStatic = invexpr.isStatic();
                        if (isStatic && invexpr.getLstParameters().size() == parcount || !isStatic && invexpr.getInstance() instanceof VarExprent && ((VarExprent)invexpr.getInstance()).getIndex() == 0 && invexpr.getLstParameters().size() == parcount - 1) {
                            boolean equalpars = true;
                            int index = isStatic ? 0 : 1;
                            for (int i = 0; i < invexpr.getLstParameters().size(); ++i) {
                                Exprent parexpr = invexpr.getLstParameters().get(i);
                                if (!(parexpr instanceof VarExprent) || ((VarExprent)parexpr).getIndex() != index) {
                                    equalpars = false;
                                    break;
                                }
                                index += mtdesc.params[i + (isStatic ? 0 : 1)].stackSize;
                            }
                            if (equalpars) {
                                type = MethodAccess.METHOD;
                            }
                        }
                    }
                } else if (graph.first.exprents.size() == 2) {
                    Exprent exprentFirst = graph.first.exprents.get(0);
                    Exprent exprentSecond = graph.first.exprents.get(1);
                    if (exprentFirst instanceof AssignmentExprent && exprentSecond instanceof ExitExprent) {
                        MethodDescriptor mtdesc = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                        int parcount = mtdesc.params.length;
                        AssignmentExprent asexpr = (AssignmentExprent)exprentFirst;
                        if (asexpr.getLeft() instanceof FieldExprent && asexpr.getRight() instanceof VarExprent) {
                            ExitExprent exexpr;
                            FieldExprent fexpras = (FieldExprent)asexpr.getLeft();
                            if ((parcount == 2 && !fexpras.isStatic() || parcount == 1 && fexpras.isStatic()) && fexpras.getClassname().equals(node.classStruct.qualifiedName) && (fexpras.isStatic() || fexpras.getInstance() instanceof VarExprent && ((VarExprent)fexpras.getInstance()).getIndex() == 0) && ((VarExprent)asexpr.getRight()).getIndex() == parcount - 1 && (exexpr = (ExitExprent)exprentSecond).getExitType() == ExitExprent.Type.RETURN && exexpr.getValue() != null && exexpr.getValue() instanceof VarExprent && ((VarExprent)asexpr.getRight()).getIndex() == parcount - 1) {
                                type = MethodAccess.FIELD_SET;
                            }
                        }
                    }
                }
            }
        }
        if (type != MethodAccess.NORMAL) {
            this.mapMethodType.put(method, type);
        } else {
            this.mapMethodType.remove(method);
        }
    }

    private void eliminateStaticAccess(ClassesProcessor.ClassNode node) {
        if (node.type == ClassesProcessor.ClassNode.Type.LAMBDA) {
            return;
        }
        for (MethodWrapper meth : node.getWrapper().getMethods()) {
            if (meth.root == null) continue;
            boolean replaced = false;
            DirectGraph graph = meth.getOrBuildGraph();
            HashSet<DirectNode> setVisited = new HashSet<DirectNode>();
            LinkedList<DirectNode> stack = new LinkedList<DirectNode>();
            stack.add(graph.first);
            while (!stack.isEmpty()) {
                DirectNode nd = (DirectNode)stack.removeFirst();
                if (setVisited.contains(nd)) continue;
                setVisited.add(nd);
                for (int i = 0; i < nd.exprents.size(); ++i) {
                    Exprent ret;
                    Exprent exprent = nd.exprents.get(i);
                    replaced |= this.replaceInvocations(node, meth, exprent);
                    if (!(exprent instanceof InvocationExprent) || (ret = this.replaceAccessExprent(node, meth, (InvocationExprent)exprent)) == null) continue;
                    nd.exprents.set(i, ret);
                    replaced = true;
                }
                for (DirectEdge suc : nd.getSuccessors(DirectEdgeType.REGULAR)) {
                    stack.add(suc.getDestination());
                }
            }
            if (!replaced) continue;
            this.computeMethodType(node, meth);
        }
        for (ClassesProcessor.ClassNode child : node.nested) {
            this.eliminateStaticAccess(child);
        }
    }

    private boolean replaceInvocations(ClassesProcessor.ClassNode caller, MethodWrapper meth, Exprent exprent) {
        boolean found;
        boolean res = false;
        for (Exprent expr : exprent.getAllExprents()) {
            res |= this.replaceInvocations(caller, meth, expr);
        }
        block1: do {
            found = false;
            for (Exprent expr : exprent.getAllExprents()) {
                Exprent newexpr;
                if (!(expr instanceof InvocationExprent) || (newexpr = this.replaceAccessExprent(caller, meth, (InvocationExprent)expr)) == null) continue;
                exprent.replaceExprent(expr, newexpr);
                found = true;
                res = true;
                continue block1;
            }
        } while (found);
        return res;
    }

    private static boolean sameTree(ClassesProcessor.ClassNode caller, ClassesProcessor.ClassNode callee) {
        if (caller.classStruct.qualifiedName.equals(callee.classStruct.qualifiedName)) {
            return false;
        }
        while (caller.parent != null) {
            caller = caller.parent;
        }
        while (callee.parent != null) {
            callee = callee.parent;
        }
        return caller == callee;
    }

    private Exprent replaceAccessExprent(ClassesProcessor.ClassNode caller, MethodWrapper methdest, InvocationExprent invexpr) {
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(invexpr.getClassname());
        MethodWrapper methsource = null;
        if (node != null && node.getWrapper() != null) {
            methsource = node.getWrapper().getMethodWrapper(invexpr.getName(), invexpr.getStringDescriptor());
        }
        if (methsource == null || !this.mapMethodType.containsKey(methsource)) {
            return null;
        }
        if (node.classStruct.qualifiedName.equals(caller.classStruct.qualifiedName) && methsource.methodStruct.getName().equals(methdest.methodStruct.getName()) && methsource.methodStruct.getDescriptor().equals(methdest.methodStruct.getDescriptor())) {
            return null;
        }
        MethodAccess type = this.mapMethodType.get(methsource);
        if (!NestedMemberAccess.sameTree(caller, node)) {
            return null;
        }
        DirectGraph graph = methsource.getOrBuildGraph();
        Exprent source = graph.first.exprents.get(0);
        Exprent retexprent = null;
        switch (type) {
            case FIELD_GET: {
                ExitExprent exsource = (ExitExprent)source;
                if (exsource.getValue() instanceof VarExprent) {
                    VarExprent var = (VarExprent)exsource.getValue();
                    String varname = methsource.varproc.getVarName(new VarVersionPair(var));
                    if (!methdest.setOuterVarNames.contains(varname)) {
                        VarNamesCollector vnc = new VarNamesCollector();
                        vnc.addName(varname);
                        methdest.varproc.refreshVarNames(vnc);
                        methdest.setOuterVarNames.add(varname);
                    }
                    int index = methdest.counter.getCounterAndIncrement(2);
                    VarExprent ret = new VarExprent(index, var.getVarType(), methdest.varproc);
                    methdest.varproc.setVarName(new VarVersionPair(index, 0), varname);
                    retexprent = ret;
                    break;
                }
                Exprent ret = (FieldExprent)exsource.getValue().copy();
                if (!((FieldExprent)ret).isStatic()) {
                    ((FieldExprent)ret).replaceExprent(((FieldExprent)ret).getInstance(), invexpr.getLstParameters().get(0));
                }
                retexprent = ret;
                break;
            }
            case FIELD_SET: {
                Exprent ret;
                if (source instanceof ExitExprent) {
                    ExitExprent extex = (ExitExprent)source;
                    ret = (AssignmentExprent)extex.getValue().copy();
                } else {
                    ret = (AssignmentExprent)source.copy();
                }
                FieldExprent fexpr = (FieldExprent)((AssignmentExprent)ret).getLeft();
                if (fexpr.isStatic()) {
                    ((AssignmentExprent)ret).replaceExprent(((AssignmentExprent)ret).getRight(), invexpr.getLstParameters().get(0));
                } else {
                    ((AssignmentExprent)ret).replaceExprent(((AssignmentExprent)ret).getRight(), invexpr.getLstParameters().get(1));
                    fexpr.replaceExprent(fexpr.getInstance(), invexpr.getLstParameters().get(0));
                }
                ((AssignmentExprent)ret).getLeft().bytecode = null;
                ((AssignmentExprent)ret).getRight().bytecode = null;
                retexprent = ret;
                break;
            }
            case FUNCTION: {
                retexprent = NestedMemberAccess.replaceFunction(invexpr, source);
                break;
            }
            case METHOD: {
                if (source instanceof ExitExprent) {
                    source = ((ExitExprent)source).getValue();
                }
                InvocationExprent invret = (InvocationExprent)source.copy();
                int index = 0;
                if (!invret.isStatic()) {
                    invret.replaceExprent(invret.getInstance(), invexpr.getLstParameters().get(0));
                    index = 1;
                }
                for (int i = 0; i < invret.getLstParameters().size(); ++i) {
                    invret.replaceExprent(invret.getLstParameters().get(i), invexpr.getLstParameters().get(i + index));
                }
                retexprent = invret;
            }
        }
        if (retexprent != null) {
            StructMethod mt;
            retexprent.bytecode = null;
            retexprent.addBytecodeOffsets(invexpr.bytecode);
            boolean hide = true;
            if (!(node.type != ClassesProcessor.ClassNode.Type.ROOT && (node.access & 8) == 0 || (mt = methsource.methodStruct).isSynthetic())) {
                hide = false;
            }
            if (hide) {
                node.getWrapper().getHiddenMembers().add(InterpreterUtil.makeUniqueKey(invexpr.getName(), invexpr.getStringDescriptor()));
            }
        }
        return retexprent;
    }

    private static Exprent replaceFunction(InvocationExprent invexpr, Exprent source) {
        FunctionExprent functionExprent = (FunctionExprent)((ExitExprent)source).getValue().copy();
        List<Exprent> lstParameters = invexpr.getLstParameters();
        FieldExprent fieldExprent = (FieldExprent)functionExprent.getLstOperands().get(0);
        if (fieldExprent.isStatic()) {
            if (!lstParameters.isEmpty()) {
                return null;
            }
            return functionExprent;
        }
        if (lstParameters.size() != 1) {
            return null;
        }
        fieldExprent.replaceExprent(fieldExprent.getInstance(), lstParameters.get(0));
        return functionExprent;
    }

    private static enum MethodAccess {
        NORMAL,
        FIELD_GET,
        FIELD_SET,
        METHOD,
        FUNCTION;

    }
}

