/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util.token;

import org.jetbrains.java.decompiler.main.extern.TextTokenVisitor;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.token.TextRange;

public class TextTokenDumpVisitor
extends TextTokenVisitor {
    private final TextBuffer buffer;
    private TextBuffer text;

    public TextTokenDumpVisitor(TextTokenVisitor next, TextBuffer buffer) {
        super(next);
        this.buffer = buffer;
    }

    private TextBuffer range(TextRange range) {
        this.text.append("(").append(this.buffer.getPos(range.start));
        this.text.append(", ").append(this.buffer.getPos(range.getEnd()));
        return this.text.append(")");
    }

    private TextBuffer declaration(boolean declaration) {
        return this.text.append(declaration ? "[declaration]" : "[reference]");
    }

    @Override
    public void start(String content) {
        super.start(content);
        this.text = new TextBuffer();
        this.text.appendLineSeparator().append("/*").appendLineSeparator().append("Tokens:").appendLineSeparator();
    }

    @Override
    public void visitClass(TextRange range, boolean declaration, String name) {
        super.visitClass(range, declaration, name);
        this.range(range).append(" class ");
        this.declaration(declaration).append(" ");
        this.text.append(name);
        this.text.appendLineSeparator();
    }

    @Override
    public void visitField(TextRange range, boolean declaration, String className, String name, FieldDescriptor descriptor) {
        super.visitField(range, declaration, className, name, descriptor);
        this.range(range).append(" field ");
        this.declaration(declaration).append(" ");
        this.text.append(className);
        this.text.append("#").append(name);
        this.text.append(":").append(descriptor.descriptorString);
        this.text.appendLineSeparator();
    }

    @Override
    public void visitMethod(TextRange range, boolean declaration, String className, String name, MethodDescriptor descriptor) {
        super.visitMethod(range, declaration, className, name, descriptor);
        this.range(range).append(" method ");
        this.declaration(declaration).append(" ");
        this.text.append(className);
        this.text.append("#").append(name);
        this.text.append(descriptor.toString());
        this.text.appendLineSeparator();
    }

    private void visitVariable(boolean declaration, String className, String methodName, MethodDescriptor methodDescriptor, int index, String name) {
        this.declaration(declaration).append(" ");
        this.text.append(className);
        this.text.append("#").append(methodName);
        this.text.append(methodDescriptor.toString());
        this.text.append("(").append(index);
        this.text.append(":").append(name).append(")");
        this.text.appendLineSeparator();
    }

    @Override
    public void visitParameter(TextRange range, boolean declaration, String className, String methodName, MethodDescriptor methodDescriptor, int index, String name) {
        super.visitParameter(range, declaration, className, methodName, methodDescriptor, index, name);
        this.range(range).append(" parameter ");
        this.visitVariable(declaration, className, methodName, methodDescriptor, index, name);
    }

    @Override
    public void visitLocal(TextRange range, boolean declaration, String className, String methodName, MethodDescriptor methodDescriptor, int index, String name) {
        super.visitLocal(range, declaration, className, methodName, methodDescriptor, index, name);
        this.range(range).append(" local ");
        this.visitVariable(declaration, className, methodName, methodDescriptor, index, name);
    }

    @Override
    public void end() {
        super.end();
        this.text.append("*/").appendLineSeparator();
        this.buffer.append(this.text.convertToStringAndAllowDataDiscard());
    }
}

