/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.beaninfo.editors.PropertiesEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PropertiesCustomEditor
extends JPanel
implements DocumentListener {
    private PropertiesEditor editor;
    private JEditorPane editorPane;
    private JTextField warnings;

    public PropertiesCustomEditor(PropertiesEditor propertiesEditor) {
        this.editor = propertiesEditor;
        this.initComponents();
        Properties properties = (Properties)this.editor.getValue();
        if (properties == null) {
            properties = new Properties();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, "");
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        try {
            this.editorPane.setText(byteArrayOutputStream.toString("ISO-8859-1").replaceAll("(?m)^#.*" + System.getProperty("line.separator"), ""));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        HelpCtx.setHelpIDString((JComponent)this, (String)PropertiesCustomEditor.class.getName());
        this.editorPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PropertiesCustomEditor.class).getString("ACS_PropertiesEditorPane"));
        this.editorPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PropertiesCustomEditor.class).getString("ACSD_PropertiesEditorPane"));
        this.editorPane.getDocument().addDocumentListener(this);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PropertiesCustomEditor.class).getString("ACSD_CustomPropertiesEditor"));
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.change();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.change();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void change() {
        Properties properties = new Properties();
        boolean bl = false;
        try {
            properties.load(new ByteArrayInputStream(this.editorPane.getText().getBytes(StandardCharsets.ISO_8859_1)));
            bl = true;
        }
        catch (Exception exception) {
            Color color = UIManager.getColor("nb.errorForeground");
            if (color != null) {
                this.warnings.setForeground(color);
            }
            this.warnings.setText(exception.toString());
        }
        if (bl) {
            this.editor.setValue(properties);
            if (Pattern.compile("^#", 8).matcher(this.editorPane.getText()).find()) {
                Color color = UIManager.getColor("nb.warningForeground");
                if (color != null) {
                    this.warnings.setForeground(color);
                }
                this.warnings.setText(NbBundle.getMessage(PropertiesCustomEditor.class, (String)"WARN_PropertiesComments"));
            } else {
                this.warnings.setText(null);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 400);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.editorPane = new JEditorPane();
        this.editorPane.setContentType("text/x-properties");
        this.editorPane.setPreferredSize(new Dimension(200, 100));
        this.add((Component)new JScrollPane(this.editorPane), "Center");
        this.warnings = new JTextField(30);
        this.warnings.setEditable(false);
        this.add((Component)this.warnings, "South");
    }
}

