/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.utils;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleObjCache<K, V> {
    private final int maxSize;
    private final ConcurrentHashMap<K, ValueWrapper> map;

    public SimpleObjCache(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Cache max size cannot be zero or less");
        }
        this.maxSize = n;
        this.map = new ConcurrentHashMap();
    }

    public V put(K k, V v) {
        this.evictIfFull();
        ValueWrapper valueWrapper = this.map.put(k, new ValueWrapper(v));
        if (valueWrapper != null) {
            return (V)valueWrapper.value;
        }
        return null;
    }

    public V get(K k) {
        ValueWrapper valueWrapper = this.map.get(k);
        if (valueWrapper != null) {
            valueWrapper.lastUsed.set(System.currentTimeMillis());
            return (V)valueWrapper.value;
        }
        return null;
    }

    public int getCacheSize() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    private synchronized void evictIfFull() {
        K k;
        if (this.map.size() >= this.maxSize && (k = this.findEvictionCandidate()) != null) {
            this.map.remove(k);
        }
    }

    private K findEvictionCandidate() {
        Optional<Map.Entry> optional = this.map.entrySet().stream().min(Comparator.comparingLong(entry -> ((ValueWrapper)entry.getValue()).lastUsed.get()));
        if (optional.isPresent()) {
            return optional.get().getKey();
        }
        return null;
    }

    private class ValueWrapper {
        private final AtomicLong lastUsed = new AtomicLong(System.currentTimeMillis());
        private final V value;

        public ValueWrapper(V v) {
            this.value = v;
        }
    }
}

