/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import nu.validator.checker.Checker;
import nu.validator.checker.LocatorImpl;
import org.htmlunit.csp.Policy;
import org.htmlunit.csp.url.URI;
import org.htmlunit.csp.url.URLWithScheme;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class CspEnforcementChecker
extends Checker {
    private static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private static final String CSP_POLICY_ATTRIBUTE = "http://validator.nu/properties/csp-policy";
    private static final String[] EVENT_HANDLERS = new String[]{"onabort", "onauxclick", "onbeforeinput", "onbeforematch", "onbeforetoggle", "onblur", "oncancel", "oncanplay", "oncanplaythrough", "onchange", "onclick", "onclose", "oncontextlost", "oncontextmenu", "oncontextrestored", "oncopy", "oncuechange", "oncut", "ondblclick", "ondrag", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop", "ondurationchange", "onemptied", "onended", "onerror", "onfocus", "onformdata", "ongotpointercapture", "oninput", "oninvalid", "onkeydown", "onkeypress", "onkeyup", "onload", "onloadeddata", "onloadedmetadata", "onloadstart", "onlostpointercapture", "onmousedown", "onmouseenter", "onmouseleave", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onpaste", "onpause", "onplay", "onplaying", "onpointercancel", "onpointerdown", "onpointerenter", "onpointerleave", "onpointermove", "onpointerout", "onpointerover", "onpointerrawupdate", "onpointerup", "onprogress", "onratechange", "onreset", "onresize", "onscroll", "onscrollend", "onsecuritypolicyviolation", "onseeked", "onseeking", "onselect", "onslotchange", "onstalled", "onsubmit", "onsuspend", "ontimeupdate", "ontoggle", "onvolumechange", "onwaiting", "onwheel"};
    private Locator locator;
    private Policy httpPolicy;
    private Policy metaPolicy;
    private List<ResourceInfo> resources;
    private boolean collectingScriptContent;
    private StringBuilder scriptContent;
    private Locator scriptLocator;
    private String scriptNonce;
    private boolean collectingStyleContent;
    private StringBuilder styleContent;
    private Locator styleLocator;
    private String styleNonce;

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        Object policyObj;
        this.resources = new ArrayList<ResourceInfo>();
        this.httpPolicy = null;
        this.metaPolicy = null;
        this.collectingScriptContent = false;
        this.scriptContent = null;
        this.scriptLocator = null;
        this.scriptNonce = null;
        this.collectingStyleContent = false;
        this.styleContent = null;
        this.styleLocator = null;
        this.styleNonce = null;
        if (this.getRequest() != null && (policyObj = this.getRequest().getAttribute(CSP_POLICY_ATTRIBUTE)) instanceof Policy) {
            this.httpPolicy = (Policy)policyObj;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String styleAttr;
        String data;
        String rel;
        String src;
        if (!XHTML_NS.equals(uri)) {
            return;
        }
        if ("meta".equals(localName)) {
            String content;
            String httpEquiv = atts.getValue("", "http-equiv");
            if (httpEquiv != null && "content-security-policy".equalsIgnoreCase(httpEquiv) && (content = atts.getValue("", "content")) != null && !content.isEmpty()) {
                try {
                    this.metaPolicy = Policy.parseSerializedCSP(content, (severity, message, directiveIndex, valueIndex) -> {});
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return;
        }
        if ("script".equals(localName)) {
            src = atts.getValue("", "src");
            String nonce = atts.getValue("", "nonce");
            String integrity = atts.getValue("", "integrity");
            if (src != null && !src.isEmpty()) {
                this.resources.add(new ResourceInfo(ResourceInfo.Type.EXTERNAL_SCRIPT, src, nonce, integrity, null, null, new LocatorImpl(this.locator)));
            } else {
                this.collectingScriptContent = true;
                this.scriptContent = new StringBuilder();
                this.scriptLocator = new LocatorImpl(this.locator);
                this.scriptNonce = nonce;
            }
        }
        if ("style".equals(localName)) {
            String nonce = atts.getValue("", "nonce");
            this.collectingStyleContent = true;
            this.styleContent = new StringBuilder();
            this.styleLocator = new LocatorImpl(this.locator);
            this.styleNonce = nonce;
        }
        if ("link".equals(localName) && (rel = atts.getValue("", "rel")) != null && rel.toLowerCase().contains("stylesheet")) {
            String href = atts.getValue("", "href");
            String nonce = atts.getValue("", "nonce");
            if (href != null && !href.isEmpty()) {
                this.resources.add(new ResourceInfo(ResourceInfo.Type.EXTERNAL_STYLE, href, nonce, null, null, null, new LocatorImpl(this.locator)));
            }
        }
        if ("img".equals(localName) && (src = atts.getValue("", "src")) != null && !src.isEmpty()) {
            this.resources.add(new ResourceInfo(ResourceInfo.Type.IMAGE, src, null, null, null, null, new LocatorImpl(this.locator)));
        }
        if ("iframe".equals(localName) && (src = atts.getValue("", "src")) != null && !src.isEmpty()) {
            this.resources.add(new ResourceInfo(ResourceInfo.Type.FRAME, src, null, null, null, null, new LocatorImpl(this.locator)));
        }
        if ("object".equals(localName) && (data = atts.getValue("", "data")) != null && !data.isEmpty()) {
            this.resources.add(new ResourceInfo(ResourceInfo.Type.OBJECT, data, null, null, null, null, new LocatorImpl(this.locator)));
        }
        if ("embed".equals(localName) && (src = atts.getValue("", "src")) != null && !src.isEmpty()) {
            this.resources.add(new ResourceInfo(ResourceInfo.Type.OBJECT, src, null, null, null, null, new LocatorImpl(this.locator)));
        }
        if (("video".equals(localName) || "audio".equals(localName)) && (src = atts.getValue("", "src")) != null && !src.isEmpty()) {
            this.resources.add(new ResourceInfo(ResourceInfo.Type.MEDIA, src, null, null, null, null, new LocatorImpl(this.locator)));
        }
        if ((styleAttr = atts.getValue("", "style")) != null && !styleAttr.isEmpty()) {
            this.resources.add(new ResourceInfo(ResourceInfo.Type.STYLE_ATTRIBUTE, null, null, null, styleAttr, "style", new LocatorImpl(this.locator)));
        }
        for (String handler : EVENT_HANDLERS) {
            String value = atts.getValue("", handler);
            if (value == null || value.isEmpty()) continue;
            this.resources.add(new ResourceInfo(ResourceInfo.Type.SCRIPT_ATTRIBUTE, null, null, null, value, handler, new LocatorImpl(this.locator)));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.collectingScriptContent && this.scriptContent != null) {
            this.scriptContent.append(ch, start, length);
        }
        if (this.collectingStyleContent && this.styleContent != null) {
            this.styleContent.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String content;
        if (!XHTML_NS.equals(uri)) {
            return;
        }
        if ("script".equals(localName) && this.collectingScriptContent) {
            content = this.scriptContent.toString().trim();
            if (!content.isEmpty()) {
                this.resources.add(new ResourceInfo(ResourceInfo.Type.INLINE_SCRIPT, null, this.scriptNonce, null, content, null, this.scriptLocator));
            }
            this.collectingScriptContent = false;
            this.scriptContent = null;
            this.scriptLocator = null;
            this.scriptNonce = null;
        }
        if ("style".equals(localName) && this.collectingStyleContent) {
            content = this.styleContent.toString().trim();
            if (!content.isEmpty()) {
                this.resources.add(new ResourceInfo(ResourceInfo.Type.INLINE_STYLE, null, this.styleNonce, null, content, null, this.styleLocator));
            }
            this.collectingStyleContent = false;
            this.styleContent = null;
            this.styleLocator = null;
            this.styleNonce = null;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.httpPolicy == null && this.metaPolicy == null) {
            return;
        }
        for (ResourceInfo resource : this.resources) {
            this.checkResource(resource);
        }
    }

    private void checkResource(ResourceInfo resource) throws SAXException {
        boolean allowedByMeta;
        boolean allowedByHttp = this.httpPolicy == null || this.isAllowedByPolicy(this.httpPolicy, resource);
        boolean bl = allowedByMeta = this.metaPolicy == null || this.isAllowedByPolicy(this.metaPolicy, resource);
        if (!allowedByHttp || !allowedByMeta) {
            String message = this.buildViolationMessage(resource, !allowedByHttp);
            this.warn(message, resource.locator);
        }
    }

    private boolean isAllowedByPolicy(Policy policy, ResourceInfo resource) {
        try {
            switch (resource.type.ordinal()) {
                case 0: {
                    return policy.allowsExternalScript(Optional.ofNullable(resource.nonce), Optional.ofNullable(resource.integrity), this.parseUrl(resource.src), Optional.of(true), Optional.empty());
                }
                case 1: {
                    return policy.allowsInlineScript(Optional.ofNullable(resource.nonce), Optional.ofNullable(resource.content), Optional.of(true));
                }
                case 2: {
                    return policy.allowsScriptAsAttribute(Optional.ofNullable(resource.content));
                }
                case 3: {
                    return policy.allowsExternalStyle(Optional.ofNullable(resource.nonce), this.parseUrl(resource.src), Optional.empty());
                }
                case 4: {
                    return policy.allowsInlineStyle(Optional.ofNullable(resource.nonce), Optional.ofNullable(resource.content));
                }
                case 5: {
                    return policy.allowsStyleAsAttribute(Optional.ofNullable(resource.content));
                }
                case 6: {
                    return policy.allowsImage(this.parseUrl(resource.src), Optional.empty());
                }
                case 7: {
                    return policy.allowsFrame(this.parseUrl(resource.src), Optional.empty());
                }
                case 8: {
                    return policy.allowsObject(this.parseUrl(resource.src), Optional.empty());
                }
                case 9: {
                    return policy.allowsMedia(this.parseUrl(resource.src), Optional.empty());
                }
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    private Optional<URLWithScheme> parseUrl(String url) {
        if (url == null || url.isEmpty()) {
            return Optional.empty();
        }
        try {
            Optional<URI> uri = URI.parseURI(url);
            if (uri.isPresent()) {
                return Optional.of((URLWithScheme)uri.get());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private String buildViolationMessage(ResourceInfo resource, boolean violatesHttpPolicy) {
        String source = violatesHttpPolicy ? "HTTP header" : "meta tag";
        switch (resource.type.ordinal()) {
            case 0: {
                return String.format("Resource violates Content Security Policy (%s): external script \u201c%s\u201d blocked by \u201cscript-src\u201d directive.", source, this.truncate(resource.src, 50));
            }
            case 1: {
                return String.format("Inline script violates Content Security Policy (%s): blocked by \u201cscript-src\u201d directive (missing \u201c\u2018unsafe-inline\u2019\u201d or nonce/hash).", source);
            }
            case 2: {
                return String.format("Event handler attribute \u201c%s\u201d violates Content Security Policy (%s): blocked by \u201cscript-src\u201d directive.", resource.attrName, source);
            }
            case 3: {
                return String.format("Resource violates Content Security Policy (%s): external stylesheet \u201c%s\u201d blocked by \u201cstyle-src\u201d directive.", source, this.truncate(resource.src, 50));
            }
            case 4: {
                return String.format("Inline style violates Content Security Policy (%s): blocked by \u201cstyle-src\u201d directive (missing \u201c\u2018unsafe-inline\u2019\u201d or nonce/hash).", source);
            }
            case 5: {
                return String.format("The \u201cstyle\u201d attribute violates Content Security Policy (%s): blocked by \u201cstyle-src\u201d directive.", source);
            }
            case 6: {
                return String.format("Resource violates Content Security Policy (%s): image \u201c%s\u201d blocked by \u201cimg-src\u201d directive.", source, this.truncate(resource.src, 50));
            }
            case 7: {
                return String.format("Resource violates Content Security Policy (%s): frame \u201c%s\u201d blocked by \u201cframe-src\u201d directive.", source, this.truncate(resource.src, 50));
            }
            case 8: {
                return String.format("Resource violates Content Security Policy (%s): object/embed \u201c%s\u201d blocked by \u201cobject-src\u201d directive.", source, this.truncate(resource.src, 50));
            }
            case 9: {
                return String.format("Resource violates Content Security Policy (%s): media \u201c%s\u201d blocked by \u201cmedia-src\u201d directive.", source, this.truncate(resource.src, 50));
            }
        }
        return "Resource violates Content Security Policy.";
    }

    private String truncate(String s, int maxLen) {
        if (s == null) {
            return "";
        }
        if (s.length() <= maxLen) {
            return s;
        }
        return s.substring(0, maxLen - 3) + "...";
    }

    @Override
    public void reset() {
        this.resources = null;
        this.httpPolicy = null;
        this.metaPolicy = null;
        this.collectingScriptContent = false;
        this.scriptContent = null;
        this.scriptLocator = null;
        this.scriptNonce = null;
        this.collectingStyleContent = false;
        this.styleContent = null;
        this.styleLocator = null;
        this.styleNonce = null;
    }

    private static class ResourceInfo {
        final Type type;
        final String src;
        final String nonce;
        final String integrity;
        final String content;
        final String attrName;
        final Locator locator;

        ResourceInfo(Type type, String src, String nonce, String integrity, String content, String attrName, Locator locator) {
            this.type = type;
            this.src = src;
            this.nonce = nonce;
            this.integrity = integrity;
            this.content = content;
            this.attrName = attrName;
            this.locator = locator;
        }

        static enum Type {
            EXTERNAL_SCRIPT,
            INLINE_SCRIPT,
            SCRIPT_ATTRIBUTE,
            EXTERNAL_STYLE,
            INLINE_STYLE,
            STYLE_ATTRIBUTE,
            IMAGE,
            FRAME,
            OBJECT,
            MEDIA;

        }
    }
}

