/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.test;

import java.util.Arrays;
import nu.validator.checker.AttributeUtil;

public class AttributeUtilTest {
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) {
        System.out.println("Testing parseInteger...");
        AttributeUtilTest.testParseIntegerBasic();
        AttributeUtilTest.testParseIntegerWithWhitespace();
        AttributeUtilTest.testParseIntegerWithTrailingGarbage();
        AttributeUtilTest.testParseIntegerNegative();
        AttributeUtilTest.testParseIntegerEdgeCases();
        System.out.println();
        System.out.println("Testing parseNonNegativeInteger...");
        AttributeUtilTest.testParseNonNegativeInteger();
        System.out.println();
        System.out.println("Testing parsePositiveInteger...");
        AttributeUtilTest.testParsePositiveInteger();
        System.out.println();
        System.out.println("Testing split...");
        AttributeUtilTest.testSplitBasic();
        AttributeUtilTest.testSplitWithVariousWhitespace();
        AttributeUtilTest.testSplitEdgeCases();
        System.out.println();
        System.out.println("Testing lowerCaseLiteralEqualsIgnoreAsciiCaseString...");
        AttributeUtilTest.testAsciiCaseInsensitiveEquals();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static void testParseIntegerBasic() {
        AttributeUtilTest.assertEquals("parseInteger: simple positive", 42, AttributeUtil.parseInteger("42"));
        AttributeUtilTest.assertEquals("parseInteger: zero", 0, AttributeUtil.parseInteger("0"));
        AttributeUtilTest.assertEquals("parseInteger: large number", 123456789, AttributeUtil.parseInteger("123456789"));
    }

    private static void testParseIntegerWithWhitespace() {
        AttributeUtilTest.assertEquals("parseInteger: leading space", 42, AttributeUtil.parseInteger(" 42"));
        AttributeUtilTest.assertEquals("parseInteger: leading tab", 42, AttributeUtil.parseInteger("\t42"));
        AttributeUtilTest.assertEquals("parseInteger: leading newline", 42, AttributeUtil.parseInteger("\n42"));
        AttributeUtilTest.assertEquals("parseInteger: leading CR", 42, AttributeUtil.parseInteger("\r42"));
        AttributeUtilTest.assertEquals("parseInteger: multiple leading whitespace", 42, AttributeUtil.parseInteger("  \t\n\r 42"));
    }

    private static void testParseIntegerWithTrailingGarbage() {
        AttributeUtilTest.assertEquals("parseInteger: trailing text fails", Integer.MIN_VALUE, AttributeUtil.parseInteger("42abc"));
        AttributeUtilTest.assertEquals("parseInteger: trailing space fails", Integer.MIN_VALUE, AttributeUtil.parseInteger("42 "));
    }

    private static void testParseIntegerNegative() {
        AttributeUtilTest.assertEquals("parseInteger: negative number", -42, AttributeUtil.parseInteger("-42"));
        AttributeUtilTest.assertEquals("parseInteger: negative with leading space", -42, AttributeUtil.parseInteger(" -42"));
        AttributeUtilTest.assertEquals("parseInteger: negative zero", 0, AttributeUtil.parseInteger("-0"));
    }

    private static void testParseIntegerEdgeCases() {
        AttributeUtilTest.assertEquals("parseInteger: null returns MIN_VALUE", Integer.MIN_VALUE, AttributeUtil.parseInteger(null));
        AttributeUtilTest.assertEquals("parseInteger: empty string returns MIN_VALUE", Integer.MIN_VALUE, AttributeUtil.parseInteger(""));
        AttributeUtilTest.assertEquals("parseInteger: only whitespace returns MIN_VALUE", Integer.MIN_VALUE, AttributeUtil.parseInteger("   "));
        AttributeUtilTest.assertEquals("parseInteger: non-numeric returns MIN_VALUE", Integer.MIN_VALUE, AttributeUtil.parseInteger("abc"));
        AttributeUtilTest.assertEquals("parseInteger: plus sign not allowed", Integer.MIN_VALUE, AttributeUtil.parseInteger("+42"));
        AttributeUtilTest.assertEquals("parseInteger: overflow returns MIN_VALUE", Integer.MIN_VALUE, AttributeUtil.parseInteger("99999999999999999999"));
    }

    private static void testParseNonNegativeInteger() {
        AttributeUtilTest.assertEquals("parseNonNegativeInteger: positive", 42, AttributeUtil.parseNonNegativeInteger("42"));
        AttributeUtilTest.assertEquals("parseNonNegativeInteger: zero", 0, AttributeUtil.parseNonNegativeInteger("0"));
        AttributeUtilTest.assertEquals("parseNonNegativeInteger: negative returns -1", -1, AttributeUtil.parseNonNegativeInteger("-42"));
        AttributeUtilTest.assertEquals("parseNonNegativeInteger: null returns -1", -1, AttributeUtil.parseNonNegativeInteger(null));
        AttributeUtilTest.assertEquals("parseNonNegativeInteger: with leading whitespace", 42, AttributeUtil.parseNonNegativeInteger("  42"));
    }

    private static void testParsePositiveInteger() {
        AttributeUtilTest.assertEquals("parsePositiveInteger: positive", 42, AttributeUtil.parsePositiveInteger("42"));
        AttributeUtilTest.assertEquals("parsePositiveInteger: one", 1, AttributeUtil.parsePositiveInteger("1"));
        AttributeUtilTest.assertEquals("parsePositiveInteger: zero returns -1", -1, AttributeUtil.parsePositiveInteger("0"));
        AttributeUtilTest.assertEquals("parsePositiveInteger: negative returns -1", -1, AttributeUtil.parsePositiveInteger("-42"));
        AttributeUtilTest.assertEquals("parsePositiveInteger: null returns -1", -1, AttributeUtil.parsePositiveInteger(null));
    }

    private static void testSplitBasic() {
        AttributeUtilTest.assertArrayEquals("split: single word", new String[]{"hello"}, AttributeUtil.split("hello"));
        AttributeUtilTest.assertArrayEquals("split: two words", new String[]{"hello", "world"}, AttributeUtil.split("hello world"));
        AttributeUtilTest.assertArrayEquals("split: three words", new String[]{"a", "b", "c"}, AttributeUtil.split("a b c"));
    }

    private static void testSplitWithVariousWhitespace() {
        AttributeUtilTest.assertArrayEquals("split: multiple spaces", new String[]{"hello", "world"}, AttributeUtil.split("hello   world"));
        AttributeUtilTest.assertArrayEquals("split: tabs", new String[]{"hello", "world"}, AttributeUtil.split("hello\tworld"));
        AttributeUtilTest.assertArrayEquals("split: newlines", new String[]{"hello", "world"}, AttributeUtil.split("hello\nworld"));
        AttributeUtilTest.assertArrayEquals("split: mixed whitespace", new String[]{"a", "b", "c"}, AttributeUtil.split("a \t\n\r b   c"));
        AttributeUtilTest.assertArrayEquals("split: leading whitespace", new String[]{"hello", "world"}, AttributeUtil.split("  hello world"));
        AttributeUtilTest.assertArrayEquals("split: trailing whitespace", new String[]{"hello", "world"}, AttributeUtil.split("hello world  "));
        AttributeUtilTest.assertArrayEquals("split: leading and trailing", new String[]{"hello"}, AttributeUtil.split("  hello  "));
    }

    private static void testSplitEdgeCases() {
        AttributeUtilTest.assertArrayEquals("split: null returns empty", new String[0], AttributeUtil.split(null));
        AttributeUtilTest.assertArrayEquals("split: empty string returns empty", new String[0], AttributeUtil.split(""));
        AttributeUtilTest.assertArrayEquals("split: only whitespace returns empty", new String[0], AttributeUtil.split("   \t\n  "));
    }

    private static void testAsciiCaseInsensitiveEquals() {
        AttributeUtilTest.assertTrue("asciiEquals: exact match", AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("hello", "hello"));
        AttributeUtilTest.assertTrue("asciiEquals: uppercase input", AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("hello", "HELLO"));
        AttributeUtilTest.assertTrue("asciiEquals: mixed case input", AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("hello", "HeLLo"));
        AttributeUtilTest.assertFalse("asciiEquals: different strings", AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("hello", "world"));
        AttributeUtilTest.assertFalse("asciiEquals: different lengths", AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("hello", "hi"));
        AttributeUtilTest.assertFalse("asciiEquals: null string", AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("hello", null));
        AttributeUtilTest.assertTrue("asciiEquals: empty strings", AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("", ""));
        AttributeUtilTest.assertTrue("asciiEquals: with digits", AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("abc123", "ABC123"));
        AttributeUtilTest.assertTrue("asciiEquals: with special chars", AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("hello-world", "HELLO-WORLD"));
    }

    private static void assertEquals(String testName, int expected, int actual) {
        if (expected == actual) {
            AttributeUtilTest.pass(testName);
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected: " + expected);
            System.out.println("  Actual: " + actual);
            ++failed;
        }
    }

    private static void assertArrayEquals(String testName, String[] expected, String[] actual) {
        if (Arrays.equals(expected, actual)) {
            AttributeUtilTest.pass(testName);
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected: " + Arrays.toString(expected));
            System.out.println("  Actual: " + Arrays.toString(actual));
            ++failed;
        }
    }

    private static void assertTrue(String testName, boolean condition) {
        if (condition) {
            AttributeUtilTest.pass(testName);
        } else {
            AttributeUtilTest.fail(testName);
        }
    }

    private static void assertFalse(String testName, boolean condition) {
        AttributeUtilTest.assertTrue(testName, !condition);
    }

    private static void pass(String testName) {
        System.out.println("PASS: " + testName);
        ++passed;
    }

    private static void fail(String testName) {
        System.out.println("FAIL: " + testName);
        ++failed;
    }
}

