/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public final class TailBiasedSortedSet<E>
extends AbstractSet<E>
implements SortedSet<E> {
    private final Comparator<? super E> comparator;
    private final Node<E> head = new Node<Object>(null, null, null);
    private final Node<E> tail = new Node<Object>(null, null, null);
    private int size = 0;

    public TailBiasedSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    public TailBiasedSortedSet() {
        this.comparator = null;
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    public TailBiasedSortedSet(SortedSet<E> set) {
        this.comparator = set.comparator();
        this.head.next = this.tail;
        this.tail.prev = this.head;
        for (Object e : set) {
            this.add(e);
        }
    }

    public TailBiasedSortedSet(Collection<? extends E> collection) {
        this.comparator = null;
        this.head.next = this.tail;
        this.tail.prev = this.head;
        for (E e : collection) {
            this.add(e);
        }
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl(this.head.next, this.tail);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E first() {
        Node first = this.head.next;
        if (first == this.tail) {
            throw new NoSuchElementException();
        }
        return (E)first.value;
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E last() {
        Node last = this.tail.prev;
        if (last == this.head) {
            throw new NoSuchElementException();
        }
        return (E)last.value;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        Node<Object> next = this.tail;
        while (next.prev != this.head) {
            Node prev = next.prev;
            int comp = this.compare(o, prev.value);
            if (comp > 0) {
                prev.next = new Node<E>(o, next, prev);
                next.prev = prev.next;
                ++this.size;
                return true;
            }
            if (comp == 0) {
                return false;
            }
            next = next.prev;
        }
        this.head.next = new Node<E>(o, next, this.head);
        next.prev = this.head.next;
        ++this.size;
        return true;
    }

    private int compare(E one, E other) {
        if (this.comparator == null) {
            return ((Comparable)one).compareTo(other);
        }
        return this.comparator.compare(one, other);
    }

    @Override
    public void clear() {
        this.size = 0;
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    private final class Node<F> {
        public final F value;
        public Node<F> next;
        public Node<F> prev;

        public Node(F value, Node<F> next, Node<F> prev) {
            this.value = value;
            this.next = next;
            this.prev = prev;
        }
    }

    private final class IteratorImpl
    implements Iterator<E> {
        private Node<E> next;
        private final Node<E> sentinel;

        IteratorImpl(Node<E> first, Node<E> sentinel) {
            this.next = first;
            this.sentinel = sentinel;
        }

        @Override
        public boolean hasNext() {
            return this.next != this.sentinel;
        }

        @Override
        public E next() {
            if (this.next == this.sentinel) {
                throw new NoSuchElementException();
            }
            Object rv = this.next.value;
            this.next = this.next.next;
            return rv;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

