/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;

public abstract class AbstractInt
extends AbstractDatatype {
    protected AbstractInt() {
    }

    protected void checkInt(CharSequence literal, int offset) throws DatatypeException {
        if (literal.length() == 0) {
            throw this.newDatatypeException("The empty string is not a valid integer.");
        }
        char c = literal.charAt(0);
        if (c != '-' && !this.isAsciiDigit(c)) {
            throw this.newDatatypeException(0, "Expected a minus sign or a digit but saw ", c, " instead.");
        }
        for (int i = 1; i < literal.length(); ++i) {
            c = literal.charAt(i);
            if (this.isAsciiDigit(c)) continue;
            throw this.newDatatypeException(offset + i, "Expected a digit but saw ", c, " instead.");
        }
    }

    protected void checkIntNonNegative(CharSequence literal, int offset) throws DatatypeException {
        if (literal.length() == 0) {
            throw this.newDatatypeException("The empty string is not a valid non-negative integer.");
        }
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (this.isAsciiDigit(c)) continue;
            throw this.newDatatypeException(offset + i, "Expected a digit but saw ", c, " instead.");
        }
    }

    protected void checkIntPositive(CharSequence literal, int offset) throws DatatypeException {
        if (literal.length() == 0) {
            throw this.newDatatypeException("The empty string is not a valid positive integer.");
        }
        boolean zero = true;
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (!this.isAsciiDigit(c)) {
                throw this.newDatatypeException(offset + i, "Expected a digit but saw ", c, " instead.");
            }
            if (c == '0') continue;
            zero = false;
        }
        if (zero) {
            throw this.newDatatypeException("Zero is not a positive integer.");
        }
    }
}

