/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;

public final class BrowsingContextOrKeyword
extends AbstractDatatype {
    public static final BrowsingContextOrKeyword THE_INSTANCE = new BrowsingContextOrKeyword();

    private BrowsingContextOrKeyword() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        if (literal.length() == 0) {
            throw this.newDatatypeException("Browsing context name must be at least one character long.");
        }
        if (literal.charAt(0) == '_') {
            String kw = BrowsingContextOrKeyword.toAsciiLowerCase(literal.toString().substring(1));
            if (!("blank".equals(kw) || "self".equals(kw) || "top".equals(kw) || "parent".equals(kw))) {
                throw this.newDatatypeException("Reserved keyword ", kw, " used.");
            }
        } else {
            return;
        }
    }

    @Override
    public String getName() {
        return "browsing context name or keyword";
    }
}

