/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;
import org.htmlunit.csp.value.Hash;

public final class IntegrityMetadata
extends AbstractDatatype {
    public static final IntegrityMetadata THE_INSTANCE = new IntegrityMetadata();
    private static final Pattern THE_PATTERN = Pattern.compile("^(?:sha256|sha384|sha512)-(.+$)", 2);
    private static final boolean WARN = System.getProperty("nu.validator.datatype.warn", "").equals("true");

    private IntegrityMetadata() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        StringBuilder builder = new StringBuilder();
        int len = literal.length();
        for (int i = 0; i < len; ++i) {
            char c = literal.charAt(i);
            if (this.isWhitespace(c) && builder.length() > 0) {
                this.checkToken(literal, builder, i);
                builder.setLength(0);
                continue;
            }
            if (this.isWhitespace(c)) continue;
            builder.append(c);
        }
        if (builder.length() > 0) {
            this.checkToken(literal, builder, len);
        }
    }

    private void checkToken(CharSequence literal, StringBuilder builder, int i) throws DatatypeException {
        String token = builder.toString();
        Matcher m = this.getPattern().matcher(token);
        if (m.matches()) {
            String hashWithQuotes = "'" + token + "'";
            if (!Hash.parseHash(hashWithQuotes).isPresent()) {
                throw this.newDatatypeException(i - 1, "Invalid base64 value.", WARN);
            }
        } else {
            throw this.newDatatypeException(i - 1, "Values must start with \u201csha256-\u201d or \u201csha384-\u201d or \u201csha512-\u201d.");
        }
    }

    protected Pattern getPattern() {
        return THE_PATTERN;
    }

    @Override
    public String getName() {
        return "integrity-metadata";
    }
}

