/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;

public class MetaCharset
extends AbstractDatatype {
    public static final MetaCharset THE_INSTANCE = new MetaCharset();

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        String lower = MetaCharset.toAsciiLowerCase(literal);
        if (!lower.startsWith("text/html;")) {
            throw this.newDatatypeException("The legacy encoding declaration did not start with ", "text/html;", ".");
        }
        if (lower.length() == 10) {
            throw this.newDatatypeException("The legacy encoding declaration ended prematurely.");
        }
        String encodingName = this.extractCharset(lower, 10);
        if (encodingName == null) {
            throw this.newDatatypeException("The legacy encoding declaration did not contain ", "charset=", " followed by a valid encoding name.");
        }
        if (!"utf-8".equals(encodingName)) {
            throw this.newDatatypeException("\u201ccharset=\u201d must be followed by \u201cutf-8\u201d.");
        }
    }

    private String extractCharset(String lower, int start) throws DatatypeException {
        int pos = start;
        int len = lower.length();
        while (pos < len) {
            int valueEnd;
            int valueStart;
            int charsetPos = lower.indexOf("charset", pos);
            if (charsetPos == -1) {
                return null;
            }
            for (pos = charsetPos + 7; pos < len && MetaCharset.isAsciiWhitespace(lower.charAt(pos)); ++pos) {
            }
            if (pos >= len) {
                return null;
            }
            if (lower.charAt(pos) != '=') continue;
            ++pos;
            while (pos < len && MetaCharset.isAsciiWhitespace(lower.charAt(pos))) {
                ++pos;
            }
            if (pos >= len) {
                throw this.newDatatypeException("The empty string is not a valid character encoding name.");
            }
            char c = lower.charAt(pos);
            if (c == '\"') {
                valueStart = pos + 1;
                valueEnd = lower.indexOf(34, valueStart);
                if (valueEnd == -1) {
                    return null;
                }
            } else if (c == '\'') {
                valueStart = pos + 1;
                valueEnd = lower.indexOf(39, valueStart);
                if (valueEnd == -1) {
                    return null;
                }
            } else {
                char vc;
                valueStart = pos;
                for (valueEnd = pos; valueEnd < len && !MetaCharset.isAsciiWhitespace(vc = lower.charAt(valueEnd)) && vc != ';'; ++valueEnd) {
                }
            }
            if (valueStart == valueEnd) {
                throw this.newDatatypeException("The empty string is not a valid character encoding name.");
            }
            String encodingName = lower.substring(valueStart, valueEnd);
            for (int i = 0; i < encodingName.length(); ++i) {
                char ec = encodingName.charAt(i);
                if (ec >= '0' && ec <= '9' || ec >= 'a' && ec <= 'z' || ec == '-' || ec == '!' || ec == '#' || ec == '$' || ec == '%' || ec == '&' || ec == '\'' || ec == '+' || ec == '_' || ec == '`' || ec == '{' || ec == '}' || ec == '~' || ec == '^') continue;
                throw this.newDatatypeException("The legacy encoding contained ", ec, ", which is not a valid character in an encoding name.");
            }
            return encodingName;
        }
        return null;
    }

    private static boolean isAsciiWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\f' || c == '\r';
    }

    @Override
    public String getName() {
        return "legacy character encoding declaration";
    }
}

