/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.HashSet;
import nu.validator.datatype.AbstractDatatype;
import nu.validator.vendor.relaxng.datatype.DatatypeException;

public class MimeType
extends AbstractDatatype {
    public static final MimeType THE_INSTANCE = new MimeType();
    private static final HashSet<String> JAVASCRIPT_MIME_TYPES = new HashSet();

    protected MimeType() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        State state = State.AT_START;
        block23: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (state.ordinal()) {
                case 0: {
                    if (this.isTokenChar(c)) {
                        state = State.IN_SUPERTYPE;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected a token character but saw ", c, " instead.");
                }
                case 1: {
                    if (this.isTokenChar(c)) continue block23;
                    if (c == '/') {
                        state = State.AT_SUBTYPE_START;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected a token character or \u201c/\u201d but saw ", c, " instead.");
                }
                case 2: {
                    if (this.isTokenChar(c)) {
                        state = State.IN_SUBTYPE;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected a token character but saw ", c, " instead.");
                }
                case 3: {
                    if (this.isTokenChar(c)) continue block23;
                    if (this.isScriptType() && JAVASCRIPT_MIME_TYPES.contains(literal.subSequence(0, i).toString())) {
                        throw this.newDatatypeException("A JavaScript MIME type must not contain any characters after the subtype.");
                    }
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        continue block23;
                    }
                    if (this.isWhitespace(c)) {
                        state = State.WS_BEFORE_SEMICOLON;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected a token character, whitespace or a semicolon but saw ", c, " instead.");
                }
                case 5: {
                    if (this.isWhitespace(c)) continue block23;
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected whitespace or a semicolon but saw ", c, " instead.");
                }
                case 4: {
                    if (this.isWhitespace(c)) continue block23;
                    if (this.isTokenChar(c)) {
                        state = State.IN_PARAM_NAME;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected whitespace or a token character but saw ", c, " instead.");
                }
                case 6: {
                    if (this.isTokenChar(c)) continue block23;
                    if (c == '=') {
                        state = State.EQUALS_SEEN;
                        continue block23;
                    }
                }
                case 7: {
                    if (c == '\"') {
                        state = State.IN_QUOTED_STRING;
                        continue block23;
                    }
                    if (this.isTokenChar(c)) {
                        state = State.IN_UNQUOTED_STRING;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected a double quote or a token character but saw ", c, " instead.");
                }
                case 8: {
                    if (c == '\\') {
                        state = State.IN_QUOTED_PAIR;
                        continue block23;
                    }
                    if (c == '\"') {
                        state = State.CLOSE_QUOTE_SEEN;
                        continue block23;
                    }
                    if (this.isQDTextChar(c)) continue block23;
                    throw this.newDatatypeException(i, "Expected a non-control ASCII character but saw ", c, " instead.");
                }
                case 10: {
                    if (c <= '\u007f') {
                        state = State.IN_QUOTED_STRING;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected an ASCII character but saw ", c, " instead.");
                }
                case 11: {
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        continue block23;
                    }
                    if (this.isWhitespace(c)) {
                        state = State.WS_BEFORE_SEMICOLON;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected an ASCII character but saw ", c, " instead.");
                }
                case 9: {
                    if (this.isTokenChar(c)) continue block23;
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        continue block23;
                    }
                    if (this.isWhitespace(c)) {
                        state = State.WS_BEFORE_SEMICOLON;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected a token character, whitespace or a semicolon but saw ", c, " instead.");
                }
            }
        }
        switch (state.ordinal()) {
            case 3: 
            case 9: 
            case 11: {
                return;
            }
            case 0: {
                throw this.newDatatypeException("Expected a MIME type but saw the empty string.");
            }
            case 1: 
            case 2: {
                throw this.newDatatypeException(literal.length() - 1, "Subtype missing.");
            }
            case 6: 
            case 7: {
                throw this.newDatatypeException(literal.length() - 1, "Parameter value missing.");
            }
            case 8: 
            case 10: {
                throw this.newDatatypeException(literal.length() - 1, "Unfinished quoted string.");
            }
            case 4: {
                throw this.newDatatypeException(literal.length() - 1, "Semicolon seen but there was no parameter following it.");
            }
            case 5: {
                throw this.newDatatypeException(literal.length() - 1, "Extraneous trailing whitespace.");
            }
        }
    }

    private boolean isQDTextChar(char c) {
        return c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\t';
    }

    private boolean isTokenChar(char c) {
        return c >= '!' && c <= '~' && c != '(' && c != ')' && c != '<' && c != '>' && c != '@' && c != ',' && c != ';' && c != ':' && c != '\\' && c != '\"' && c != '/' && c != '[' && c != ']' && c != '?' && c != '=' && c != '{' && c != '}';
    }

    protected boolean isScriptType() {
        return false;
    }

    @Override
    public String getName() {
        return "MIME type";
    }

    static {
        JAVASCRIPT_MIME_TYPES.add("application/ecmascript");
        JAVASCRIPT_MIME_TYPES.add("application/javascript");
        JAVASCRIPT_MIME_TYPES.add("application/x-ecmascript");
        JAVASCRIPT_MIME_TYPES.add("application/x-javascript");
        JAVASCRIPT_MIME_TYPES.add("text/ecmascript");
        JAVASCRIPT_MIME_TYPES.add("text/javascript");
        JAVASCRIPT_MIME_TYPES.add("text/javascript1.0");
        JAVASCRIPT_MIME_TYPES.add("text/javascript1.1");
        JAVASCRIPT_MIME_TYPES.add("text/javascript1.2");
        JAVASCRIPT_MIME_TYPES.add("text/javascript1.3");
        JAVASCRIPT_MIME_TYPES.add("text/javascript1.4");
        JAVASCRIPT_MIME_TYPES.add("text/javascript1.5");
        JAVASCRIPT_MIME_TYPES.add("text/jscript");
        JAVASCRIPT_MIME_TYPES.add("text/livescript");
        JAVASCRIPT_MIME_TYPES.add("text/x-ecmascript");
        JAVASCRIPT_MIME_TYPES.add("text/x-javascript");
    }

    private static enum State {
        AT_START,
        IN_SUPERTYPE,
        AT_SUBTYPE_START,
        IN_SUBTYPE,
        SEMICOLON_SEEN,
        WS_BEFORE_SEMICOLON,
        IN_PARAM_NAME,
        EQUALS_SEEN,
        IN_QUOTED_STRING,
        IN_UNQUOTED_STRING,
        IN_QUOTED_PAIR,
        CLOSE_QUOTE_SEEN;

    }
}

