/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages.test;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import nu.validator.messages.MessageEmitterAdapter;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.BadAttributeValueException;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.ImpossibleAttributeIgnoredException;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.OnlyTextNotAllowedException;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.OutOfContextElementException;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.RequiredAttributesMissingException;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.RequiredAttributesMissingOneOfException;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.RequiredElementsMissingException;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.RequiredElementsMissingOneOfException;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.StringNotAllowedException;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.TextNotAllowedException;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.UnfinishedElementException;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.UnfinishedElementOneOfException;
import nu.validator.vendor.thaiopensource.relaxng.exceptions.UnknownElementException;
import nu.validator.vendor.thaiopensource.xml.util.Name;

public class MessageEmitterAdapterTest {
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) throws Exception {
        System.out.println("Testing RequiredElementsMissing...");
        MessageEmitterAdapterTest.testRequiredElementsMissing();
        MessageEmitterAdapterTest.testRequiredElementsMissingWithName();
        System.out.println();
        System.out.println("Testing RequiredElementsMissingOneOf...");
        MessageEmitterAdapterTest.testRequiredElementsMissingOneOf();
        System.out.println();
        System.out.println("Testing UnfinishedElement...");
        MessageEmitterAdapterTest.testUnfinishedElement();
        MessageEmitterAdapterTest.testUnfinishedElementWithName();
        System.out.println();
        System.out.println("Testing UnfinishedElementOneOf...");
        MessageEmitterAdapterTest.testUnfinishedElementOneOf();
        System.out.println();
        System.out.println("Testing ImpossibleAttributeIgnored...");
        MessageEmitterAdapterTest.testImpossibleAttributeIgnored();
        System.out.println();
        System.out.println("Testing OutOfContextElement...");
        MessageEmitterAdapterTest.testOutOfContextElement();
        System.out.println();
        System.out.println("Testing UnknownElement...");
        MessageEmitterAdapterTest.testUnknownElement();
        System.out.println();
        System.out.println("Testing TextNotAllowed...");
        MessageEmitterAdapterTest.testTextNotAllowed();
        System.out.println();
        System.out.println("Testing OnlyTextNotAllowed...");
        MessageEmitterAdapterTest.testOnlyTextNotAllowed();
        System.out.println();
        System.out.println("Testing RequiredAttributesMissing...");
        MessageEmitterAdapterTest.testRequiredAttributesMissing();
        System.out.println();
        System.out.println("Testing RequiredAttributesMissingOneOf...");
        MessageEmitterAdapterTest.testRequiredAttributesMissingOneOf();
        System.out.println();
        System.out.println("Testing BadAttributeValue...");
        MessageEmitterAdapterTest.testBadAttributeValue();
        System.out.println();
        System.out.println("Testing StringNotAllowed...");
        MessageEmitterAdapterTest.testStringNotAllowed();
        System.out.println();
        System.out.println("Testing filter pattern matching...");
        MessageEmitterAdapterTest.testFilterPatternMatching();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static void testRequiredElementsMissing() throws Exception {
        Name head = new Name("http://www.w3.org/1999/xhtml", "head");
        RequiredElementsMissingException ex = new RequiredElementsMissingException(null, head, null, head);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("RequiredElementsMissing (no name)", displayMsg, "is missing a required child element");
    }

    private static void testRequiredElementsMissingWithName() throws Exception {
        Name head = new Name("http://www.w3.org/1999/xhtml", "head");
        RequiredElementsMissingException ex = new RequiredElementsMissingException(null, head, "title", head);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("RequiredElementsMissing (with name)", displayMsg, "is missing a required instance of child element");
        MessageEmitterAdapterTest.assertContains("RequiredElementsMissing (with name)", displayMsg, "title");
    }

    private static void testUnfinishedElement() throws Exception {
        Name head = new Name("http://www.w3.org/1999/xhtml", "head");
        UnfinishedElementException ex = new UnfinishedElementException(null, head, null, null);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("UnfinishedElement (no name)", displayMsg, "is missing a required child element");
    }

    private static void testUnfinishedElementWithName() throws Exception {
        Name head = new Name("http://www.w3.org/1999/xhtml", "head");
        UnfinishedElementException ex = new UnfinishedElementException(null, head, "title", null);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("UnfinishedElement (with name)", displayMsg, "is missing a required instance of child element");
        MessageEmitterAdapterTest.assertContains("UnfinishedElement (with name)", displayMsg, "title");
    }

    private static void testImpossibleAttributeIgnored() throws Exception {
        Name div = new Name("http://www.w3.org/1999/xhtml", "div");
        Name foo = new Name("", "foo");
        ImpossibleAttributeIgnoredException ex = new ImpossibleAttributeIgnoredException(null, div, null, foo);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("ImpossibleAttributeIgnored", displayMsg, "not allowed on element");
        MessageEmitterAdapterTest.assertContains("ImpossibleAttributeIgnored", displayMsg, "at this point");
    }

    private static void testRequiredElementsMissingOneOf() throws Exception {
        Name select = new Name("http://www.w3.org/1999/xhtml", "select");
        Name body = new Name("http://www.w3.org/1999/xhtml", "body");
        HashSet<String> missingElements = new HashSet<String>();
        missingElements.add("option");
        missingElements.add("optgroup");
        RequiredElementsMissingOneOfException ex = new RequiredElementsMissingOneOfException(null, select, missingElements, body);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("RequiredElementsMissingOneOf", displayMsg, "is missing a required instance of one or more of the following child elements");
    }

    private static void testUnfinishedElementOneOf() throws Exception {
        Name select = new Name("http://www.w3.org/1999/xhtml", "select");
        Name body = new Name("http://www.w3.org/1999/xhtml", "body");
        HashSet<String> missingElements = new HashSet<String>();
        missingElements.add("option");
        missingElements.add("optgroup");
        UnfinishedElementOneOfException ex = new UnfinishedElementOneOfException(null, select, missingElements, body);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("UnfinishedElementOneOf", displayMsg, "is missing a required instance of one or more of the following child elements");
    }

    private static void testOutOfContextElement() throws Exception {
        Name div = new Name("http://www.w3.org/1999/xhtml", "div");
        Name head = new Name("http://www.w3.org/1999/xhtml", "head");
        OutOfContextElementException ex = new OutOfContextElementException(null, div, head);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("OutOfContextElement (contains element)", displayMsg, "not allowed as child of");
    }

    private static void testUnknownElement() throws Exception {
        Name foo = new Name("http://www.w3.org/1999/xhtml", "foo");
        Name body = new Name("http://www.w3.org/1999/xhtml", "body");
        UnknownElementException ex = new UnknownElementException(null, foo, body);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("UnknownElement", displayMsg, "not allowed");
    }

    private static void testTextNotAllowed() throws Exception {
        Name select = new Name("http://www.w3.org/1999/xhtml", "select");
        TextNotAllowedException ex = new TextNotAllowedException(null, select);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("TextNotAllowed", displayMsg, "Text not allowed in");
    }

    private static void testOnlyTextNotAllowed() throws Exception {
        Name div = new Name("http://www.w3.org/1999/xhtml", "div");
        Name body = new Name("http://www.w3.org/1999/xhtml", "body");
        OnlyTextNotAllowedException ex = new OnlyTextNotAllowedException(null, div, body);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("OnlyTextNotAllowed", displayMsg, "is not allowed to have content that consists solely of text");
    }

    private static void testRequiredAttributesMissing() throws Exception {
        Name img = new Name("http://www.w3.org/1999/xhtml", "img");
        Name body = new Name("http://www.w3.org/1999/xhtml", "body");
        RequiredAttributesMissingException ex = new RequiredAttributesMissingException(null, img, "src", body);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("RequiredAttributesMissing", displayMsg, "is missing required attribute");
        MessageEmitterAdapterTest.assertContains("RequiredAttributesMissing (attr name)", displayMsg, "src");
    }

    private static void testRequiredAttributesMissingOneOf() throws Exception {
        Name input = new Name("http://www.w3.org/1999/xhtml", "input");
        Name form = new Name("http://www.w3.org/1999/xhtml", "form");
        HashSet<String> missingAttrs = new HashSet<String>();
        missingAttrs.add("name");
        missingAttrs.add("id");
        RequiredAttributesMissingOneOfException ex = new RequiredAttributesMissingOneOfException(null, input, missingAttrs, form);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("RequiredAttributesMissingOneOf", displayMsg, "is missing one or more of the following attributes");
    }

    private static void testBadAttributeValue() throws Exception {
        Name input = new Name("http://www.w3.org/1999/xhtml", "input");
        Name form = new Name("http://www.w3.org/1999/xhtml", "form");
        Name type = new Name("", "type");
        HashMap exceptions = new HashMap();
        BadAttributeValueException ex = new BadAttributeValueException(null, input, form, type, "foobar", exceptions);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertContains("BadAttributeValue", displayMsg, "Bad value");
    }

    private static void testStringNotAllowed() throws Exception {
        Name option = new Name("http://www.w3.org/1999/xhtml", "option");
        Name select = new Name("http://www.w3.org/1999/xhtml", "select");
        HashMap exceptions = new HashMap();
        StringNotAllowedException ex = new StringNotAllowedException(null, option, select, "invalid content", exceptions);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        MessageEmitterAdapterTest.assertNotNull("StringNotAllowed has display message", displayMsg);
    }

    private static void testFilterPatternMatching() throws Exception {
        Name head = new Name("http://www.w3.org/1999/xhtml", "head");
        RequiredElementsMissingException ex = new RequiredElementsMissingException(null, head, "title", head);
        String displayMsg = MessageEmitterAdapterTest.getDisplayMessage(ex);
        Pattern userPattern = Pattern.compile(".*missing a required instance of child element.*");
        MessageEmitterAdapterTest.assertTrue("Filter pattern matches display message", userPattern.matcher(displayMsg).matches());
        Pattern oldInternalPattern = Pattern.compile(".*is missing required child element.*");
        MessageEmitterAdapterTest.assertFalse("Old internal pattern should NOT match display message", oldInternalPattern.matcher(displayMsg).matches());
    }

    private static String getDisplayMessage(Exception ex) throws Exception {
        MessageEmitterAdapter adapter = new MessageEmitterAdapter();
        Method method = MessageEmitterAdapter.class.getDeclaredMethod("getDisplayMessage", Exception.class);
        method.setAccessible(true);
        return (String)method.invoke((Object)adapter, ex);
    }

    private static void assertContains(String testName, String actual, String expected) {
        if (actual != null && actual.contains(expected)) {
            System.out.println("PASS: " + testName);
            ++passed;
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected to contain: " + expected);
            System.out.println("  Actual: " + actual);
            ++failed;
        }
    }

    private static void assertTrue(String testName, boolean condition) {
        if (condition) {
            System.out.println("PASS: " + testName);
            ++passed;
        } else {
            System.out.println("FAIL: " + testName);
            ++failed;
        }
    }

    private static void assertFalse(String testName, boolean condition) {
        if (!condition) {
            System.out.println("PASS: " + testName);
            ++passed;
        } else {
            System.out.println("FAIL: " + testName);
            ++failed;
        }
    }

    private static void assertNotNull(String testName, Object value) {
        if (value != null) {
            System.out.println("PASS: " + testName);
            ++passed;
        } else {
            System.out.println("FAIL: " + testName);
            System.out.println("  Expected: non-null");
            System.out.println("  Actual: null");
            ++failed;
        }
    }
}

