/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.source;

import nu.validator.source.Line;
import nu.validator.source.SourceCode;

public final class Location
implements Comparable<Location>,
Cloneable {
    private final SourceCode owner;
    private final int line;
    private final int column;

    Location(SourceCode owner, int line, int column) {
        this.owner = owner;
        if (line < 0) {
            line = 0;
            column = 0;
        } else if (column < 0) {
            if (--line < 0) {
                line = 0;
                column = 0;
            } else {
                Line sourceLine = owner.getLine(line);
                column = sourceLine != null ? sourceLine.getBufferLength() : 0;
            }
        }
        this.line = line;
        this.column = column;
    }

    @Override
    public int compareTo(Location o) {
        if (this.line < o.line) {
            return -1;
        }
        if (this.line > o.line) {
            return 1;
        }
        if (this.column < o.column) {
            return -1;
        }
        if (this.column > o.column) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location loc = (Location)obj;
            return this.line == loc.line && this.column == loc.column;
        }
        return false;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public int hashCode() {
        return (this.line << 16) + this.column;
    }

    Location next() {
        return this.step(1);
    }

    Location prev() {
        return this.step(-1);
    }

    Location step(int offset) {
        int newLine = this.line;
        int newColumn = this.column;
        if (offset > 0) {
            for (int i = 0; i < offset && newLine != this.owner.getNumberOfLines(); ++i) {
                ++newColumn;
                Line sourceLine = this.owner.getLine(newLine);
                if (sourceLine == null) break;
                if (newColumn <= sourceLine.getBufferLength()) continue;
                ++newLine;
                newColumn = 0;
            }
            return new Location(this.owner, newLine, newColumn);
        }
        if (offset < 0) {
            offset = -offset;
            for (int i = 0; i < offset && (newLine != 0 || newColumn != 0); ++i) {
                Line sourceLine;
                if (--newColumn != -1) continue;
                newColumn = (sourceLine = this.owner.getLine(--newLine)) != null ? sourceLine.getBufferLength() : 0;
            }
            return new Location(this.owner, newLine, newColumn);
        }
        return this;
    }

    public String toString() {
        return this.line + ", " + this.column;
    }
}

