/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.datatype.xsd;

import nu.validator.vendor.relaxng.datatype.DatatypeException;
import nu.validator.vendor.relaxng.datatype.DatatypeStreamingValidator;
import nu.validator.vendor.relaxng.datatype.ValidationContext;
import nu.validator.vendor.relaxng.datatype.helpers.StreamingValidatorImpl;
import nu.validator.vendor.thaiopensource.datatype.Datatype2;
import nu.validator.vendor.thaiopensource.datatype.xsd.Measure;
import nu.validator.vendor.thaiopensource.datatype.xsd.OrderRelation;

abstract class DatatypeBase
implements Datatype2 {
    private final int whiteSpace;
    static final int WHITE_SPACE_PRESERVE = 0;
    static final int WHITE_SPACE_REPLACE = 1;
    static final int WHITE_SPACE_COLLAPSE = 2;

    abstract boolean lexicallyAllows(String var1);

    DatatypeBase() {
        this.whiteSpace = 2;
    }

    DatatypeBase(int n) {
        this.whiteSpace = n;
    }

    int getWhiteSpace() {
        return this.whiteSpace;
    }

    @Override
    public boolean isValid(String string, ValidationContext validationContext) {
        return this.lexicallyAllows(string = this.normalizeWhiteSpace(string)) && this.allowsValue(string, validationContext);
    }

    @Override
    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        if (!this.isValid(string, validationContext)) {
            throw new DatatypeException();
        }
    }

    @Override
    public Object createValue(String string, ValidationContext validationContext) {
        if (!this.lexicallyAllows(string = this.normalizeWhiteSpace(string))) {
            return null;
        }
        return this.getValue(string, validationContext);
    }

    final String normalizeWhiteSpace(String string) {
        switch (this.whiteSpace) {
            case 2: {
                return DatatypeBase.collapseWhiteSpace(string);
            }
            case 1: {
                return DatatypeBase.replaceWhiteSpace(string);
            }
        }
        return string;
    }

    boolean allowsValue(String string, ValidationContext validationContext) {
        return true;
    }

    abstract Object getValue(String var1, ValidationContext var2);

    OrderRelation getOrderRelation() {
        return null;
    }

    Measure getMeasure() {
        return null;
    }

    private static final String collapseWhiteSpace(String string) {
        int n = DatatypeBase.collapseStart(string);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
        boolean bl = n == 0 || string.charAt(n - 1) == ' ';
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl) break;
                    stringBuffer.append(' ');
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static final int collapseStart(String string) {
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case ' ': {
                    if (i != 0 && string.charAt(i - 1) != ' ' && i != n - 1) continue block4;
                    return i;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    return i;
                }
            }
        }
        return -1;
    }

    private static final String replaceWhiteSpace(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': {
                    char[] cArray = string.toCharArray();
                    cArray[i] = 32;
                    ++i;
                    while (i < n) {
                        switch (cArray[i]) {
                            case '\t': 
                            case '\n': 
                            case '\r': {
                                cArray[i] = 32;
                            }
                        }
                        ++i;
                    }
                    return new String(cArray);
                }
            }
        }
        return string;
    }

    DatatypeBase getPrimitive() {
        return this;
    }

    @Override
    public boolean isContextDependent() {
        return false;
    }

    @Override
    public boolean alwaysValid() {
        return false;
    }

    @Override
    public int getIdType() {
        return 0;
    }

    @Override
    public int valueHashCode(Object object) {
        return object.hashCode();
    }

    @Override
    public boolean sameValue(Object object, Object object2) {
        return object.equals(object2);
    }

    @Override
    public DatatypeStreamingValidator createStreamingValidator(ValidationContext validationContext) {
        return new StreamingValidatorImpl(this, validationContext);
    }
}

