/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import nu.validator.vendor.thaiopensource.relaxng.impl.Alphabet;
import nu.validator.vendor.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import nu.validator.vendor.thaiopensource.relaxng.impl.Pattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.RestrictionViolationException;
import org.xml.sax.SAXException;

abstract class BinaryPattern
extends Pattern {
    final Pattern p1;
    final Pattern p2;

    BinaryPattern(boolean bl, int n, Pattern pattern, Pattern pattern2) {
        super(bl, Math.max(pattern.getContentType(), pattern2.getContentType()), n);
        this.p1 = pattern;
        this.p2 = pattern2;
    }

    @Override
    void checkRecursion(int n) throws SAXException {
        this.p1.checkRecursion(n);
        this.p2.checkRecursion(n);
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        this.p1.checkRestrictions(n, duplicateAttributeDetector, alphabet);
        this.p2.checkRestrictions(n, duplicateAttributeDetector, alphabet);
    }

    @Override
    boolean samePattern(Pattern pattern) {
        if (this.getClass() != pattern.getClass()) {
            return false;
        }
        BinaryPattern binaryPattern = (BinaryPattern)pattern;
        return this.p1 == binaryPattern.p1 && this.p2 == binaryPattern.p2;
    }

    Pattern getOperand1() {
        return this.p1;
    }

    Pattern getOperand2() {
        return this.p2;
    }
}

