/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import nu.validator.vendor.relaxng.datatype.ValidationContext;
import nu.validator.vendor.thaiopensource.relaxng.impl.DataDerivFunction;
import nu.validator.vendor.thaiopensource.relaxng.impl.DataDerivType;
import nu.validator.vendor.thaiopensource.relaxng.impl.InconsistentDataDerivType;
import nu.validator.vendor.thaiopensource.relaxng.impl.Pattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternMemo;
import nu.validator.vendor.thaiopensource.relaxng.impl.SingleDataDerivType;
import nu.validator.vendor.thaiopensource.relaxng.impl.ValidatorPatternBuilder;

class BlankDataDerivType
extends DataDerivType {
    private PatternMemo blankMemo;
    private PatternMemo nonBlankMemo;

    BlankDataDerivType() {
    }

    @Override
    PatternMemo dataDeriv(ValidatorPatternBuilder validatorPatternBuilder, Pattern pattern, String string, ValidationContext validationContext) {
        if (DataDerivFunction.isBlank(string)) {
            if (this.blankMemo == null) {
                this.blankMemo = super.dataDeriv(validatorPatternBuilder, pattern, string, validationContext);
            }
            return this.blankMemo;
        }
        if (this.nonBlankMemo == null) {
            this.nonBlankMemo = super.dataDeriv(validatorPatternBuilder, pattern, string, validationContext);
        }
        return this.nonBlankMemo;
    }

    @Override
    DataDerivType copy() {
        return new BlankDataDerivType();
    }

    @Override
    DataDerivType combine(DataDerivType dataDerivType) {
        if (dataDerivType instanceof BlankDataDerivType || dataDerivType instanceof SingleDataDerivType) {
            return this;
        }
        return InconsistentDataDerivType.getInstance();
    }
}

