/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import nu.validator.vendor.thaiopensource.relaxng.impl.AbstractPatternFunction;
import nu.validator.vendor.thaiopensource.relaxng.impl.AfterPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.BinaryPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.BlankDataDerivType;
import nu.validator.vendor.thaiopensource.relaxng.impl.ChoicePattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.DataDataDerivType;
import nu.validator.vendor.thaiopensource.relaxng.impl.DataDerivType;
import nu.validator.vendor.thaiopensource.relaxng.impl.DataExceptPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.DataPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.GroupPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.InconsistentDataDerivType;
import nu.validator.vendor.thaiopensource.relaxng.impl.InterleavePattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.ListPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.OneOrMorePattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.Pattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.RefPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.SingleDataDerivType;
import nu.validator.vendor.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import nu.validator.vendor.thaiopensource.relaxng.impl.ValueDataDerivType;
import nu.validator.vendor.thaiopensource.relaxng.impl.ValuePattern;

class DataDerivTypeFunction
extends AbstractPatternFunction {
    private final ValidatorPatternBuilder builder;

    DataDerivTypeFunction(ValidatorPatternBuilder validatorPatternBuilder) {
        this.builder = validatorPatternBuilder;
    }

    static DataDerivType dataDerivType(ValidatorPatternBuilder validatorPatternBuilder, Pattern pattern) {
        return (DataDerivType)pattern.apply(validatorPatternBuilder.getDataDerivTypeFunction());
    }

    @Override
    public Object caseOther(Pattern pattern) {
        return new SingleDataDerivType();
    }

    @Override
    public DataDerivType caseRef(RefPattern refPattern) {
        return this.apply(refPattern.getPattern());
    }

    @Override
    public Object caseAfter(AfterPattern afterPattern) {
        Pattern pattern = afterPattern.getOperand1();
        DataDerivType dataDerivType = this.apply(afterPattern.getOperand1());
        if (!pattern.isNullable()) {
            return dataDerivType;
        }
        return dataDerivType.combine(new BlankDataDerivType());
    }

    private Object caseBinary(BinaryPattern binaryPattern) {
        return this.apply(binaryPattern.getOperand1()).combine(this.apply(binaryPattern.getOperand2()));
    }

    @Override
    public Object caseChoice(ChoicePattern choicePattern) {
        return this.caseBinary(choicePattern);
    }

    @Override
    public Object caseGroup(GroupPattern groupPattern) {
        return this.caseBinary(groupPattern);
    }

    @Override
    public Object caseInterleave(InterleavePattern interleavePattern) {
        return this.caseBinary(interleavePattern);
    }

    @Override
    public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        return this.apply(oneOrMorePattern.getOperand());
    }

    @Override
    public Object caseList(ListPattern listPattern) {
        return InconsistentDataDerivType.getInstance();
    }

    @Override
    public Object caseValue(ValuePattern valuePattern) {
        return new ValueDataDerivType(valuePattern.getDatatype());
    }

    @Override
    public Object caseData(DataPattern dataPattern) {
        if (dataPattern.allowsAnyString()) {
            return new SingleDataDerivType();
        }
        return new DataDataDerivType(dataPattern.getDatatype());
    }

    @Override
    public Object caseDataExcept(DataExceptPattern dataExceptPattern) {
        if (dataExceptPattern.allowsAnyString()) {
            return this.apply(dataExceptPattern.getExcept());
        }
        return new DataDataDerivType(dataExceptPattern.getDatatype()).combine(this.apply(dataExceptPattern.getExcept()));
    }

    private DataDerivType apply(Pattern pattern) {
        return this.builder.getPatternMemo(pattern).dataDerivType();
    }
}

