/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import nu.validator.vendor.thaiopensource.relaxng.impl.Alphabet;
import nu.validator.vendor.thaiopensource.relaxng.impl.BinaryPattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import nu.validator.vendor.thaiopensource.relaxng.impl.Pattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternFunction;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternVisitor;
import nu.validator.vendor.thaiopensource.relaxng.impl.RestrictionViolationException;
import nu.validator.vendor.thaiopensource.relaxng.impl.SchemaPatternBuilder;

class GroupPattern
extends BinaryPattern {
    GroupPattern(Pattern pattern, Pattern pattern2) {
        super(pattern.isNullable() && pattern2.isNullable(), GroupPattern.combineHashCode(13, pattern.hashCode(), pattern2.hashCode()), pattern, pattern2);
    }

    @Override
    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern = this.p1.expand(schemaPatternBuilder);
        Pattern pattern2 = this.p2.expand(schemaPatternBuilder);
        if (pattern != this.p1 || pattern2 != this.p2) {
            return schemaPatternBuilder.makeGroup(pattern, pattern2);
        }
        return this;
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_group");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_group");
            }
        }
        super.checkRestrictions(n == 2 ? 3 : n, duplicateAttributeDetector, alphabet);
        if (n != 6 && !GroupPattern.contentTypeGroupable(this.p1.getContentType(), this.p2.getContentType())) {
            throw new RestrictionViolationException("group_string");
        }
    }

    @Override
    void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitGroup(this.p1, this.p2);
    }

    @Override
    Object apply(PatternFunction patternFunction) {
        return patternFunction.caseGroup(this);
    }
}

