/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nu.validator.vendor.thaiopensource.relaxng.impl.IdTypeMap;
import nu.validator.vendor.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import nu.validator.vendor.thaiopensource.validate.Validator;
import nu.validator.vendor.thaiopensource.xml.util.Name;
import nu.validator.vendor.thaiopensource.xml.util.StringSplitter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class IdSoundnessChecker
implements Validator,
ContentHandler {
    private final IdTypeMap idTypeMap;
    private final ErrorHandler eh;
    private Locator locator;
    private final Map map = new HashMap();

    public IdSoundnessChecker(IdTypeMap idTypeMap, ErrorHandler errorHandler) {
        this.idTypeMap = idTypeMap;
        this.eh = errorHandler;
    }

    @Override
    public void reset() {
        this.map.clear();
        this.locator = null;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    void setComplete() {
    }

    @Override
    public void endDocument() throws SAXException {
        for (String string : this.map.keySet()) {
            Entry entry = (Entry)this.map.get(string);
            if (entry.hadId) continue;
            Iterator iterator = entry.idrefLocs.iterator();
            while (iterator.hasNext()) {
                this.error("missing_id", string, (Locator)iterator.next());
            }
        }
        this.setComplete();
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Name name = new Name(string, string2);
        int n = attributes.getLength();
        block5: for (int i = 0; i < n; ++i) {
            Name name2 = new Name(attributes.getURI(i), attributes.getLocalName(i));
            int n2 = this.idTypeMap.getIdType(name, name2);
            if (n2 == 0) continue;
            String[] stringArray = StringSplitter.split(attributes.getValue(i));
            switch (n2) {
                case 1: {
                    if (stringArray.length == 1) {
                        this.id(stringArray[0]);
                        continue block5;
                    }
                    if (stringArray.length == 0) {
                        this.error("id_no_tokens");
                        continue block5;
                    }
                    this.error("id_multiple_tokens");
                    continue block5;
                }
                case 2: {
                    if (stringArray.length == 1) {
                        this.idref(stringArray[0]);
                        continue block5;
                    }
                    if (stringArray.length == 0) {
                        this.error("idref_no_tokens");
                        continue block5;
                    }
                    this.error("idref_multiple_tokens");
                    continue block5;
                }
                case 3: {
                    if (stringArray.length > 0) {
                        for (int j = 0; j < stringArray.length; ++j) {
                            this.idref(stringArray[j]);
                        }
                        continue block5;
                    }
                    this.error("idrefs_no_tokens");
                }
            }
        }
    }

    private void id(String string) throws SAXException {
        Entry entry = (Entry)this.map.get(string);
        if (entry == null) {
            entry = new Entry();
            this.map.put(string, entry);
        } else if (entry.hadId) {
            this.error("duplicate_id", string);
            this.error("first_id", string, entry.idLoc);
            return;
        }
        entry.idLoc = new LocatorImpl(this.locator);
        entry.hadId = true;
    }

    private void idref(String string) {
        Entry entry = (Entry)this.map.get(string);
        if (entry == null) {
            entry = new Entry();
            this.map.put(string, entry);
        }
        if (entry.hadId) {
            return;
        }
        if (entry.idrefLocs == null) {
            entry.idrefLocs = new ArrayList();
        }
        entry.idrefLocs.add(new LocatorImpl(this.locator));
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    private void error(String string) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string), this.locator));
    }

    private void error(String string, String string2) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string, string2), this.locator));
    }

    private void error(String string, String string2, Locator locator) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string, string2), locator));
    }

    private static class Entry {
        Locator idLoc;
        List idrefLocs;
        boolean hadId;

        private Entry() {
        }
    }
}

