/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import nu.validator.vendor.thaiopensource.relaxng.impl.NameClass;
import nu.validator.vendor.thaiopensource.relaxng.impl.NameClassVisitor;
import nu.validator.vendor.thaiopensource.relaxng.impl.RestrictionViolationException;
import nu.validator.vendor.thaiopensource.relaxng.impl.SimpleNameClass;
import nu.validator.vendor.thaiopensource.xml.util.Name;

class OverlapDetector
implements NameClassVisitor {
    private final NameClass nc1;
    private final NameClass nc2;
    private Name overlapExample = null;
    private static final String IMPOSSIBLE = "\u0000";

    private OverlapDetector(NameClass nameClass, NameClass nameClass2) {
        this.nc1 = nameClass;
        this.nc2 = nameClass2;
        nameClass.accept(this);
        nameClass2.accept(this);
    }

    private void probe(Name name) {
        if (this.nc1.contains(name) && this.nc2.contains(name)) {
            this.overlapExample = name;
        }
    }

    @Override
    public void visitChoice(NameClass nameClass, NameClass nameClass2) {
        nameClass.accept(this);
        nameClass2.accept(this);
    }

    @Override
    public void visitNsName(String string) {
        this.probe(new Name(string, IMPOSSIBLE));
    }

    @Override
    public void visitNsNameExcept(String string, NameClass nameClass) {
        this.probe(new Name(string, IMPOSSIBLE));
        nameClass.accept(this);
    }

    @Override
    public void visitAnyName() {
        this.probe(new Name(IMPOSSIBLE, IMPOSSIBLE));
    }

    @Override
    public void visitAnyNameExcept(NameClass nameClass) {
        this.probe(new Name(IMPOSSIBLE, IMPOSSIBLE));
        nameClass.accept(this);
    }

    @Override
    public void visitName(Name name) {
        this.probe(name);
    }

    @Override
    public void visitNull() {
    }

    @Override
    public void visitError() {
    }

    static void checkOverlap(NameClass nameClass, NameClass nameClass2, String string, String string2, String string3) throws RestrictionViolationException {
        if (nameClass2 instanceof SimpleNameClass) {
            SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass2;
            if (nameClass.contains(simpleNameClass.getName())) {
                throw new RestrictionViolationException(string, simpleNameClass.getName());
            }
        } else if (nameClass instanceof SimpleNameClass) {
            SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass;
            if (nameClass2.contains(simpleNameClass.getName())) {
                throw new RestrictionViolationException(string, simpleNameClass.getName());
            }
        } else {
            Name name = new OverlapDetector((NameClass)nameClass, (NameClass)nameClass2).overlapExample;
            if (name != null) {
                String string4 = name.getLocalName();
                if (string4 == IMPOSSIBLE) {
                    String string5 = name.getNamespaceUri();
                    if (string5 == IMPOSSIBLE) {
                        throw new RestrictionViolationException(string3);
                    }
                    throw new RestrictionViolationException(string2, string5);
                }
                throw new RestrictionViolationException(string, name);
            }
        }
    }
}

