/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.impl;

import nu.validator.vendor.relaxng.datatype.Datatype;
import nu.validator.vendor.thaiopensource.relaxng.impl.Alphabet;
import nu.validator.vendor.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import nu.validator.vendor.thaiopensource.relaxng.impl.Pattern;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternFunction;
import nu.validator.vendor.thaiopensource.relaxng.impl.PatternVisitor;
import nu.validator.vendor.thaiopensource.relaxng.impl.RestrictionViolationException;
import nu.validator.vendor.thaiopensource.relaxng.impl.StringPattern;

class ValuePattern
extends StringPattern {
    private final Object obj;
    private final Datatype dt;

    ValuePattern(Datatype datatype, Object object) {
        super(ValuePattern.combineHashCode(27, object.hashCode()));
        this.dt = datatype;
        this.obj = object;
    }

    @Override
    boolean samePattern(Pattern pattern) {
        if (this.getClass() != pattern.getClass()) {
            return false;
        }
        if (!(pattern instanceof ValuePattern)) {
            return false;
        }
        return this.dt.equals(((ValuePattern)pattern).dt) && this.dt.sameValue(this.obj, ((ValuePattern)pattern).obj);
    }

    @Override
    void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitValue(this.dt, this.obj);
    }

    @Override
    Object apply(PatternFunction patternFunction) {
        return patternFunction.caseValue(this);
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_value");
            }
        }
    }

    Datatype getDatatype() {
        return this.dt;
    }

    Object getValue() {
        return this.obj;
    }
}

