/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.parse.sax;

import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import nu.validator.vendor.thaiopensource.relaxng.parse.BuildException;
import nu.validator.vendor.thaiopensource.relaxng.parse.IllegalSchemaException;
import nu.validator.vendor.thaiopensource.relaxng.parse.IncludedGrammar;
import nu.validator.vendor.thaiopensource.relaxng.parse.ParsedPattern;
import nu.validator.vendor.thaiopensource.relaxng.parse.SchemaBuilder;
import nu.validator.vendor.thaiopensource.relaxng.parse.Scope;
import nu.validator.vendor.thaiopensource.relaxng.parse.SubParseable;
import nu.validator.vendor.thaiopensource.relaxng.parse.sax.SAXSubParser;
import nu.validator.vendor.thaiopensource.relaxng.parse.sax.SchemaParser;
import nu.validator.vendor.thaiopensource.relaxng.parse.sax.UriResolver;
import nu.validator.vendor.thaiopensource.util.Uri;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXParseable
extends SAXSubParser
implements SubParseable {
    private final SAXSource source;

    public SAXParseable(SAXSource sAXSource, UriResolver uriResolver, ErrorHandler errorHandler) {
        super(uriResolver, errorHandler);
        this.source = sAXSource;
    }

    @Override
    public ParsedPattern parse(SchemaBuilder schemaBuilder, Scope scope) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.source.getXMLReader();
            SchemaParser schemaParser = new SchemaParser(xMLReader, this.eh, schemaBuilder, null, scope);
            xMLReader.parse(this.source.getInputSource());
            return schemaParser.getParsedPattern();
        }
        catch (SAXException sAXException) {
            throw BuildException.fromSAXException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    @Override
    public ParsedPattern parseAsInclude(SchemaBuilder schemaBuilder, IncludedGrammar includedGrammar) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.source.getXMLReader();
            SchemaParser schemaParser = new SchemaParser(xMLReader, this.eh, schemaBuilder, includedGrammar, includedGrammar);
            xMLReader.parse(this.source.getInputSource());
            return schemaParser.getParsedPattern();
        }
        catch (SAXException sAXException) {
            throw BuildException.fromSAXException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    @Override
    public String getUri() {
        return Uri.escapeDisallowedChars(this.source.getInputSource().getSystemId());
    }
}

