/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.relaxng.util;

import java.io.IOException;
import nu.validator.vendor.thaiopensource.util.Localizer;
import nu.validator.vendor.thaiopensource.util.OptionParser;
import nu.validator.vendor.thaiopensource.util.PropertyMapBuilder;
import nu.validator.vendor.thaiopensource.util.Version;
import nu.validator.vendor.thaiopensource.validate.Flag;
import nu.validator.vendor.thaiopensource.validate.Option;
import nu.validator.vendor.thaiopensource.validate.OptionArgumentException;
import nu.validator.vendor.thaiopensource.validate.SchemaReader;
import nu.validator.vendor.thaiopensource.validate.ValidateProperty;
import nu.validator.vendor.thaiopensource.validate.ValidationDriver;
import nu.validator.vendor.thaiopensource.validate.auto.AutoSchemaReader;
import nu.validator.vendor.thaiopensource.validate.prop.rng.RngProperty;
import nu.validator.vendor.thaiopensource.validate.rng.CompactSchemaReader;
import nu.validator.vendor.thaiopensource.xml.sax.ErrorHandlerImpl;
import nu.validator.vendor.thaiopensource.xml.sax.Resolver;
import nu.validator.vendor.thaiopensource.xml.sax.ResolverInstantiationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class Driver {
    private static String usageKey = "usage";
    private boolean timing = false;
    private String encoding = null;
    private Localizer localizer = new Localizer(Driver.class);

    Driver() {
    }

    public static void setUsageKey(String string) {
        usageKey = string;
    }

    public static void main(String[] stringArray) {
        System.exit(new Driver().doMain(stringArray));
    }

    public int doMain(String[] stringArray) {
        ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl(System.out);
        OptionParser optionParser = new OptionParser("itcdfe:p:r:", stringArray);
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, errorHandlerImpl);
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        SchemaReader schemaReader = null;
        boolean bl = false;
        try {
            while (optionParser.moveToNextOption()) {
                switch (optionParser.getOptionChar()) {
                    case 'i': {
                        propertyMapBuilder.put(RngProperty.CHECK_ID_IDREF, null);
                        break;
                    }
                    case 'c': {
                        bl = true;
                        break;
                    }
                    case 'd': {
                        Option option;
                        if (schemaReader == null) {
                            schemaReader = new AutoSchemaReader();
                        }
                        if ((option = schemaReader.getOption("http://www.thaiopensource.com/validate/diagnose")) == null) {
                            errorHandlerImpl.print(this.localizer.message("no_schematron", optionParser.getOptionCharString()));
                            return 2;
                        }
                        propertyMapBuilder.put(option.getPropertyId(), Flag.PRESENT);
                        break;
                    }
                    case 't': {
                        this.timing = true;
                        break;
                    }
                    case 'e': {
                        this.encoding = optionParser.getOptionArg();
                        break;
                    }
                    case 'f': {
                        RngProperty.FEASIBLE.add(propertyMapBuilder);
                        break;
                    }
                    case 'p': {
                        Option option;
                        if (schemaReader == null) {
                            schemaReader = new AutoSchemaReader();
                        }
                        if ((option = schemaReader.getOption("http://www.thaiopensource.com/validate/phase")) == null) {
                            errorHandlerImpl.print(this.localizer.message("no_schematron", optionParser.getOptionCharString()));
                            return 2;
                        }
                        try {
                            propertyMapBuilder.put(option.getPropertyId(), option.valueOf(optionParser.getOptionArg()));
                            break;
                        }
                        catch (OptionArgumentException optionArgumentException) {
                            errorHandlerImpl.print(this.localizer.message("invalid_phase", optionParser.getOptionArg()));
                            return 2;
                        }
                    }
                    case 'r': {
                        try {
                            ValidateProperty.RESOLVER.put(propertyMapBuilder, Resolver.newInstance(optionParser.getOptionArg(), Driver.class.getClassLoader()));
                            break;
                        }
                        catch (ResolverInstantiationException resolverInstantiationException) {
                            errorHandlerImpl.print(this.localizer.message("invalid_resolver_class", resolverInstantiationException.getMessage()));
                            return 2;
                        }
                    }
                }
            }
        }
        catch (OptionParser.InvalidOptionException invalidOptionException) {
            errorHandlerImpl.print(this.localizer.message("invalid_option", optionParser.getOptionCharString()));
            return 2;
        }
        catch (OptionParser.MissingArgumentException missingArgumentException) {
            errorHandlerImpl.print(this.localizer.message("option_missing_argument", optionParser.getOptionCharString()));
            return 2;
        }
        if (bl) {
            schemaReader = CompactSchemaReader.getInstance();
        }
        if ((stringArray = optionParser.getRemainingArgs()).length < 1) {
            errorHandlerImpl.print(this.localizer.message(usageKey, Version.getVersion(Driver.class)));
            return 2;
        }
        long l = System.currentTimeMillis();
        long l2 = -1L;
        boolean bl2 = false;
        try {
            ValidationDriver validationDriver = new ValidationDriver(propertyMapBuilder.toPropertyMap(), schemaReader);
            InputSource inputSource = ValidationDriver.uriOrFileInputSource(stringArray[0]);
            if (this.encoding != null) {
                inputSource.setEncoding(this.encoding);
            }
            if (validationDriver.loadSchema(inputSource)) {
                l2 = System.currentTimeMillis();
                for (int i = 1; i < stringArray.length; ++i) {
                    if (validationDriver.validate(ValidationDriver.uriOrFileInputSource(stringArray[i]))) continue;
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
        }
        catch (SAXException sAXException) {
            bl2 = true;
            errorHandlerImpl.printException(sAXException);
        }
        catch (IOException iOException) {
            bl2 = true;
            errorHandlerImpl.printException(iOException);
        }
        if (this.timing) {
            long l3 = System.currentTimeMillis();
            if (l2 < 0L) {
                l2 = l3;
            }
            errorHandlerImpl.print(this.localizer.message("elapsed_time", new Object[]{new Long(l2 - l), new Long(l3 - l2), new Long(l3 - l)}));
        }
        if (bl2) {
            return 1;
        }
        return 0;
    }
}

