/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.validate.auto;

import java.io.IOException;
import java.util.Vector;
import nu.validator.vendor.thaiopensource.util.Localizer;
import nu.validator.vendor.thaiopensource.util.PropertyMap;
import nu.validator.vendor.thaiopensource.validate.IncorrectSchemaException;
import nu.validator.vendor.thaiopensource.validate.Schema;
import nu.validator.vendor.thaiopensource.validate.auto.Rewindable;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaFuture;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaReceiver;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaReceiverFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class AutoSchemaReceiver
implements SchemaReceiver {
    private final PropertyMap properties;
    private final Rewindable rewindable;

    public AutoSchemaReceiver(PropertyMap propertyMap, Rewindable rewindable) {
        this.properties = propertyMap;
        this.rewindable = rewindable;
    }

    @Override
    public SchemaFuture installHandlers(XMLReader xMLReader) {
        Handler handler = new Handler(xMLReader);
        xMLReader.setContentHandler(handler);
        return handler;
    }

    private class Handler
    extends DefaultHandler
    implements SchemaFuture {
        private final XMLReader xr;
        private SchemaFuture sf = null;
        private Locator locator = null;
        private final Vector prefixMappings = new Vector();

        private Handler(XMLReader xMLReader) {
            this.xr = xMLReader;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startPrefixMapping(String string, String string2) {
            this.prefixMappings.addElement(string);
            this.prefixMappings.addElement(string2);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            SchemaReceiverFactory schemaReceiverFactory = SchemaReceiverFactory.PROPERTY.get(AutoSchemaReceiver.this.properties);
            SchemaReceiver schemaReceiver = schemaReceiverFactory.createSchemaReceiver(string, AutoSchemaReceiver.this.properties);
            if (schemaReceiver == null) {
                Localizer localizer = new Localizer(AutoSchemaReceiver.class);
                String string4 = "".equals(string) ? localizer.message("no_namespace") : localizer.message("unknown_namespace", string);
                throw new SAXParseException(string4, this.locator);
            }
            this.sf = schemaReceiver.installHandlers(this.xr);
            AutoSchemaReceiver.this.rewindable.willNotRewind();
            ContentHandler contentHandler = this.xr.getContentHandler();
            if (contentHandler == null) {
                return;
            }
            if (this.locator != null) {
                contentHandler.setDocumentLocator(this.locator);
                contentHandler = this.xr.getContentHandler();
            }
            contentHandler.startDocument();
            contentHandler = this.xr.getContentHandler();
            int n = this.prefixMappings.size();
            for (int i = 0; i < n; i += 2) {
                contentHandler.startPrefixMapping((String)this.prefixMappings.elementAt(i), (String)this.prefixMappings.elementAt(i + 1));
                contentHandler = this.xr.getContentHandler();
            }
            contentHandler.startElement(string, string2, string3, attributes);
        }

        @Override
        public Schema getSchema() throws IncorrectSchemaException, SAXException, IOException {
            if (this.sf == null) {
                throw new IncorrectSchemaException();
            }
            return this.sf.getSchema();
        }

        @Override
        public RuntimeException unwrapException(RuntimeException runtimeException) throws SAXException, IOException, IncorrectSchemaException {
            if (this.sf == null) {
                return runtimeException;
            }
            return this.sf.unwrapException(runtimeException);
        }
    }
}

