/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.validate.nrl;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.sax.SAXSource;
import nu.validator.vendor.thaiopensource.util.PropertyId;
import nu.validator.vendor.thaiopensource.util.PropertyMap;
import nu.validator.vendor.thaiopensource.util.PropertyMapBuilder;
import nu.validator.vendor.thaiopensource.util.Uri;
import nu.validator.vendor.thaiopensource.validate.IncorrectSchemaException;
import nu.validator.vendor.thaiopensource.validate.Option;
import nu.validator.vendor.thaiopensource.validate.ResolverFactory;
import nu.validator.vendor.thaiopensource.validate.Schema;
import nu.validator.vendor.thaiopensource.validate.SchemaReader;
import nu.validator.vendor.thaiopensource.validate.SchemaResolver;
import nu.validator.vendor.thaiopensource.validate.ValidateProperty;
import nu.validator.vendor.thaiopensource.validate.auto.AutoSchemaReader;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaFuture;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaReceiver;
import nu.validator.vendor.thaiopensource.validate.auto.SchemaReceiverFactory;
import nu.validator.vendor.thaiopensource.validate.nrl.SchemaImpl;
import nu.validator.vendor.thaiopensource.validate.nrl.ValidatorImpl;
import nu.validator.vendor.thaiopensource.validate.prop.wrap.WrapProperty;
import nu.validator.vendor.thaiopensource.validate.rng.CompactSchemaReader;
import nu.validator.vendor.thaiopensource.validate.rng.SAXSchemaReader;
import nu.validator.vendor.thaiopensource.xml.sax.Resolver;
import nu.validator.vendor.thaiopensource.xml.util.Name;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SchemaReceiverImpl
implements SchemaReceiver {
    private static final String NRL_SCHEMA = "nrl.rng";
    private static final String RNC_MEDIA_TYPE = "application/relax-ng-compact-syntax";
    static final String LEGACY_RNC_MEDIA_TYPE = "application/x-rnc";
    private final PropertyMap properties;
    private final Name attributeOwner;
    private final SchemaReader autoSchemaReader;
    private Schema nrlSchema = null;
    private static final PropertyId[] subSchemaProperties = new PropertyId[]{ValidateProperty.ERROR_HANDLER, ValidateProperty.XML_READER_CREATOR, ValidateProperty.ENTITY_RESOLVER, ValidateProperty.SCHEMA_RESOLVER, SchemaReceiverFactory.PROPERTY};

    public SchemaReceiverImpl(PropertyMap propertyMap) {
        this.attributeOwner = WrapProperty.ATTRIBUTE_OWNER.get(propertyMap);
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        for (int i = 0; i < subSchemaProperties.length; ++i) {
            Object object = propertyMap.get(subSchemaProperties[i]);
            if (object == null) continue;
            propertyMapBuilder.put(subSchemaProperties[i], object);
        }
        this.properties = propertyMapBuilder.toPropertyMap();
        this.autoSchemaReader = new AutoSchemaReader(SchemaReceiverFactory.PROPERTY.get(propertyMap));
    }

    @Override
    public SchemaFuture installHandlers(XMLReader xMLReader) {
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(this.properties);
        if (this.attributeOwner != null) {
            WrapProperty.ATTRIBUTE_OWNER.put(propertyMapBuilder, this.attributeOwner);
        }
        return new SchemaImpl(propertyMapBuilder.toPropertyMap()).installHandlers(xMLReader, this);
    }

    Schema getNrlSchema() throws IOException, IncorrectSchemaException, SAXException {
        if (this.nrlSchema == null) {
            String string = SchemaReceiverImpl.class.getName();
            String string2 = string.substring(0, string.lastIndexOf(46)).replace('.', '/') + "/resources/" + NRL_SCHEMA;
            URL uRL = SchemaReceiverImpl.getResource(string2);
            this.nrlSchema = SAXSchemaReader.getInstance().createSchema(new InputSource(uRL.openStream()), this.properties);
        }
        return this.nrlSchema;
    }

    private static URL getResource(String string) {
        ClassLoader classLoader = SchemaReceiverImpl.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }

    PropertyMap getProperties() {
        return this.properties;
    }

    Schema createChildSchema(String string, String string2, String string3, PropertyMap propertyMap, boolean bl) throws IOException, IncorrectSchemaException, SAXException {
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(this.properties);
        if (bl) {
            WrapProperty.ATTRIBUTE_OWNER.put(propertyMapBuilder, ValidatorImpl.OWNER_NAME);
        }
        int n = propertyMap.size();
        for (int i = 0; i < n; ++i) {
            propertyMapBuilder.put(propertyMap.getKey(i), propertyMap.get(propertyMap.getKey(i)));
        }
        SchemaResolver schemaResolver = ValidateProperty.SCHEMA_RESOLVER.get(this.properties);
        if (schemaResolver == null) {
            Resolver resolver = ResolverFactory.createResolver(this.properties);
            SAXSource sAXSource = resolver.resolve(string, string2);
            SchemaReader schemaReader = SchemaReceiverImpl.isRnc(string3) ? CompactSchemaReader.getInstance() : this.autoSchemaReader;
            return schemaReader.createSchema(sAXSource, propertyMapBuilder.toPropertyMap());
        }
        return schemaResolver.resolveSchema(Uri.resolve(string2, string), propertyMapBuilder.toPropertyMap());
    }

    Option getOption(String string) {
        Option option = this.autoSchemaReader.getOption(string);
        if (option != null) {
            return option;
        }
        return CompactSchemaReader.getInstance().getOption(string);
    }

    private static boolean isRnc(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.trim()).equalsIgnoreCase(RNC_MEDIA_TYPE) || string.equalsIgnoreCase(LEGACY_RNC_MEDIA_TYPE);
    }
}

