/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.vendor.thaiopensource.validate.picl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import nu.validator.vendor.thaiopensource.validate.picl.Constraint;
import nu.validator.vendor.thaiopensource.validate.picl.ErrorContext;
import nu.validator.vendor.thaiopensource.validate.picl.Pattern;
import nu.validator.vendor.thaiopensource.validate.picl.PatternManager;
import nu.validator.vendor.thaiopensource.validate.picl.SelectedValueHandler;
import nu.validator.vendor.thaiopensource.validate.picl.ValueSelectionHandler;
import org.xml.sax.Locator;

class KeyConstraint
implements Constraint {
    private final Pattern key;

    KeyConstraint(Pattern pattern) {
        this.key = pattern;
    }

    @Override
    public void activate(PatternManager patternManager) {
        this.activate(patternManager, new KeyIndex());
    }

    void activate(PatternManager patternManager, KeyIndex keyIndex) {
        patternManager.registerPattern(this.key, new ValueSelectionHandler(new KeySelectionHandler(keyIndex)));
    }

    static class KeyIndex {
        private final Hashtable table = new Hashtable();

        KeyIndex() {
        }

        KeyInfo lookupCreate(Object object) {
            KeyInfo keyInfo = (KeyInfo)this.table.get(object);
            if (keyInfo == null) {
                keyInfo = new KeyInfo();
                this.table.put(object, keyInfo);
            }
            return keyInfo;
        }

        Enumeration keys() {
            return this.table.keys();
        }
    }

    static class KeySelectionHandler
    extends SelectedValueHandler {
        private final KeyIndex index;

        KeySelectionHandler(KeyIndex keyIndex) {
            this.index = keyIndex;
        }

        @Override
        void select(ErrorContext errorContext, Locator locator, Object object, String string) {
            KeyInfo keyInfo = this.index.lookupCreate(object);
            if (keyInfo.firstKeyLocator == null) {
                if (locator == null) {
                    locator = errorContext.saveLocator();
                }
                keyInfo.firstKeyLocator = locator;
                keyInfo.pendingRefLocators = null;
                keyInfo.representation = string;
            } else {
                errorContext.error(locator, "duplicate_key", string);
            }
        }
    }

    static class KeyInfo {
        String representation;
        Locator firstKeyLocator;
        Vector pendingRefLocators;

        KeyInfo() {
        }
    }
}

