/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import nu.validator.datatype.ContentSecurityPolicy;
import nu.validator.datatype.Html5DatatypeException;
import nu.validator.io.BoundedInputStream;
import nu.validator.io.ObservableInputStream;
import nu.validator.io.StreamObserver;
import nu.validator.io.SystemIdIOException;
import nu.validator.vendor.relaxng.datatype.DatatypeException;
import nu.validator.xml.ContentTypeParser;
import nu.validator.xml.TypedInputSource;
import org.apache.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.htmlunit.csp.Policy;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PrudentHttpEntityResolver
implements EntityResolver {
    private static final Logger log4j = Logger.getLogger(PrudentHttpEntityResolver.class);
    private static HttpClient client;
    private static boolean clientStarted;
    private static int connectionTimeoutMs;
    private static int socketTimeoutMs;
    private static int maxRequests;
    private long sizeLimit;
    private final ErrorHandler errorHandler;
    private int requestsLeft;
    private boolean allowRnc = false;
    private boolean allowCss = false;
    private boolean allowHtml = false;
    private boolean allowXhtml = false;
    private boolean acceptAllKnownXmlTypes = false;
    private boolean allowGenericXml = true;
    private final ContentTypeParser contentTypeParser;
    private static final List<String> FORBIDDEN_HOSTS;
    private boolean allowForbiddenHosts = false;
    private String userAgent;
    private Map<String, String> additionalRequestHeaders = new HashMap<String, String>();
    private HttpServletRequest request;

    public static void setParams(int connectionTimeout, int socketTimeout, int maxRequests) {
        connectionTimeoutMs = connectionTimeout;
        socketTimeoutMs = socketTimeout;
        PrudentHttpEntityResolver.maxRequests = maxRequests;
        client = null;
        clientStarted = false;
    }

    private static synchronized void ensureClientStarted() {
        if (!clientStarted) {
            if (client == null) {
                boolean promiscuousSSL = "true".equals(System.getProperty("nu.validator.xml.promiscuous-ssl", "true"));
                SslContextFactory.Client sslContextFactory = promiscuousSSL ? new SslContextFactory.Client(true) : new SslContextFactory.Client();
                ClientConnector clientConnector = new ClientConnector();
                clientConnector.setSslContextFactory(sslContextFactory);
                HttpClientTransportOverHTTP transport = new HttpClientTransportOverHTTP(clientConnector);
                client = new HttpClient(transport);
                ThreadFactory daemonThreadFactory = new ThreadFactory(){
                    private final AtomicInteger counter = new AtomicInteger();

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r, "vnu-http-" + this.counter.incrementAndGet());
                        thread.setDaemon(true);
                        return thread;
                    }
                };
                QueuedThreadPool threadPool = new QueuedThreadPool(200, 8, 60000, -1, new LinkedBlockingQueue<Runnable>(), null, daemonThreadFactory);
                threadPool.setName("vnu-http-client");
                client.setExecutor(threadPool);
                ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler("vnu-http-scheduler", true);
                client.setScheduler(scheduler);
                client.setFollowRedirects(true);
                client.setMaxConnectionsPerDestination(maxRequests);
                client.setMaxRequestsQueuedPerDestination(Integer.parseInt(System.getProperty("nu.validator.servlet.max-total-connections", "200")));
                client.setMaxRedirects(Integer.parseInt(System.getProperty("nu.validator.servlet.max-redirects", "20")));
                client.setConnectTimeout(connectionTimeoutMs);
                client.setIdleTimeout(socketTimeoutMs);
            }
            try {
                client.start();
                clientStarted = true;
            }
            catch (Exception e) {
                log4j.error("Failed to start HTTP client", e);
                throw new RuntimeException("Failed to start HTTP client", e);
            }
        }
    }

    public void setUserAgent(String ua) {
        this.userAgent = ua;
    }

    public void setAdditionalRequestHeaders(Map<String, String> headers) {
        if (headers != null) {
            this.additionalRequestHeaders = new HashMap<String, String>(headers);
        }
    }

    public void addRequestHeader(String name, String value) {
        if (name != null && value != null) {
            this.additionalRequestHeaders.put(name, value);
        }
    }

    public PrudentHttpEntityResolver(long sizeLimit, boolean laxContentType, ErrorHandler errorHandler, HttpServletRequest request) {
        this.request = request;
        this.sizeLimit = sizeLimit;
        this.requestsLeft = maxRequests;
        this.errorHandler = errorHandler;
        this.allowForbiddenHosts = "true".equals(System.getProperty("nu.validator.servlet.allow-forbidden-hosts"));
        this.contentTypeParser = new ContentTypeParser(errorHandler, laxContentType, this.allowRnc, this.allowHtml, this.allowXhtml, this.acceptAllKnownXmlTypes, this.allowGenericXml);
    }

    public PrudentHttpEntityResolver(long sizeLimit, boolean laxContentType, ErrorHandler errorHandler) {
        this(sizeLimit, laxContentType, errorHandler, null);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String allowedAddressType = System.getProperty("nu.validator.servlet.allowed-address-type", "all");
        if ("none".equals(allowedAddressType)) {
            throw new IOException("URL-based checks are prohibited.");
        }
        if (this.requestsLeft > -1) {
            if (this.requestsLeft == 0) {
                throw new IOException("Number of permitted HTTP requests exceeded.");
            }
            --this.requestsLeft;
        }
        Request jettyRequest = null;
        try {
            String val;
            HttpField ce;
            HttpField csp;
            String val2;
            HttpField xuac;
            int statusCode;
            SAXParseException spe;
            URL url = null;
            try {
                String targetURLOrigin;
                URL currentURL;
                String currentURLOrigin;
                url = URL.parse(systemId);
                if ("same-origin".equals(allowedAddressType) && !(currentURLOrigin = (currentURL = URL.parse(this.request.getRequestURL().toString())).scheme() + String.valueOf(currentURL.host()) + currentURL.port()).equals(targetURLOrigin = url.scheme() + String.valueOf(url.host()) + url.port())) {
                    throw new IOException("Cross-origin requests are prohibited.");
                }
            }
            catch (GalimatiasParseException | StringIndexOutOfBoundsException e) {
                IOException ioe = (IOException)new IOException(e.getMessage()).initCause(e);
                SAXParseException spe2 = new SAXParseException(e.getMessage(), publicId, systemId, -1, -1, ioe);
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(spe2);
                }
                throw ioe;
            }
            String scheme = url.scheme();
            if (!"http".equals(scheme) && !"https".equals(scheme)) {
                String msg = "Unsupported URI scheme: \u201c" + scheme + "\u201d.";
                spe = new SAXParseException(msg, publicId, systemId, -1, -1, new IOException(msg));
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(spe);
                }
                throw spe;
            }
            systemId = url.toString();
            PrudentHttpEntityResolver.ensureClientStarted();
            try {
                jettyRequest = client.newRequest(systemId);
            }
            catch (IllegalArgumentException e) {
                spe = new SAXParseException(e.getMessage(), publicId, systemId, -1, -1, (IOException)new IOException(e.getMessage()).initCause(e));
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(spe);
                }
                throw spe;
            }
            if (!this.allowForbiddenHosts && FORBIDDEN_HOSTS.contains(url.host().toHostString())) {
                throw new IOException("Forbidden host.");
            }
            if (url.port() != 80 && url.port() != 81 && url.port() != 443 && url.port() < 1024) {
                throw new IOException("Forbidden port.");
            }
            jettyRequest.headers(headers -> {
                headers.put("User-Agent", this.userAgent);
                headers.put("Accept", this.buildAccept());
                headers.put("Accept-Encoding", "gzip");
                if (this.request != null && this.request.getAttribute("http://validator.nu/properties/accept-language") != null) {
                    headers.put("Accept-Language", (String)this.request.getAttribute("http://validator.nu/properties/accept-language"));
                }
                for (Map.Entry<String, String> entry : this.additionalRequestHeaders.entrySet()) {
                    headers.put(entry.getKey(), entry.getValue());
                }
            });
            log4j.info(systemId);
            try {
                if (url.port() > 65535) {
                    throw new IOException("Port number must be less than 65536.");
                }
            }
            catch (NumberFormatException e) {
                throw new IOException("Port number must be less than 65536.");
            }
            InputStreamResponseListener listener = new InputStreamResponseListener();
            jettyRequest.send(listener);
            Response response = listener.get(socketTimeoutMs, TimeUnit.MILLISECONDS);
            boolean ignoreResponseStatus = false;
            if (this.request != null && this.request.getAttribute("http://validator.nu/properties/ignore-response-status") != null) {
                ignoreResponseStatus = (Boolean)this.request.getAttribute("http://validator.nu/properties/ignore-response-status");
            }
            if ((statusCode = response.getStatus()) != 200 && !ignoreResponseStatus) {
                String msg = "HTTP resource not retrievable. The HTTP status from the remote server was: " + statusCode + ".";
                SAXParseException spe3 = new SAXParseException(msg, publicId, systemId, -1, -1, new SystemIdIOException(systemId, msg));
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(spe3);
                }
                throw new ResourceNotRetrievableException(String.format("%s: %s", systemId, msg));
            }
            InputStream stream = listener.getInputStream();
            if (stream == null) {
                String msg = "Empty response.";
                SAXParseException spe4 = new SAXParseException(msg, publicId, systemId, -1, -1, new SystemIdIOException(systemId, msg));
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(spe4);
                }
                throw new ResourceNotRetrievableException(String.format("%s: %s", systemId, msg));
            }
            HttpField ct = response.getHeaders().getField("Content-Type");
            String contentType = null;
            final String baseUri = systemId;
            if (ct != null) {
                contentType = ct.getValue();
            }
            TypedInputSource is = this.contentTypeParser.buildTypedInputSource(baseUri, publicId, contentType);
            HttpField cl = response.getHeaders().getField("Content-Language");
            if (cl != null) {
                is.setLanguage(cl.getValue().trim());
            }
            if ((xuac = response.getHeaders().getField("X-UA-Compatible")) != null && !"ie=edge".equalsIgnoreCase(val2 = xuac.getValue().trim())) {
                SAXParseException spe5 = new SAXParseException("X-UA-Compatible HTTP header must have the value \u201cIE=edge\u201d, was \u201c" + val2 + "\u201d.", publicId, systemId, -1, -1);
                this.errorHandler.error(spe5);
            }
            if ((csp = response.getHeaders().getField("Content-Security-Policy")) != null) {
                String cspValue = csp.getValue().trim();
                try {
                    ContentSecurityPolicy.THE_INSTANCE.checkValid(cspValue);
                }
                catch (DatatypeException e) {
                    SAXParseException spe6 = new SAXParseException("Content-Security-Policy HTTP header: " + e.getMessage(), publicId, systemId, -1, -1);
                    Html5DatatypeException ex5 = (Html5DatatypeException)e;
                    if (ex5.isWarning()) {
                        this.errorHandler.warning(spe6);
                    }
                    this.errorHandler.error(spe6);
                }
                if (this.request != null) {
                    try {
                        Policy policy = Policy.parseSerializedCSP(cspValue, (severity, message, directiveIndex, valueIndex) -> {});
                        this.request.setAttribute("http://validator.nu/properties/csp-policy", policy);
                    }
                    catch (IllegalArgumentException policy) {
                        // empty catch block
                    }
                }
            }
            if (this.sizeLimit > -1L) {
                stream = new BoundedInputStream(stream, this.sizeLimit, baseUri);
            }
            if ((ce = response.getHeaders().getField("Content-Encoding")) != null && ("gzip".equalsIgnoreCase(val = ce.getValue().trim()) || "x-gzip".equalsIgnoreCase(val))) {
                stream = new GZIPInputStream(stream);
                if (this.sizeLimit > -1L) {
                    stream = new BoundedInputStream(stream, this.sizeLimit, baseUri);
                }
            }
            is.setByteStream(new ObservableInputStream(stream, new StreamObserver(){
                private final Logger log4j = Logger.getLogger("nu.validator.xml.PrudentEntityResolver.StreamObserver");
                final /* synthetic */ PrudentHttpEntityResolver this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void closeCalled() {
                    this.log4j.debug("closeCalled");
                }

                @Override
                public void exceptionOccurred(Exception ex) throws IOException {
                    if (ex instanceof SystemIdIOException) {
                        throw (SystemIdIOException)ex;
                    }
                    if (ex instanceof IOException) {
                        IOException ioe = (IOException)ex;
                        throw new SystemIdIOException(baseUri, ioe.getMessage(), ioe);
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException("API contract violation. Wrong exception type.", ex);
                }

                @Override
                public void finalizerCalled() {
                    this.log4j.debug("finalizerCalled");
                }
            }));
            return is;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new SystemIdIOException(systemId, "HTTP request failed: " + e.getMessage(), e);
        }
        catch (IOException | RuntimeException | SAXException e) {
            throw e;
        }
    }

    public boolean isAllowRnc() {
        return this.allowRnc;
    }

    public void setAllowRnc(boolean allowRnc) {
        this.allowRnc = allowRnc;
        this.contentTypeParser.setAllowRnc(allowRnc);
    }

    public boolean isAllowCss() {
        return this.allowCss;
    }

    public void setAllowCss(boolean allowCss) {
        this.allowCss = allowCss;
        this.contentTypeParser.setAllowCss(allowCss);
    }

    public void setAllowHtml(boolean allowHtml) {
        this.allowHtml = allowHtml;
        this.contentTypeParser.setAllowHtml(allowHtml);
    }

    public boolean isAcceptAllKnownXmlTypes() {
        return this.acceptAllKnownXmlTypes;
    }

    public void setAcceptAllKnownXmlTypes(boolean acceptAllKnownXmlTypes) {
        this.acceptAllKnownXmlTypes = acceptAllKnownXmlTypes;
        this.contentTypeParser.setAcceptAllKnownXmlTypes(acceptAllKnownXmlTypes);
    }

    public boolean isAllowGenericXml() {
        return this.allowGenericXml;
    }

    public void setAllowGenericXml(boolean allowGenericXml) {
        this.allowGenericXml = allowGenericXml;
        this.contentTypeParser.setAllowGenericXml(allowGenericXml);
    }

    public boolean isAllowXhtml() {
        return this.allowXhtml;
    }

    public void setAllowXhtml(boolean allowXhtml) {
        this.allowXhtml = allowXhtml;
        this.contentTypeParser.setAllowXhtml(allowXhtml);
    }

    private String buildAccept() {
        return "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
    }

    public boolean isAllowHtml() {
        return this.allowHtml;
    }

    public boolean isOnlyHtmlAllowed() {
        return !this.isAllowGenericXml() && !this.isAllowRnc() && !this.isAllowCss() && !this.isAllowXhtml();
    }

    static {
        clientStarted = false;
        FORBIDDEN_HOSTS = Arrays.asList("localhost", "127.0.0.1", "0.0.0.0", "[::1]", "[0:0:0:0:0:0:0:1]", "[0000:0000:0000:0000:0000:0000:0000:0001]", "[::]", "[::0]", "[0000:0000:0000:0000:0000:0000:0000:0000]", "[0:0:0:0:0:0:0:0]");
    }

    public class ResourceNotRetrievableException
    extends SAXException {
        public ResourceNotRetrievableException(String message) {
            super(message);
        }
    }
}

