/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml.test;

import nu.validator.xml.CharacterUtil;

public class CharacterUtilTest {
    private static int passed = 0;
    private static int failed = 0;

    public static void main(String[] args) {
        System.out.println("Testing CharacterUtil...");
        CharacterUtilTest.testScrubCharacterData();
        CharacterUtilTest.testPrudentlyScrubCharacterData();
        System.out.println();
        System.out.println("Results: " + passed + " passed, " + failed + " failed");
        if (failed > 0) {
            System.exit(1);
        }
    }

    private static void testScrubCharacterData() {
        CharacterUtilTest.assertScrubEquals("ASCII text unchanged", "Hello, World!", "Hello, World!");
        CharacterUtilTest.assertScrubEquals("Tab preserved", "Hello\tWorld", "Hello\tWorld");
        CharacterUtilTest.assertScrubEquals("Newline preserved", "Hello\nWorld", "Hello\nWorld");
        CharacterUtilTest.assertScrubEquals("Carriage return preserved", "Hello\rWorld", "Hello\rWorld");
        CharacterUtilTest.assertScrubEquals("Null character removed", "Hello\u0000World", "HelloWorld");
        CharacterUtilTest.assertScrubEquals("Control char U+0001 removed", "Hello\u0001World", "HelloWorld");
        CharacterUtilTest.assertScrubEquals("Control char U+0008 removed", "Hello\bWorld", "HelloWorld");
        CharacterUtilTest.assertScrubEquals("Vertical tab removed", "Hello\u000bWorld", "HelloWorld");
        CharacterUtilTest.assertScrubEquals("Form feed removed", "Hello\fWorld", "HelloWorld");
        CharacterUtilTest.assertScrubEquals("Control char U+000E removed", "Hello\u000eWorld", "HelloWorld");
        CharacterUtilTest.assertScrubEquals("Control char U+001F removed", "Hello\u001fWorld", "HelloWorld");
        CharacterUtilTest.assertScrubEquals("Unicode preserved", "Caf\u00e9", "Caf\u00e9");
        CharacterUtilTest.assertScrubEquals("CJK preserved", "\u4e2d\u6587", "\u4e2d\u6587");
        CharacterUtilTest.assertScrubEquals("Emoji preserved", "\ud83d\ude00", "\ud83d\ude00");
        CharacterUtilTest.assertScrubEquals("Empty string", "", "");
    }

    private static void testPrudentlyScrubCharacterData() {
        CharacterUtilTest.assertPrudentScrubEquals("ASCII text unchanged", "Hello, World!", "Hello, World!");
        CharacterUtilTest.assertPrudentScrubEquals("Tab preserved", "Hello\tWorld", "Hello\tWorld");
        CharacterUtilTest.assertPrudentScrubEquals("Newline preserved", "Hello\nWorld", "Hello\nWorld");
        CharacterUtilTest.assertPrudentScrubEquals("Carriage return preserved", "Hello\rWorld", "Hello\rWorld");
        CharacterUtilTest.assertPrudentScrubEquals("BOM removed", "\ufeffHello", "Hello");
        CharacterUtilTest.assertPrudentScrubEquals("BOM in middle removed", "Hello\ufeffWorld", "HelloWorld");
        CharacterUtilTest.assertPrudentScrubEquals("DEL U+007F removed", "Hello\u007fWorld", "HelloWorld");
        CharacterUtilTest.assertPrudentScrubEquals("C1 U+0080 removed", "Hello\u0080World", "HelloWorld");
        CharacterUtilTest.assertPrudentScrubEquals("C1 U+009F removed", "Hello\u009fWorld", "HelloWorld");
        CharacterUtilTest.assertPrudentScrubEquals("Nonchar U+FDD0 removed", "Hello\ufdd0World", "HelloWorld");
        CharacterUtilTest.assertPrudentScrubEquals("Nonchar U+FDDF removed", "Hello\ufddfWorld", "HelloWorld");
        CharacterUtilTest.assertPrudentScrubEquals("Unicode preserved", "Caf\u00e9", "Caf\u00e9");
        CharacterUtilTest.assertPrudentScrubEquals("Empty string", "", "");
    }

    private static void assertScrubEquals(String testName, String input, String expected) {
        String actual = CharacterUtil.scrubCharacterData(input);
        if (expected.equals(actual)) {
            CharacterUtilTest.pass("scrubCharacterData: " + testName);
        } else {
            System.out.println("FAIL: scrubCharacterData: " + testName);
            System.out.println("  Input: " + CharacterUtilTest.escapeForDisplay(input));
            System.out.println("  Expected: " + CharacterUtilTest.escapeForDisplay(expected));
            System.out.println("  Actual: " + CharacterUtilTest.escapeForDisplay(actual));
            ++failed;
        }
    }

    private static void assertPrudentScrubEquals(String testName, String input, String expected) {
        String actual = CharacterUtil.prudentlyScrubCharacterData(input);
        if (expected.equals(actual)) {
            CharacterUtilTest.pass("prudentlyScrubCharacterData: " + testName);
        } else {
            System.out.println("FAIL: prudentlyScrubCharacterData: " + testName);
            System.out.println("  Input: " + CharacterUtilTest.escapeForDisplay(input));
            System.out.println("  Expected: " + CharacterUtilTest.escapeForDisplay(expected));
            System.out.println("  Actual: " + CharacterUtilTest.escapeForDisplay(actual));
            ++failed;
        }
    }

    private static String escapeForDisplay(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < ' ' || c == '\u007f' || c >= '\u0080' && c <= '\u009f' || c == '\ufeff') {
                sb.append(String.format("\\u%04X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void pass(String testName) {
        System.out.println("PASS: " + testName);
        ++passed;
    }
}

