/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.directive;

import java.util.List;
import java.util.Locale;
import org.htmlunit.csp.Directive;
import org.htmlunit.csp.Policy;

public class RequireTrustedTypesForDirective
extends Directive {
    private static final String SCRIPT = "'script'";
    private boolean script_ = false;

    public RequireTrustedTypesForDirective(List<String> values, Directive.DirectiveErrorConsumer errors) {
        super(values);
        if (values.isEmpty()) {
            errors.add(Policy.Severity.Error, "The require-trusted-types-for directive requires a value", -1);
            return;
        }
        int index = 0;
        for (String token : values) {
            String lowcaseToken;
            switch (lowcaseToken = token.toLowerCase(Locale.ROOT)) {
                case "'script'": {
                    if (!this.script_) {
                        this.script_ = true;
                        break;
                    }
                    errors.add(Policy.Severity.Warning, "Duplicate keyword 'script'", index);
                    break;
                }
                default: {
                    if (token.startsWith("'") && token.endsWith("'")) {
                        errors.add(Policy.Severity.Error, "Unrecognized require-trusted-types-for keyword " + token, index);
                        break;
                    }
                    errors.add(Policy.Severity.Error, "Unrecognized require-trusted-types-for value " + token + " - keywords must be wrapped in single quotes", index);
                }
            }
            ++index;
        }
    }

    public boolean script() {
        return this.script_;
    }

    public void setScript_(boolean script) {
        if (this.script_ == script) {
            return;
        }
        if (script) {
            this.addValue(SCRIPT);
        } else {
            this.removeValueIgnoreCase(SCRIPT);
        }
        this.script_ = script;
    }
}

