/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.spec;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.EventRequest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jde.debugger.Debugger;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.spec.AccessWatchpointSpec;
import jde.debugger.spec.EventRequestSpec;
import jde.debugger.spec.ExceptionSpec;
import jde.debugger.spec.LineBreakpointSpec;
import jde.debugger.spec.MethodBreakpointSpec;
import jde.debugger.spec.ModificationWatchpointSpec;
import jde.debugger.spec.PatternReferenceTypeSpec;
import jde.debugger.spec.SourceNameReferenceTypeSpec;
import jde.debugger.spec.WatchpointSpec;

public class EventRequestSpecList
implements Protocol {
    private Map m_eventRequestSpecs = new HashMap();
    private Debugger m_debugger;

    public EventRequestSpecList(Debugger debugger) {
        this.m_debugger = debugger;
    }

    public void resolve(ReferenceType refType) {
        Map map = this.m_eventRequestSpecs;
        synchronized (map) {
            Iterator iter = this.m_eventRequestSpecs.values().iterator();
            while (iter.hasNext()) {
                EventRequestSpec ers = (EventRequestSpec)iter.next();
                try {
                    ers.attemptResolve(refType, this.m_debugger.getProcID());
                }
                catch (JDEException e) {
                    JDE.debug(8, e.toString());
                    this.m_eventRequestSpecs.remove(ers.getID());
                }
            }
        }
    }

    public void install(EventRequestSpec ers) throws JDEException {
        Map map = this.m_eventRequestSpecs;
        synchronized (map) {
            this.m_eventRequestSpecs.put(ers.getID(), ers);
        }
        try {
            ers.attemptImmediateResolve(this.m_debugger.getVM(), this.m_debugger.getProcID());
        }
        catch (JDEException e) {
            Map map2 = this.m_eventRequestSpecs;
            synchronized (map2) {
                this.m_eventRequestSpecs.remove(ers.getID());
            }
            throw e;
        }
    }

    public void delete(EventRequestSpec ers) {
        EventRequest request = ers.getEventRequest();
        Map map = this.m_eventRequestSpecs;
        synchronized (map) {
            this.m_eventRequestSpecs.remove(ers.getID());
        }
        if (request != null) {
            request.virtualMachine().eventRequestManager().deleteEventRequest(request);
        }
    }

    public void removeSpec(Long specID) throws JDEException {
        Map map = this.m_eventRequestSpecs;
        synchronized (map) {
            if (!this.m_eventRequestSpecs.containsKey(specID)) {
                throw new JDEException("'" + specID + "' doesn't exist");
            }
            this.delete((EventRequestSpec)this.m_eventRequestSpecs.get(specID));
        }
    }

    public EventRequestSpec createExceptionIntercept(String classPattern, boolean notifyCaught, boolean notifyUncaught) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        ExceptionSpec ers = new ExceptionSpec(refSpec, notifyCaught, notifyUncaught);
        return ers;
    }

    public WatchpointSpec createAccessWatchpoint(String classPattern, String m) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        AccessWatchpointSpec ers = new AccessWatchpointSpec(refSpec, m);
        return ers;
    }

    public WatchpointSpec createModificationWatchpoint(String classPattern, String m) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        ModificationWatchpointSpec ers = new ModificationWatchpointSpec(refSpec, m);
        return ers;
    }

    public EventRequestSpec createClassLineBreakpoint(String classPattern, int line) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        LineBreakpointSpec ers = new LineBreakpointSpec(refSpec, line);
        return ers;
    }

    public EventRequestSpec createSourceLineBreakpoint(String sourceName, int line) {
        SourceNameReferenceTypeSpec refSpec = new SourceNameReferenceTypeSpec(sourceName, line);
        LineBreakpointSpec ers = new LineBreakpointSpec(refSpec, line);
        return ers;
    }

    public EventRequestSpec createMethodBreakpoint(String classPattern, String methodId, List methodArgs) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        MethodBreakpointSpec e = new MethodBreakpointSpec(refSpec, methodId, methodArgs);
        return e;
    }
}

