<?php

return [
    'title' => 'მორგება',
    'readonly' => 'დააყენეთ config.php-ში, წაშალეთ config.php-დან გასააქტიურებლად.',
    'groups' => [
        'alerting' => 'განგაშები',
        'api' => 'API',
        'auth' => 'ავთენტიკაცია',
        'authorization' => 'ავტორიზაცია',
        'external' => 'გარე',
        'global' => 'გლობალური',
        'os' => 'ოს-ი',
        'discovery' => 'აღმოჩენა',
        'graphing' => 'გრაფიკები',
        'poller' => 'მომთხოვნი',
        'system' => 'სისტემა',
        'webui' => 'ვებინტერფეისი',
    ],
    'sections' => [
        'alerting' => [
            'general' => ['name' => 'განგაშის ზოგადი პარამეტრები'],
            'email' => ['name' => 'ელფოსტის მორგება'],
            'rules' => ['name' => 'განგაშის ნაგულისხმევი წესების პარამეტრები'],
        ],
        'api' => [
            'cors' => ['name' => 'CORS'],
        ],
        'auth' => [
            'general' => ['name' => 'ავთენტიკაციის ზოგადი პარამეტრები'],
            'ad' => ['name' => 'Active Directory-ის მორგება'],
            'ldap' => ['name' => 'LDAP-ის მორგება'],
            'radius' => ['name' => 'Radius-ის მორგება'],
            'socialite' => ['name' => 'Socialite-ის მორგება'],
            'http' => ['name' => 'HTTP ავთენტიკაციის მორგება'],
        ],
        'authorization' => [
            'device-group' => ['name' => 'Device Group Settings'],
        ],
        'discovery' => [
            'general' => ['name' => 'მოწყობილობის ჯგუფების პარამეტრები'],
            'route' => ['name' => 'რაუტების აღმოჩენის მოდული'],
            'discovery_modules' => ['name' => 'აღმოჩენის მოდულები'],
            'autodiscovery' => ['name' => 'ქსელის აღმოჩენა'],
            'ports' => ['name' => 'პორტების მოდული'],
            'storage' => ['name' => 'საცავის მოდული'],
        ],
        'external' => [
            'binaries' => ['name' => 'გამშვების ფაილების მდებარეობა'],
            'location' => ['name' => 'მდებარეობის პარამეტრები'],
            'graylog' => ['name' => 'Graylog-თან ინტეგრაცია'],
            'oxidized' => ['name' => 'Oxidized-თან ინტეგრაცია'],
            'mac_oui' => ['name' => 'Mac OUI-ის ძებნასთან ინტეგრაცია'],
            'peeringdb' => ['name' => 'PeeringDB-თან ინტეგრაცია'],
            'nfsen' => ['name' => 'NfSen-თან ინტეგრაცია'],
            'unix-agent' => ['name' => 'Unix-Agent-თან ინტეგრაცია'],
            'smokeping' => ['name' => 'Smokeping-თან ინტეგრაცია'],
            'snmptrapd' => ['name' => 'SNMP Traps-თან ინტეგრაცია'],
        ],
        'poller' => [
            'availability' => ['name' => 'მოწყობილობების ხელმისაწვდომობა'],
            'distributed' => ['name' => 'განაწილებული  გამომთხოვი'],
            'graphite' => ['name' => 'მონაცემების საცავი: Graphite'],
            'influxdb' => ['name' => 'მონაცემების საცავი: InfluxDB'],
            'influxdbv2' => ['name' => 'მონაცემების საცავი: InfluxDBv2'],
            'opentsdb' => ['name' => 'მონაცემების საცავი: OpenTSDB'],
            'ping' => ['name' => 'პინგი'],
            'prometheus' => ['name' => 'მონაცემების საცავი: Prometheus'],
            'rrdtool' => ['name' => 'მონაცემების საცავი: RRDTool'],
            'snmp' => ['name' => 'SNMP'],
            'dispatcherservice' => ['name' => 'დისპეჩერის სერვისი'],
            'poller_modules' => ['name' => 'გამომთხოვის მოდულები'],
        ],
        'system' => [
            'cleanup' => ['name' => 'გასუფთავება'],
            'proxy' => ['name' => 'პროქსი'],
            'updates' => ['name' => 'განახლებები'],
            'scheduledtasks' => ['name' => 'დაგეგმილი ამოცანები'],
            'server' => ['name' => 'სერვერი'],
            'reporting' => ['name' => 'ანგარიშები'],
        ],
        'webui' => [
            'availability-map' => ['name' => 'ხელმისაწვდომობის რუკის პარამეტრები'],
            'custom-map' => ['name' => 'მომხმარებლის რუკის პარამეტრები'],
            'graph' => ['name' => 'გრაფიკების მორგება'],
            'dashboard' => ['name' => 'სამუშაო მაგიდის მორგება'],
            'port-descr' => ['name' => 'ინტერფეისის აღწერის დამუშავება'],
            'search' => ['name' => 'ძებნის მორგება'],
            'style' => ['name' => 'სტილი'],
            'device' => ['name' => 'მოწყობილობის მორგება'],
            'worldmap' => ['name' => 'მსოფლიოს რუკის მორგება'],
        ],
    ],
    'settings' => [
        'active_directory' => [
            'users_purge' => [
                'description' => 'არააქტიური მომხმარებლების შენარჩუნების დრო',
                'help' => 'მომხმარებლები წაიშლება LibreNMS-დან ამდენი დღის შემდეგ შესვლის გარეშე. 0 ნიშნავს არასდროს და მომხმარებლები აღდგება, თუ ისინი კვლავ შევლენ სისტემაში.',
            ],
        ],
        'addhost_alwayscheckip' => [
            'description' => 'გამეორებული IP-ის შემოწმება მოწყობილობების დამატებისას',
            'help' => 'თუ ჰოსტი ემატება როგორც IP მისამართი, მოწმდება, რომ ეს IP უკვე არ იყოს არსებული. თუ IP უკვე არსებობს, ჰოსტი არ დაემატება. თუ ჰოსტი ემატება სახელით, ეს შემოწმება არ ხდება. თუ პარამეტრი ჩართულია, ჰოსტის სახელი იშლება და შემოწმებაც ხორციელდება. ეს ხელს უშლის ჰოსტების შემთხვევით დუბლირებას.',
        ],
        'alert_rule' => [
            'acknowledged_alerts' => [
                'description' => 'მიღებული განგაშები',
                'help' => 'განგაშების გაგზავნა, როცა განგაში მიღებულია',
            ],
            'severity' => [
                'description' => 'სიმძიმე',
                'help' => 'სიმძიმე განგაშისთვის',
            ],
            'max_alerts' => [
                'description' => 'მაქს განგაშები',
                'help' => 'გასაგზავნი განგაშების რაოდენობა',
            ],
            'delay' => [
                'description' => 'დაყოვნება',
                'help' => 'დაყოვნება განგაშის გაგზავნამდე',
            ],
            'interval' => [
                'description' => 'ინტერვალი',
                'help' => 'შემოწმების ინტერვალი ამ განგაშისთვის',
            ],
            'mute_alerts' => [
                'description' => 'განგაშების დადუმება',
                'help' => 'იქნება თუ არა განგაში ნაჩვენები, მხოლოდ, ვებინტერფეისში',
            ],
            'invert_rule_match' => [
                'description' => 'წესების დამთხვევის ინვერსია',
                'help' => 'განგაშის გაგზავნა მაშინ, თუ წესი არ ემთხვევა',
            ],
            'recovery_alerts' => [
                'description' => 'აღდგენის განგაშები',
                'help' => 'გაფრთხილება, თუ განგაში აღდგება',
            ],
            'acknowledgement_alerts' => [
                'description' => 'განგაშების მიღება',
                'help' => 'გაფრთხილება, თუ განგაში მიღებულია',
            ],
            'invert_map' => [
                'description' => 'ყველა მოწყობილობა სიაში არმყოფების გარდა',
                'help' => 'განგაშები ყველა მოწყობილობებისთვის, რომლებიც სიაში არაა',
            ],
        ],
        'alert' => [
            'ack_until_clear' => [
                'description' => 'ნაგულისხმევი მიღება სანამ განგაში გაასუფთავებს პარამეტრს',
                'help' => 'ნაგულისხმევი მირება, სანამ განგაში დასრულდება',
            ],
            'admins' => [
                'description' => 'განგაშების გაგზავნა ადმინებისთვის (მოძველებულია)',
                'help' => 'Deprecated, use the mail alert transport instead.',
            ],
            'default_copy' => [
                'description' => 'ყველა ელფოსტის განგაშების კოპირება ნაგულისხმევი კონტაქტისთვის (მოძველებულია)',
                'help' => 'მოძველებულია. გამოიყენეთ ელფოსტის განგაშის ტრანსპორტი.',
            ],
            'default_if_none' => [
                'description' => 'ვერ ხედავთ ვებინტერფეისში? (მოძველებულია)',
                'help' => 'მოძველებულია. გამოიყენეთ ელფოსტის განგაშის ტრანსპორტი.',
            ],
            'default_mail' => [
                'description' => 'ნაგულისხმევი კონტაქტი (მოძველებულია)',
                'help' => 'მოძველებულია. გამოიყენეთ ელფოსტის განგაშის ტრანსპორტი.',
            ],
            'default_only' => [
                'description' => 'განგაშების, მხოლოდ, ნაგულისხმევი კონტაქტისთვის გაგზავნა (მოძველებულია)',
                'help' => 'მოძველებულია. გამოიყენეთ ელფოსტის განგაშის ტრანსპორტი.',
            ],
            'disable' => [
                'description' => 'განგაშების გათიშვა',
                'help' => 'განგაშების გენერაციის გამორთვა',
            ],
            'acknowledged' => [
                'description' => 'მიღებული განგაშების გაგზავნა',
                'help' => 'გაფრთხილება, თუ განგაში მიღებულია',
            ],
            'fixed-contacts' => [
                'description' => 'კონტაქტის ცვლილებების გამორთვა აქტიური განგაშებისთვის',
                'help' => 'თუ ჭეშმარიტია, sysContact-ის,ან მომხმარებლის ელფოსტის ცვლილება მხედველობაში მიღებული არ იქნება, სანამ განგაში აქტიურია',
            ],
            'globals' => [
                'description' => 'განგაშების გაგზავნა მხოლოდ-წაკითხვადი მომხმარებლებისთვის (მოძველებულია)',
                'help' => 'მოძველებულია. გამოიყენეთ ელფოსტის განგაშის ტრანსპორტი.',
            ],
            'syscontact' => [
                'description' => 'განგაშების გაგზავნა sysContact-სთვის (მოძველებულია)',
                'help' => 'მოძველებულია. გამოიყენეთ ელფოსტის განგაშის ტრანსპორტი.',
            ],
            'transports' => [
                'mail' => [
                    'description' => 'ელფოსტით განგაშების ჩართვა',
                    'help' => 'ელფოსტით განგაშების ტრანსპორტი',
                ],
            ],
            'tolerance_window' => [
                'description' => 'დასაშვები ფანჯარა cron-სთვის',
                'help' => 'დასაშვები ფანჯარა წამებში',
            ],
            'users' => [
                'description' => 'განგაშების გაგზავნა ნორმალური მომხმარებლებისთვის (მოძველებულია)',
                'help' => 'მოძველებულია. გამოიყენეთ ელფოსტის განგაშის ტრანსპორტი.',
            ],
        ],
        'alert_log_purge' => [
            'description' => 'განგაშების ჟურნალის ჩანაწერები, ძველი, ვიდრე',
            'help' => 'მოსუფთავებას ახდენს სკრიპტი daily.sh',
        ],
        'discovery_on_reboot' => [
            'description' => 'აღმოჩენა გადატვირთვისას',
            'help' => 'გადატვირთული მოწყობილობის აღმოჩენა',
        ],
        'allow_duplicate_sysName' => [
            'description' => 'გამეორებული sysName-ის დაშვება',
            'help' => 'ნაგულისხმევად, დუბლირებული sysName-ები ვერ დაემატება, რათა თავიდან იქნას აცილებული მოწყობილობის მრავალჯერადი დამატება მრავალი ინტერფეისით',
        ],
        'allow_unauth_graphs' => [
            'description' => 'არაავტორიზებული დაშვება გრაფიკებთან',
            'help' => 'გრაფიკებთან ყველას მიშვება შესვლის გარეშე',
        ],
        'allow_unauth_graphs_cidr' => [
            'description' => 'გრაფიკებთან წვდომის მინიჭება მითითებული ქსელებისთვის',
            'help' => 'არაავტორიზებული წვდომის დაშვება გრაფიკებთან მითითებული ქსელებისთვის (არ გამოიყენება, როცა არაავტორიზებული გრაფიკები ჩართულია)',
        ],
        'api' => [
            'cors' => [
                'allowheaders' => [
                    'description' => 'თავსართების დაშვება',
                    'help' => 'დააყენებს პასუხის თავსართს Access-Control-Allow-Headers',
                ],
                'allowcredentials' => [
                    'description' => 'ავტორიზაციის დეტალების დაშვება',
                    'help' => 'დააყენებს თავსართს Access-Control-Allow-Credentials',
                ],
                'allowmethods' => [
                    'description' => 'დაშვებული მეთოდები',
                    'help' => 'ემთხვევა მოთხოვნის მეთოდს.',
                ],
                'enabled' => [
                    'description' => 'CORS-ის მხარდაჭერის ჩართვა API-სთვის',
                    'help' => 'API-ის რესურსების ჩატვირთვის დაშვება ვებკლიენტიდან',
                ],
                'exposeheaders' => [
                    'description' => 'თავსართების გამოჩენა',
                    'help' => 'დააყენებს პასუხის თავსართს Access-Control-Expose-Headers',
                ],
                'maxage' => [
                    'description' => 'მაქს. ასაკი',
                    'help' => 'დააყენებს პასუხის თავსართს Access-Control-Max-Age',
                ],
                'origin' => [
                    'description' => 'მოთხოვნის წყაროების დაშვება',
                    'help' => 'ამოწმებს მოთხოვნის წყაროს. შეგიძლიათ, გამოიყენოთ ვაილდკარდები.მაგ: *.mydomain.com',
                ],
            ],
        ],
        'apps' => [
            'powerdns-recursor' => [
                'api-key' => [
                    'description' => 'API გასაღები PowerDNS რეკურსორისთვის',
                    'help' => 'API გასაღები PowerDNS რეკურსორის აპისთვის, როცა პირდაპირ უერთდებით',
                ],
                'https' => [
                    'description' => 'იყენებს PowerDNS-ის რეკურსორი HTTPS-ს?',
                    'help' => 'HTTPS-ის გამოყენება HTTP-ის მაგიერ PowerDNS-ის რესკურსორის აპისთვის, როცა მას პირდაპირ უერთდებით',
                ],
                'port' => [
                    'description' => 'PowerDNS-ის რეკურსორის პორტი',
                    'help' => 'TCP პორტი, რომელიც გამოიყენება PowerDNS-ის რეკურსორისთვის, როცა მას პირდაპირ უერთდებით',
                ],
            ],
        ],
        'astext' => [
            'description' => 'გასაღები ავტონომიური სისტემების აღწერის კეშის შესანახად',
        ],
        'auth' => [
            'allow_get_login' => [
                'description' => 'შესვლის დაშვება (დაუცველი)',
                'help' => 'შესვლის დაშვება მომხმარებლის სახელის და პაროლის ცვლადების get მოთხოვნაში ჩადებით.სასარგებლოა იმ სსისტემების საჩვენებლად, სადაც ინტერაქტიულად ვერ შეხვალთ. ეს დაუცველად ითვლენა, რადგან პაროლი ჟურნალში გამოჩნდება.',
            ],
            'socialite' => [
                'redirect' => [
                    'description' => 'შესვლის გვერდის გადამისამართება',
                    'help' => 'შესვლის გვერდი დაუყოვნებლივ გადაგამისამართებთ პირველ აღწერილ მომწოდებელზე.<br><br>რჩევა: ამისი თავიდან აცილება ბმულის ბოლოში ?redirect=0 მიწერით შეგიძლიათ',
                ],
                'register' => [
                    'description' => 'მომწოდებლის გავლით რეგისტრაციის დაშვება',
                ],
                'configs' => [
                    'description' => 'მომწოდებლის კონფიგურაციები',
                ],
                'scopes' => [
                    'description' => 'დიაპაზონები, რომლებიც ავთენტიკაციის მოთხოვნაში უნდა ჩაისვას',
                    'help' => 'See https://laravel.com/docs/10.x/socialite#access-scopes',
                ],
                'default_role' => [
                    'description' => 'ნაგულისხმევი როლი',
                ],
                'claims' => [
                    'description' => 'გამოთხოვები',
                    'help' => 'ჯგუფების ასახვა როლებზე',
                ],
            ],
        ],
        'auth_ad_base_dn' => [
            'description' => 'საბაზისო DN',
            'help' => 'ჯგუფები და მომხმარებლები ამ dn-ის ქვეშ უნდა იყოს. მაგ: dc=example,dc=com',
        ],
        'auth_ad_check_certificates' => [
            'description' => 'სერტიფიკატის შემოწმება',
            'help' => 'სერტიფიკატების სინამდვილის შემოწმება. ზოგიერთი სერვერი თვითხელმოწერილ სერტიფიკატს იყენებს. ამის გამორთვა ასეთ სერვერებს ჩართავს.',
        ],
        'auth_ad_debug' => [
            'description' => 'გამართვა',
            'help' => 'დეტალური შეცდომის შეტყობინებების ჩვენება. არ დატოვოთ ეს ჩართული. წინააღმდეგ შემთხვევაში, შეიძლება, მონაცემების გაჟონვა მოხდეს.',
        ],
        'auth_ad_domain' => [
            'description' => 'Active Directory-ის დომენი',
            'help' => 'Active Directory-ის დომენის მაგალითი: example.com',
        ],
        'auth_ad_group_filter' => [
            'description' => 'LDAP-ის ჯგუფების ფილტრი',
            'help' => 'Active Directory LDAP-ის ფილტრი ჯგუფების ასარჩევად',
        ],
        'auth_ad_groups' => [
            'description' => 'ჯგუფის წვდომა',
            'help' => 'აღწერეთ ჯგუფები, რომლებსაც აქვთ წვდომა და დონე',
        ],
        'auth_ad_require_groupmembership' => [
            'description' => 'ჯგუფის წევრობის მოთხოვნა',
            'help' => 'შესვლის უფლების მიცემა მომხმარებლებისთვის, მხოლოდ, მაშინ, როცა ისინი მითითებული ჯგუფის წევრები არიან',
        ],
        'auth_ad_user_filter' => [
            'description' => 'LDAP-ის მომხმარებლების ფილტრი',
            'help' => 'Active Directory LDAP-ის ფილტრი მომხმარებლების ასარჩევად',
        ],
        'auth_ad_url' => [
            'description' => 'Active Directory-ის სერვერები',
            'help' => 'დააყენეთ სერვერები, ჰარეთი გამოყოფილი. პრეფიქსით ldaps:// ssl-სთვის. მაგ: ldaps://dc1.example.com ldaps://dc2.example.com',
        ],
        'auth_ldap_attr' => [
            'uid' => [
                'description' => 'ატრიბუტები მომხმარებლის სახელის შესამოწმებლად',
                'help' => 'მომხმარებლის სახელის მიხედვით მომხმარებლის იდენტიფიკაციისთვის გამოყენებული ატრიბუტები',
            ],
        ],
        'auth_ldap_binddn' => [
            'description' => 'Bind DN (გადაფარავს მიბმის მომხმარებლის სახელს)',
            'help' => 'მიბმის მომხმარებლოს სრული DN',
        ],
        'auth_ldap_bindpassword' => [
            'description' => 'მიბმის პაროლი',
            'help' => 'პაროლი მიბმის მომხმარებლისთვის',
        ],
        'auth_ldap_binduser' => [
            'description' => 'მიბმის მომხმარებლის სახელი',
            'help' => 'გამოიყენება LDAP სერვერზე მოთხოვნის გასაგზავნად, როცა მომხმარებელი შესული არაა(განგაშები, API და ა.შ.)',
        ],
        'auth_ad_binddn' => [
            'description' => 'მიბმის DN (გადაფარავს მიბმის მომხმარებლის სახელს)',
            'help' => 'მიბმის მომხმარებლის სრული DN',
        ],
        'auth_ad_bindpassword' => [
            'description' => 'მიბმის პაროლი',
            'help' => 'პაროლი მიბმის მომხმარებლისთვის',
        ],
        'auth_ad_binduser' => [
            'description' => 'მიბმის მომხამრებლის სახელი',
            'help' => 'გამოიყენება AD სერვერზე მოთხოვნების გასაგზავნად, როცა მომხმარებელი შესული არაა (განგაშები, API და ა.შ.)',
        ],
        'auth_ad_starttls' => [
            'description' => 'STARTTLS-ის გამოყენება',
            'help' => 'STARTTLS-ის გამოყენება კავშირის დასაცავად. წარმოადგენს LDAPS-ის ალტერნატივას.',
            'options' => [
                'disabled' => 'გამორთულია',
                'optional' => 'არასავალდებულოა',
                'required' => 'სავალდებულოა',
            ],
        ],
        'auth_ldap_cache_ttl' => [
            'description' => 'LDAP-ის კეშის ვადა',
            'help' => 'დროებით ინახავს LDAP მოთხოვნის შედეგებს.  აუმჯობესებს სიჩქარეს, მაგრამ, მონაცემები, შეიძლება, მოძველებული იყოს.',
        ],
        'auth_ldap_debug' => [
            'description' => 'გამართვის ჩვენება',
            'help' => 'გამართვის ინფორმაციის ჩვენება.  შეიძლება გაიჟონოს კონფიდენციალური ინფორმაცია. ნუ დატოვებთ ჩართულს.',
        ],
        'auth_ldap_cacertfile' => [
            'description' => 'სისტემის TLS CA სერტიფიკატის გადაფარვა',
            'help' => 'მითითებული CA სერტიფიკატის გამოყენება LDAPS-სთვის.',
        ],
        'auth_ldap_ignorecert' => [
            'description' => 'სწორი სერტიფიკატი მოთხოვნილი არ იქნება',
            'help' => 'LDAPS-სთვის სწორი TLS სერტიფიკატის ქონა მოთხოვნილი არ იქნება.',
        ],
        'auth_ldap_emailattr' => [
            'description' => 'ელფოსტის ატრიბუტი',
        ],
        'auth_ldap_group' => [
            'description' => 'წვდომის DN ჯგუფები',
            'help' => 'უნიკალური სახელი ჯგუფისთვის ნორმალური დონის წვდომის მისანიჭებლად. მაგ: cn=groupname,ou=groups,dc=example,dc=com',
        ],
        'auth_ldap_groupbase' => [
            'description' => 'ჯგუფის საბაზისო DN',
            'help' => 'უნიკალური სახელი ჯგუფების მოსაძებნად. მაგალითად: ou=group,dc=example,dc=com',
        ],
        'auth_ldap_groupmemberattr' => [
            'description' => 'ჯგუფის წევრის ატრიბუტი',
        ],
        'auth_ldap_groupmembertype' => [
            'description' => 'ჯგუფის წევრების პოვნის პირობა',
            'options' => [
                'username' => 'მომხმარებლის სახელი',
                'fulldn' => 'სრული DN (პრეფიქსის და სუფიქსის გამოყენებით)',
                'puredn' => 'DN ძებნა (ძებნა ატრიბუტით uid)',
            ],
        ],
        'auth_ldap_groups' => [
            'description' => 'წვდომა ჯგუფებთან',
            'help' => 'აღწერეთ ჯგუფები, რომლებსაც აქვთ წვდომა და დონე',
        ],
        'auth_ldap_require_groupmembership' => [
            'description' => 'LDAP ჯგუფის წევრობის გადამოწმება',
            'help' => 'ldap_compare-ის გაშვება (ან გამოტოვება) როცა მომწოდებელი უშვებს ამას (ან არ უშვებს) შედარების ქმედებისთვის.',
        ],
        'auth_ldap_port' => [
            'description' => 'LDAP-ის პორტი',
            'help' => 'სერვერებთან მისაერთებელი პორტის ნომერი. LDAP-სთვის უნდა იყოს 389. LDAP-სთვის კი 636',
        ],
        'auth_ldap_prefix' => [
            'description' => 'მომხმარებლის პრეფიქსი',
            'help' => 'გამოიყენება მომხმარებლის სახელის უნიკალურ სახელად გარდასაქმნელად',
        ],
        'auth_ldap_server' => [
            'description' => 'LDAP სერვერ(ებ)-ი',
            'help' => 'დააყენეთ სერვერ(ებ)-ი, ჰარეთი გამოყოფილი. ssl-ისთვის გამოიყენეთ პრეფიქსი ldaps://',
        ],
        'auth_ldap_starttls' => [
            'description' => 'STARTTLS-ის გამოყენება',
            'help' => 'STARTTLS-ის გამოყენება კავშირის დასაცავად. წარმოადგენს LDAPS-ის ალტერნატივას.',
            'options' => [
                'disabled' => 'გამორთულია',
                'optional' => 'არასავალდებულოა',
                'required' => 'აუცილებელია',
            ],
        ],
        'auth_ldap_suffix' => [
            'description' => 'მომხმარებლის პრეფიქსი',
            'help' => 'გამოიყენება მომხმარებლის სახელის უნიკალურ სახელად გარდასაქმნელად',
        ],
        'auth_ldap_timeout' => [
            'description' => 'კავშირის მოლოდინის ვადა',
            'help' => 'თუ ერთი ან მეტი სერვერი არ პასუხობს, უფრო მაღალი ვადები ნელ წვდომამდე მიგიყვანთ. მეტისმეტად დაბალი მნიშვნელობა კი ზოგიერთ შემთხვევაში კავშირის ჩავარდნებს გამოიწვევს',
        ],
        'auth_ldap_uid_attribute' => [
            'description' => 'უნიკალური ID ატრიბუტი',
            'help' => 'LDAP ატრიბუტი მომხმარებლების იდენტიფიკაციისთვის. უნდა იყოს რიცხვი',
        ],
        'auth_ldap_userdn' => [
            'description' => 'სრული მომხმარებლის DN-ის გამოყენება',
            'help' => 'გამოიყენებს მომხმარებლის სრულ DNS-ს ჯგუფის წევრის ატრიბუტის მნიშვნელობაში წევრის მაგიერ: მომხმარებელი პრეფიქსით და სუფიქსით. (ის წევრია ჯგუფის: uid=username,ou=groups,dc=domain,dc=com)',
        ],
        'auth_ldap_userlist_filter' => [
            'description' => 'მორგებული LDAP მომხმარებლის ფილტრი',
            'help' => 'მორგებული ldap ფილტრი პასუხების რაოდენობის შესაზღუდად, თუ თქვენს ldap კატალოგში ათასობით მომხმარებელია',
        ],
        'auth_ldap_wildcard_ou' => [
            'description' => 'ვაილდკარდი მომხმარებლის OU',
            'help' => 'მომხმარებლის ძებნა, რომლის მომხმარებლის სახელი დამოუკიდებლად ემთხვევა OU-ს, რომელიც მომხმარებლის პრეფიქსშია მითითებული. სასარგებლოა, თუ თქვენი მომხმარებლები სხვადასხვა OU-შია.მიმაგრების მომხმარებლის სახელი, თუ დაყენებულია, მაინც იყენებს მომხმარებლის სუფიქსს',
        ],
        'auth_ldap_version' => [
            'description' => 'LDAP-ის ვერია',
            'help' => 'სერვერთან სალაპარაკოდ გამოყენებული LDAP-ის ვერსია. ჩვეულებრივ ეს უნდა იყოს v3',
            'options' => [
                '2' => '2',
                '3' => '3',
            ],
        ],
        'auth_mechanism' => [
            'description' => 'ავტორიზაციის მეთოდი (ყურადღებით!)',
            'help' => 'ავტორიზაციის მეთოდი. ფრთხილად. შეიძლება, შესვლის შესაძლებლობა დაკარგოთ. ამის დაბრუნება mysql-ზე config.php-ში\$config[\'auth_mechanism\'] = \'mysql\'; დაყენებით შეგიძლიათ',
            'options' => [
                'mysql' => 'MySQL (ნაგულისხმევი)',
                'active_directory' => 'Active Directory',
                'ldap' => 'LDAP',
                'radius' => 'Radius',
                'http-auth' => 'HTTP ავთენტიკაცია',
                'ad-authorization' => 'გარეთ ავთენტიფიცირებული AD',
                'ldap-authorization' => 'გარეთ ავთენტიფიცირებული LDAP',
                'sso' => 'SSO',
            ],
        ],
        'auth_remember' => [
            'description' => 'ხანგრძლივობა ფუნქციისთვის "დამიმახსოვრე"',
            'help' => 'დღეების რაოდენობა, რომლის განმავლობაშიც მომხმარებელი სისტემაში შესული იქნება, თუ შესვლისას დასვა თოლია "დამიმახსოვრე".',
        ],
        'authlog_purge' => [
            'description' => 'ავტორიზაიიც ჟურნალის ჩანაწერები, ძველი, ვიდრე',
            'help' => 'გასუფთავება ხდება სკრიპტით daily.sh',
        ],
        'peering_descr' => [
            'description' => 'პირინგის პორტის ტიპები',
            'help' => 'პირინგის პორტების მენიუს პუნქტში ჩამოთვლილი აღწერის ტიპის პორტები გამოჩნდება. მეტი ინფორმაციისთვის იხილეთ ინტერფეისის აღწერის დამუშავების დოკუმენტაცია.',
        ],
        'transit_descr' => [
            'description' => 'ტრანზიტის პორტის ტიპები',
            'help' => 'ტრანზიტის პორტების მენიუს პუნქტში ჩამოთვლილი აღწერის ტიპის პორტები გამოჩნდება. მეტი ინფორმაციისთვის იხილეთ ინტერფეისის აღწერის დამუშავების დოკუმენტაცია.',
        ],
        'core_descr' => [
            'description' => 'ძირითადი პორტის ტიპები',
            'help' => 'ძირითადი პორტების მენიუს პუნქტში ჩამოთვლილი აღწერის ტიპის პორტები გამოჩნდება. მეტი ინფორმაციისთვის იხილეთ ინტერფეისის აღწერის დამუშავების დოკუმენტაცია.',
        ],
        'custom_map' => [
            'background_type' => [
                'description' => 'ფონის ტიპი',
                'help' => 'ნაგულისხმევი ფონის ტიპი ახალი რუკებისთვის. სჭირდება დაყენებული ფონის მონაცემების ნაკრები.',
            ],
            'background_data' => [
                'color' => [
                    'description' => 'ფონის ფერი',
                    'help' => 'საწყისი ფერი რუკის ფონისთვის',
                ],
                'lat' => [
                    'description' => 'რუკის ფონის განედი',
                    'help' => 'საწყისი განედი ფონური გეორუკისთვის',
                ],
                'lng' => [
                    'description' => 'რუკის ფონის გრძედი',
                    'help' => 'საწყისი გრძედი ფონური გეორუკისთვის',
                ],
                'layer' => [
                    'description' => 'რუკის ფონის ფენა',
                    'help' => 'საწყისის მასშტაბი ფონური გეორუკისთვის',
                ],
                'zoom' => [
                    'description' => 'ფონის რუკის მასშტაბი',
                    'help' => 'საწყისი მასთავი ფონური გეორუკისთვის',
                ],
            ],
            'edge_font_color' => [
                'description' => 'წიბოს ტექსტის ფერი',
                'help' => 'ნაგულისხმევი ფონტის ფერი წიბოს ჭდეებისთვის',
            ],
            'edge_font_face' => [
                'description' => 'ჭდის ფონტი',
                'help' => 'ნაგულისხმევი ფონტის სახელი წიბოს ჭდეებისთვის',
            ],
            'edge_font_size' => [
                'description' => 'წიბოს ტექსტის ზომა',
                'help' => 'ნაგულისხმევი ფონტის ზომა წიბოს ჭდეებისთვის',
            ],
            'edge_seperation' => [
                'description' => 'წიბოების გაყოფა',
                'help' => 'ნაგულისხმევი წიბოების გაყოფა ახალი რუკებისთვის',
            ],
            'height' => [
                'description' => 'რუკის სიმაღლე',
                'help' => 'ნაგულისხმევი რუკის სიმაღლე ახალი რუკებისთვის',
            ],
            'node_align' => [
                'description' => 'კვანძების განლაგება',
                'help' => 'ნაგულისხმევი კვანძების განლაგება ახალი რუკებისთვის',
            ],
            'node_background' => [
                'description' => 'კვანძის ფონი',
                'help' => 'ნაგულისხმევი ფონის ფერი კვანძის ჭდეებისთვის',
            ],
            'node_border' => [
                'description' => 'კვანძის საზღვარი',
                'help' => 'ნაგულისხმევი საზღვრის ფერი კვანძის ჭდეებისთვის',
            ],
            'node_font_color' => [
                'description' => 'კვანძის ტექსტის ფერი',
                'help' => 'ნაგულისხმევი ფონტის ფერი კვანძის ჭდეებისთვის',
            ],
            'node_font_face' => [
                'description' => 'კვანძის ფონტი',
                'help' => 'ნაგულისხმევი ფონტი კვანძის ჭდეებისთვის',
            ],
            'node_font_size' => [
                'description' => 'კვანძის ტექსტის ზომა',
                'help' => 'ნაგულისხმევი ფონტის ზომა კვანძის ჭდეებისთვის',
            ],
            'node_size' => [
                'description' => 'კვანძის ზომა',
                'help' => 'ნაგულისხმევი ზომა კვანძებისთვის',
            ],
            'node_type' => [
                'description' => 'კვანძის ჩვენების ტიპი',
                'help' => 'ნაგულისხმევი ჩვენების ტიპი კვანძებისთვის',
            ],
            'reverse_arrows' => [
                'description' => 'წიბოს შებრუნებული ისრები',
                'help' => 'ისრების ნაგულისხმევი მიმართულება. ცენტრისკენ (ნაგულისხმევი) თუ ბოლოებისკენ',
            ],
            'width' => [
                'description' => 'რუკის სიგანე',
                'help' => 'ნაგულისხმევი რუკის სიგანე ახალი რუკებისთვის',
            ],
        ],
        'customers_descr' => [
            'description' => 'კლიენტის პორტის ტიპები',
            'help' => 'კლიენტის პორტების მენიუს პუნქტში ჩამოთვლილი აღწერის ტიპის პორტები გამოჩნდება. მეტი ინფორმაციისთვის იხილეთ ინტერფეისის აღწერის დამუშავების დოკუმენტაცია.',
        ],
        'base_url' => [
            'description' => 'მითითებული URL',
            'help' => 'ეს, *მხოლოდ*, მაშინ უნდა დააყენოთ, თუ გნებავთ *ნაძალადევად* მიუთითოთ კონკრეტული ჰოსტის სახელი და პორტი. ეს ხელს შეუშლის, რომ ვებინტერფეისი წვდომადი იყოს ნებისმიერი სხვა ჰოსტის სახელიდან',
        ],
        'discovery_modules' => [
            'arp-table' => [
                'description' => 'ARP ცხრილი',
            ],
            'applications' => [
                'description' => 'აპლიკაციები',
            ],
            'bgp-peers' => [
                'description' => 'BGP პირები',
            ],
            'cisco-cef' => [
                'description' => 'Cisco CEF',
            ],
            'cisco-mac-accounting' => [
                'description' => 'Cisco MAC აღრიცხვა',
            ],
            'cisco-otv' => [
                'description' => 'Cisco OTV',
            ],
            'cisco-qfp' => [
                'description' => 'Cisco QFP',
            ],
            'slas' => [
                'description' => 'მომსახურების დონის შესახებ შეთანხმების თვალყურის დევნება',
            ],
            'cisco-pw' => [
                'description' => 'Cisco PW',
            ],
            'cisco-vrf-lite' => [
                'description' => 'Cisco VRF Lite',
            ],
            'discovery-arp' => [
                'description' => 'ARP აღმოჩენა',
            ],
            'discovery-protocols' => [
                'description' => 'აღმოჩენის პროტოკოლები',
            ],
            'entity-physical' => [
                'description' => 'ფიზიკური ობიექტი',
            ],
            'entity-state' => [
                'description' => 'ობიექტის მდგომარეობა',
            ],
            'fdb-table' => [
                'description' => 'FDB ცხრილი',
            ],
            'hr-device' => [
                'description' => 'HR მოწყობილობა',
            ],
            'ipv4-addresses' => [
                'description' => 'IPv4 მისამართები',
            ],
            'ipv6-addresses' => [
                'description' => 'IPv6 მისამართები',
            ],
            'isis' => [
                'description' => 'ISIS',
            ],
            'junose-atm-vp' => [
                'description' => 'Junose ATM VP',
            ],
            'loadbalancers' => [
                'description' => 'დატვირთვის განმანაწილებლები',
            ],
            'mef' => [
                'description' => 'MEF',
            ],
            'mempools' => [
                'description' => 'Mempools',
            ],
            'mpls' => [
                'description' => 'MPLS',
            ],
            'ntp' => [
                'description' => 'NTP',
            ],
            'os' => [
                'description' => 'OS',
            ],
            'ports' => [
                'description' => 'პორტები',
            ],
            'ports-stack' => [
                'description' => 'პორტების სტეკი',
            ],
            'processors' => [
                'description' => 'პროცესორები',
            ],

            'qos' => [
                'description' => 'QoS',
            ],

            'route' => [
                'description' => 'რაუტი',
            ],

            'sensors' => [
                'description' => 'სენსორები',
            ],

            'services' => [
                'description' => 'სერვისები',
            ],
            'storage' => [
                'description' => 'საცავი',
            ],

            'stp' => [
                'description' => 'STP',
            ],
            'ucd-diskio' => [
                'description' => 'UCD DiskIO',
            ],
            'vlans' => [
                'description' => 'VLan-ები',
            ],
            'vminfo' => [
                'description' => 'ჰაიპერვიზორის VM-ის ინფორმაცია',
            ],
            'vrf' => [
                'description' => 'VRF',
            ],
            'wireless' => [
                'description' => 'უსადენო',
            ],
            'xdsl' => [
                'description' => 'xDSL',
            ],
            'printer-supplies' => [
                'description' => 'პრინტერის მარაგები',
            ],
        ],
        'distributed_poller' => [
            'description' => 'განაწილებული გამოთხოვის ჩართვა (სჭირდება დამატებითი მორგება)',
            'help' => 'განაწილებული გამოთხოვის ჩართვა მთელ სისტემაში. ეს განკუთვნილია დატვირთვის გაზიარებისთვის და არა დაშორებული გამოთხოვისთვის. დოკუმენტაცია ნაბიჯებისთვის, რომ ჩართოთ ის: https://docs.librenms.org/Extensions/Distributed-Poller/',
        ],
        'default_poller_group' => [
            'description' => 'ნაგულისხმევი გამოთხოვის ჯგუფი',
            'help' => 'ნაგულისხმევი გამოთხოვის ჯგუფი ყველა გამომთოხვისთვის, თუ ის config.php-ში დაყენებული არაა',
        ],
        'distributed_poller_memcached_host' => [
            'description' => 'Memcached-ის ჰოსტი',
            'help' => 'memchaced-ის სერვერის სახელი ან IP. ეს აუცილებელია დასაბლოკად სკრიპტებისთვის poller_wrapper.py და daily.sh.',
        ],
        'distributed_poller_memcached_port' => [
            'description' => 'Memcached-ის პორტი',
            'help' => 'memcached-ის სერვერის პორტი. ნაგულისხმევი მნიშვნელობაა 11211',
        ],
        'email_auto_tls' => [
            'description' => 'ავტომატური TLS-ის მხარდაჭერა',
            'help' => 'სცდის, გამოიყენოს TLS, სანამ დაუშიფრავზე გადაერთვება',
        ],
        'email_smtp_verifypeer' => [
            'description' => 'პირის სერტიფიკატის გადამოწმება',
            'help' => 'SMTP სერვერთან TLS-ით მიერთებისას პირის სერტიფიკატი არ გადამოწმდება',
        ],
        'email_smtp_allowselfsigned' => [
            'description' => 'თვითხელმოწერილი სერტიფიკატების დაშვება',
            'help' => 'თვითხელმოწერილი სერტიფიკატების დაშვება SMTP სერვერთან TLS-ის გავლით დაკავშირებისას',
        ],
        'email_attach_graphs' => [
            'description' => 'გრაფიკის სურათების მიმაგრება',
            'help' => 'ეს დააგენერირებს გრაფიკს, როცა განგაშის მიზეზი წარმოიშვება და მას ელფოსტას მიამაგრებს.',
        ],
        'email_backend' => [
            'description' => 'ელფოსტის მიწოდების გზა',
            'help' => 'უკანაბოლო ელფოსტის გასაგზავნად. შეიძლება იყოს mail(), sendmail, ან SMTP',
            'options' => [
                'mail' => 'mail',
                'sendmail' => 'sendmail',
                'smtp' => 'SMTP',
            ],
        ],
        'email_from' => [
            'description' => 'ელფოსტის მისამარტი "ვისგან"',
            'help' => 'ელფოსტის მისამართი, საიდანაც ელფოსტების იგზავნება (ვისგან)',
        ],
        'email_html' => [
            'description' => 'HTML ელფოსტების გამოყენება',
            'help' => 'ელფოსტის გაგზავნა HTML ფორმატში',
        ],
        'email_sendmail_path' => [
            'description' => 'ბილიკი sendmail-ის გამშვებ ფაილამდე',
        ],
        'email_smtp_auth' => [
            'description' => 'SMTP-ის ავთენტიკაცია',
            'help' => 'ჩართეთ ეს, თუ თქვენს თქვენი SMTP სერვერი ავთენტიკაციას მოითხოვს',
        ],
        'email_smtp_host' => [
            'description' => 'SMTP სერვერი',
            'help' => 'IP, ან DNS სახელი SMTP სერვერისთვის, რომლითაც ელფოსტა გაიგზავნება',
        ],
        'email_smtp_password' => [
            'description' => 'SMTP-ის ავთენტიკაციის პაროლი',
        ],
        'email_smtp_port' => [
            'description' => 'SMTP-ის პორტის პარამეტრი',
        ],
        'email_smtp_secure' => [
            'description' => 'დაშიფვრა',
            'options' => [
                '' => 'გათიშულია',
                'tls' => 'TLS',
                'ssl' => 'SSL',
            ],
        ],
        'email_smtp_timeout' => [
            'description' => 'SMTP-ის მოლოდინის დროის პარამეტრი',
        ],
        'email_smtp_username' => [
            'description' => 'SMTP-ის ავთენტიკაციის მომხმარებლის სახელი',
        ],
        'email_user' => [
            'description' => 'სტრიქონი ველისთვის "ვისგან"',
            'help' => 'სახელი, რომელიც გამოიყენება ელფოსტის "ვისგან" ველში',
        ],
        'eventlog_purge' => [
            'description' => 'მოვლენების ჟურნალის ჩანაწერები, რომლებიც ძველია, ვიდრე',
            'help' => 'გასუფთავება ხდება სკრიპტით daily.sh',
        ],
        'favicon' => [
            'description' => 'Favicon',
            'help' => 'გადაფარავს ნაგულისხმევ favicon-ს.',
        ],
        'fping' => [
            'description' => 'ბილიკი fping-მდე',
        ],
        'fping6' => [
            'description' => 'ბილიკი fping6-მდე',
        ],
        'fping_options' => [
            'count' => [
                'description' => 'fping-ების რაოდენობა',
                'help' => 'რამდენი პინგი გაიგზავნება იმის შესამოწმებლად, ცოცხალია თუ არა ჰოსტი ICMP-ის საშუალებით',
            ],
            'interval' => [
                'description' => 'fping-ების ინტერვალი',
                'help' => 'ინტერვალი პინგებს შორის მილიწამებში',
            ],
            'timeout' => [
                'description' => 'fping-ების მოლოდინის ვადა',
                'help' => 'დროის რაოდენობა მილიწამებში, რომლის განმავლობაშიც უნდა დაველოდოთ ექოს, სანამ ხელს ჩავიქნევთ',
            ],
        ],
        'geoloc' => [
            'api_key' => [
                'description' => 'API-ის გასაღები კარტოგრაფიული ძრავისთვის',
                'help' => 'გეოკოდირების API-ის გასაღები (აუცილებელია სამუშაოდ)',
            ],
            'dns' => [
                'description' => 'DNS-ის მდებარეობის ჩანაწერის გამოყენება',
                'help' => 'DNS-ის LOC ჩანაწერის გამოყენება ჰოსტის სახელის გეოგრაფიული კოორდინატების მისაღებად',
            ],
            'engine' => [
                'description' => 'კარტოგრაფიის ძრავა',
                'options' => [
                    'google' => 'Google Maps',
                    'openstreetmap' => 'OpenStreetMap',
                    'mapquest' => 'MapQuest',
                    'bing' => 'Bing Maps',
                    'esri' => 'ESRI ArcGIS',
                ],
            ],
            'latlng' => [
                'description' => 'მდებარეობის გეოკოდირების მცდელობა',
                'help' => 'ცდა, მოიძებნოს გრძედი და განედი გეოკოდირების API-ით ინფორმაციის გამოთხოვისას',
            ],
            'layer' => [
                'description' => 'საწყისი რუკის ფენა',
                'help' => 'საწყისი რუკის ფენა საჩვენებლად. *დაიმახსოვრეთ, რომ ყველა ფენა ხელმისაწვდომი არაა ყველა კარტოგრაფიული ძრავისთვის.',
                'options' => [
                    'Streets' => 'ქუჩები',
                    'Sattelite' => 'თანამგზავრი',
                    'Topography' => 'ტოპოგრაფია',
                ],
            ],
        ],
        'graphite' => [
            'enable' => [
                'description' => 'ჩართვა',
                'help' => 'მეტრიგების გატანა Graphite-ში',
            ],
            'host' => [
                'description' => 'სერვერი',
                'help' => 'Graphite-ის სერვერის IP, ან ჰოსტის სახელი მონაცემების გასაგზავნად',
            ],
            'port' => [
                'description' => 'პორტი',
                'help' => 'Graphite-ის სერვერის პორტი მისაერთებლად',
            ],
            'prefix' => [
                'description' => 'პრეფიქსი (არასავალდებულო)',
                'help' => 'დაამატებს პრეფიქსს ყველა მეტრიკის დასაწყისში. უნდა იყოს ალფარიცხვითი, გამოყოფილი წერტილებით',
            ],
        ],
        'graphing' => [
            'availability' => [
                'description' => 'ხანგრძლივობა',
                'help' => 'მოწყობილობის ხელმისაწვდომობის გამოთვლა ჩამოთვლილი ხანგრძლივობებისთვის. (ხანგრძლივობა იზომება წამებში)',
            ],
            'availability_consider_maintenance' => [
                'description' => 'დაგეგმილ სარემონტო სამუშაოებს ხელმისაწვდომობაზე გავლენა არ აქვთ',
                'help' => 'გამორთავს გათიშვას და დაწევს ხელმისაწვდომობას მოწყობილობებისთვის, რომლებიც რემონტის რეჟიმშია.',
            ],
        ],
        'graphs' => [
            'port_speed_zoom' => [
                'description' => 'პორტის გრაფიკების გადიდება პორტის სიჩქარემდე',
                'help' => 'პორტის გრაფიკების გადიდება ისე, რომ მაქსიმალური ყოველთივს პორტის სიჩქარეა. გათიშული პორტის გრაფიკები ტრაფიკამდე დიდდება',
            ],
        ],
        'graylog' => [
            'base_uri' => [
                'description' => 'საბაზისო URI',
                'help' => 'საბაზისო URI-ის გადაფარვა იმ შემთხვევისთვის, თუ შეცვალეთ Graylog-ის ნაგულისხმევი მნიშვნელობა.',
            ],
            'device-page' => [
                'loglevel' => [
                    'description' => 'მოწყობილობის მიმოხილვის ჟურნალის დონე',
                    'help' => 'აყენებს მაქსიმალურ ჟურნალის დონეს, რომელიც მოწყობილობის მიმოხილვის გვერდზეა ნაჩვენები.',
                ],
                'rowCount' => [
                    'description' => 'მოწყობილობის მიმოხილვის მწკრივების რაოდენობა',
                    'help' => 'აყენებს მწკრივების რაოდენობას მოწყობილობის მიმოხილვის გვერდზე.',
                ],
            ],
            'password' => [
                'description' => 'პაროლი',
                'help' => 'პაროლი Graylog-ის API-სთან წვდომისთვის.',
            ],
            'port' => [
                'description' => 'პორტი',
                'help' => 'პორტი Graylog-ის API-სთან წვდომისთვის. თუ მითითებული არაა, გამოყენებული იქნება 80 HTTP-სთვის და 443 HTTPS-სთვის.',
            ],
            'server' => [
                'description' => 'სერვერი',
                'help' => 'Graylog-ის სერვერის API-ის ბოლოწერტილის IP მისამართი, ან ჰოსტის სახელი.',
            ],
            'timezone' => [
                'description' => 'დროის სარტყლის ჩვენება',
                'help' => 'Graylog-ის დრო GMT-ში ინახება. ეს პარამეტრი ნაჩვენებ დროის სარტყელს შეცვლის. მნიშვნელობა სწორი PHP-ის დროის სარტყელი უნდა იყოს.',
            ],
            'username' => [
                'description' => 'მომხმარებლის სახელი',
                'help' => 'მომხმარებლის სახელი Graylog-ის API-სთან წვდომისთვის.',
            ],
            'version' => [
                'description' => 'ვერსია',
                'help' => 'ეს გამოიყენება Graylog-ის API-სთვის base_uri-ის ავტომატურად შექმნისთვის. თი API-ის uri ხელით შეცვალეთ, დააყენეთ ეს "სხვაზე" და მიუთითე თქვენი base_uri.',
            ],
            'query' => [
                'field' => [
                    'description' => 'API-ის გამოთხოვის ველი',
                    'help' => 'ცვლის ნაგულისხმევ ველს Graylog-ის API-დან გამოთხოვისას.',
                ],
            ],
        ],
        'html' => [
            'device' => [
                'primary_link' => [
                    'description' => 'ძირითადი ჩამოსაშლელი მენიუს ბმული',
                    'help' => 'აყენებს ძირითად ბმულს მოწყობილობის ჩამოსაშლელ მენიუში',
                ],
            ],
        ],
        'http_auth_header' => [
            'description' => 'მომხმარებლის სახელის შემცველი ველის სახელი',
            'help' => 'შეიძლება იყოს ENV, ან HTTP-ის თავსართის ველი, როგორიცაა REMOTE_USER, PHP_AUTH_USER, ან თქვენთვის სასურველი ვარიანტი',
        ],
        'http_auth_guest' => [
            'description' => 'Http ავთენტიკაციის სტუმრის მომხმარებელი',
            'help' => 'თუ დაყენებულია, სასუალებას აძლევს ყველა HTTP მომხმარებელს, გაიარონ ავთენტიკაცია და ანიჭებს უცნობ მომხმარებლებს ლოკალურ მოხმმარებლის სახელს.',
        ],
        'http_proxy' => [
            'description' => 'HTTP პროქსი',
            'help' => 'დააყენეთ ეს, თუ გარემოს ცვლადი http_proxy ხელმისაწვდომი არაა.',
        ],
        'https_proxy' => [
            'description' => 'HTTPS პროქსი',
            'help' => 'დააყენეთ ეს, თუ გარემოს ცვლადი https_proxy ხელმისაწვდომი არაა.',
        ],
        'ignore_mount' => [
            'description' => 'გამოსატოვებელი მიმაგრების წერტილები',
            'help' => 'ამ მიმაგრების წერტილის გამოყენების მონიტორინგი არ მოხდება',
        ],
        'ignore_mount_network' => [
            'description' => 'ქსელური მიმაგრების წერტილების გამოტოვება',
            'help' => 'ქსელური მიმაგრების წერტილების მონიტორინგი არ მოხდება',
        ],
        'ignore_mount_optical' => [
            'description' => 'ოპტიკური ამძრავების გამოტოვება',
            'help' => 'ოპტიკური ამძრავების დისკების გამოყენების მონიტორინგის გათიშვა',
        ],
        'ignore_mount_removable' => [
            'description' => 'მოხსნადი დისკების გამოტოვება',
            'help' => 'მოხსნადი დისკების სისავსის მონიტორინგის გამოტოვება',
        ],
        'ignore_mount_regexp' => [
            'description' => 'გამოსატოვებელი მიმაგრების წერტილების რეგულარული გამოსახულება',
            'help' => 'იმ მიმაგრების წერტილების სისავსის მონიტორინგის გამოტოვება, რომლებიც რეგულარული გამოსახულების პირობას აკმაყოფილებენ',
        ],
        'ignore_mount_string' => [
            'description' => 'ამ სტრიქონის შემცველი მიმაგრების წერტილების გამოტოვება',
            'help' => 'არ მოხდება იმ დისკების გამოყენების მონიტორინგი, რომლებიც ამ სტრიქონებიდან ერთ-ერთს მაინც შეიცავენ.',
        ],
        'influxdb' => [
            'db' => [
                'description' => 'მონაცემთა ბაზა',
                'help' => 'InfluxDB მონაცემთა ბაზის სახელი მეტრიკების შესანახად',
            ],
            'enable' => [
                'description' => 'ჩართვა',
                'help' => 'მეტრიკების გატანა InfluxDB-ში',
            ],
            'host' => [
                'description' => 'სერვერი',
                'help' => 'InfluxDB სერვერის IP მისამართი ან სახელი მონაცემების გასაგზავნად',
            ],
            'password' => [
                'description' => 'პაროლი',
                'help' => 'პაროლი InfluxDB-სთვის, თუ საჭიროა',
            ],
            'port' => [
                'description' => 'პორტი',
                'help' => 'პორტის ნომერი InfluxDB სერვერისთვის, თუ საჭიროა',
            ],
            'timeout' => [
                'description' => 'მოლოდინის დრო',
                'help' => 'რამდენ ხანს დაველოდო InfluxDB სერვერს. 0 ნიშნავს ნაგულისხმევ ვადას',
            ],
            'transport' => [
                'description' => 'ტრანსპორტი',
                'help' => 'ტრანსპორტი InfluxDB სერვერთან მისაერთებლად',
                'options' => [
                    'http' => 'HTTP',
                    'https' => 'HTTPS',
                    'udp' => 'UDPRRRRRRR',
                ],
            ],
            'username' => [
                'description' => 'მომხმარებლის სახელი',
                'help' => 'მომხმარებლის სახელი InfluxDB-სთან მისაერთებლად, თუ აუცილებელია',
            ],
            'verifySSL' => [
                'description' => 'SSL-ის გადამოწმება',
                'help' => 'SSL სერტიფიკატების გადამოწმება მათ სანდოობაზე და სისწორეზე',
            ],
        ],
        'influxdbv2' => [
            'bucket' => [
                'description' => 'კალათა',
                'help' => 'InfluxDB-ის კალათის სახელი მეტრიკების შესანახად',
            ],
            'enable' => [
                'description' => 'ჩართვა',
                'help' => 'მეტრიკების გატანა InfluxDB-ში InfluxDBv2 API-ის გამოყენებით',
            ],
            'host' => [
                'description' => 'სერვერი',
                'help' => 'InfluxDB სერვერის IP მისამართი ან ჰოსტის სახელი მონაცემების გასაგზავნად',
            ],
            'token' => [
                'description' => 'ტოკენი',
                'help' => 'ტოკენი InfluxDB-სთან მისაერთებლად, თუ საჭიროა',
            ],
            'port' => [
                'description' => 'პორტი',
                'help' => 'პორტი InfluxDB სერვერთან მისაერთებლად',
            ],
            'transport' => [
                'description' => 'ტრანსპორტი',
                'help' => 'ტრანსპორტი InfluxDB სერვერთან მისაერთებლად',
                'options' => [
                    'http' => 'HTTP',
                    'https' => 'HTTPS',
                ],
            ],
            'organization' => [
                'description' => 'ორგანიზაცია',
                'help' => 'ორგანიზაცია, რომელიც შეიცავს კალათას InfluxDB სერვერზე',
            ],
            'allow_redirects' => [
                'description' => 'გადამისამართებების დაშვება',
                'help' => 'გადამისამართებების დაშვება InfluxDB სერვერიდან',
            ],
            'debug' => [
                'description' => 'გამართვა',
                'help' => 'CLI-ში დამატებითი შეტყობინებების ჩართვა, ან გამორთვა',
            ],
            'log_file' => [
                'description' => 'ჟურნალის ფაილი',
                'help' => 'აღწერეთ სხვა ჟურნალის ფაილი, თუ გნებავთ, გამართვის ინფორმაცია სხვა ფაილში ჩაწეროთ',
            ],
            'groups-exclude' => [
                'description' => 'ამოღებული მოწყობილობის ჯგუფები',
                'help' => 'InfluxDBv2-ში გაგზავნიდან ამოღებული მოწყობილობის ჯგუფები',
            ],
            'timeout' => [
                'description' => 'მოლოდინის ვადა',
                'help' => 'მოლოდინის ვადა წამებში',
            ],
            'verify' => [
                'description' => 'გადამოწმება',
                'help' => 'სერტიფიკატის გადამოწმება',
            ],
            'batch_size' => [
                'description' => 'პაკეტის ზომა',
                'help' => 'რამდენი მეტრიკა შეიკრიბება ერთად გასაგზავნად',
            ],
            'max_retry' => [
                'description' => 'მაქს. თავიდან ცდა',
                'help' => 'რამდენჯერ უნდა ვცადოთ თავიდან',
            ],
        ],
        'ipmitool' => [
            'description' => 'ბილიკი ipmtool-მდე',
        ],
        'login_message' => [
            'description' => 'შეტყობინება შესვლისას',
            'help' => 'შესვლის გვერდზე ნაჩვენები შეტყობინება',
        ],
        'mac_oui' => [
            'enabled' => [
                'description' => 'MAC OUI-ის ძებნის ჩართვა',
                'help' => 'MAC-მისამართის მწარმოებლის (OUI) მოძებნა (მონაცემების გადმოწერა ხდება სკრიპტის daily.sh მიერ)',
            ],
        ],
        'mono_font' => [
            'description' => 'მონოგანივი ფონტი',
        ],
        'mtr' => [
            'description' => 'ბილიკი mtr-მდე',
        ],
        'mydomain' => [
            'description' => 'ძირითადი დომენი',
            'help' => 'ეს დომენი გამოიყენება ქსელური ავტოაღმოჩენისთვის და სხვა პროცესებისთვის. LibreNMS სცდის, დაუსრულებელ ჰოსტის სახელებს ეს მიაწეროს.',
        ],
        'network_map_show_on_worldmap' => [
            'description' => 'აჩვენებს ქსელის ბმულებს რუკაზე',
            'help' => 'აჩვენებს ქსელების ბმებს სხვადასხვა მდებარეოებებს შორის მსოფლიო რუკაზე.(ამინდის რუკის მსგავსად)',
        ],
        'network_map_worldmap_show_disabled_alerts' => [
            'description' => 'განგაშებ-გამორთული მოწყობილობების ჩვენება',
            'help' => 'რუკაზე იმ მოწყობილობების ჩვენება, რომლებსაც განგაშები გამორთული აქვთ',
        ],
        'network_map_worldmap_link_type' => [
            'description' => 'ქსელის რუკის წყარო',
            'help' => 'აირჩიეთ მონაცემების წყარო ქსელის რუკის ბმულებისთვის',
        ],
        'nfsen_enable' => [
            'description' => 'NfSen-ის ჩართვა',
            'help' => 'NfSen-თან ინტეგრაციის ჩართვა',
        ],
        'nfsen_rrds' => [
            'description' => 'NfSen RRD-ის საქაღალდეები',
            'help' => 'ეს მნიშვნელობა მიუთითებს, სადაა მოთავსებული თქვენი NFSen-ის RRD ფაილები.',
        ],
        'nfsen_subdirlayout' => [
            'description' => 'დააყენეთ NfSen-ის ქვესაქაღალდეების განლაგება',
            'help' => 'ეს უნდა ემთხვეოდეს იმ ქვესაქაღალდეების განლაგებას, რომელიც NFSen-ში დააყენეთ.. 1 ნაგულისხმევია.',
        ],
        'nfsen_last_max' => [
            'description' => 'ბოლო მაქს.',
        ],
        'nfsen_top_max' => [
            'description' => 'საუკეთესო მაქს.',
            'help' => 'მაქს. საუკეთესო N მნიშვნელობა სტატისტიკისთვის',
        ],
        'nfsen_top_N' => [
            'description' => 'საუკეთესო N',
        ],
        'nfsen_top_default' => [
            'description' => 'ნაგულისხმევი საუკეთესო N',
        ],
        'nfsen_stats_default' => [
            'description' => 'ნაგულისხმევი სტატისტიკა',
        ],
        'nfsen_order_default' => [
            'description' => 'ნაგულისხმევი მიმდევრობა',
        ],
        'nfsen_last_default' => [
            'description' => 'ნაგულისხმევი ბოლო',
        ],
        'nfsen_lasts' => [
            'description' => 'ნაგულისხმევი ბოლო პარამეტრები',
        ],
        'nfsen_base' => [
            'description' => 'NFSen-ის საბაზისო საქაღალდე',
            'help' => 'გამოიყენება მოწყობილობის შესაბამისი გრაფიკების მოსაძებნად',
        ],
        'nfsen_split_char' => [
            'description' => 'გამყოფი სიმბოლო',
            'help' => 'ეს მნიშვნელობა გვეუბნება, რით შევცვალოთ წერტილი `.` მოწყობილობის ჰოსტის სახელში. ჩვეულებრივ: `_`',
        ],
        'nfsen_suffix' => [
            'description' => 'ფაილის სახელის სუფიქსი',
            'help' => 'ეს ძალიან მნიშვნელოვანი ნაწილია, რადგან მოწყობილობის სახელები NfSen-ში შეზღუდულია 21 სიმბოლოზე. ეს ნიშნავს, რომ სრული დომენის სახელები მოწყობილობებისთვის შეიძლება, პრობლემატური იყოს, ჩაატიოთ. ასე რომ ეს ნაწილი ჩვეულებრივ იშლება.',
        ],
        'nmap' => [
            'description' => 'ბილიკი nmap-მდე',
        ],
        'no_proxy' => [
            'description' => 'პროქსის გამონაკლისები',
            'help' => 'დააყენეთ, თუ გარემოს ცვლადი no_proxy ხელმისაწვდომი არაა. წარმოადგენს მძიმით გამოყოფილ სიას IP მისამართების, ჰოსტების და დომენების, რომლებიც გნებავთ, გამოტოვებული იყოს.',
        ],
        'opentsdb' => [
            'enable' => [
                'description' => 'ჩართვა',
                'help' => 'მეტრიკების გატანა OpenTSDB-ში',
            ],
            'host' => [
                'description' => 'სერვერი',
                'help' => 'OpenTSDB სერვერის IP მისამართი, ან ჰოსტის სახელი მონაცემების გასაგზავნად',
            ],
            'port' => [
                'description' => 'პორტი',
                'help' => 'პორტის ნომერი OpenTSDB სერვერთან დასაკავშირებლად',
            ],
        ],
        'own_hostname' => [
            'description' => 'LibreNMS-ის ჰოსტის სახელი',
            'help' => 'უნდა დააყენოთ ჰოსტის სახელზე/IP მისამართზე, რომელზეც დამატებულია LibreNMS სერვერი',
        ],
        'oxidized' => [
            'default_group' => [
                'description' => 'აირჩიეთ ნაგულისხმევად დაბრუნებული ჯგუფი',
            ],
            'ignore_groups' => [
                'description' => 'არ დაამარქაფო ეს oxidized-ის ჯგუფები',
                'help' => 'ჯგუფები, (დაყენებული ცვლადების ასახვით) ამოღებული Oxidized-თან გაგზავნიდან',
            ],
            'enabled' => [
                'description' => 'Oxidized-ის მხარდაჭერის ჩართვა',
            ],
            'features' => [
                'versioning' => [
                    'description' => 'წვდომის ჩართვა კონფიგურაციის ვერსიებთან',
                    'help' => 'Oxidized-ის კონფიგურაციის ვერსიების ჩართვა (სჭირდება უკანაბოლო git)',
                ],
            ],
            'group_support' => [
                'description' => 'Oxidized-ში ჯგუფების დაბრუნების ჩართვა',
            ],
            'ignore_os' => [
                'description' => 'არ მოხდება ამ ოს-ების მარქაფი',
                'help' => 'არ მოხდება ჩამოთვლილი ოს-ების მარქაფი Oxidized-თ. ოს უნდა ემთხვეოდეს LibreNMS-ის ოს-ის სახელს (ეს ყველა პატარა ასოებით, ჰარეების გარეშე).  მხოლოდ დაუშვებს არსებულ ოს-ს.',
            ],
            'ignore_types' => [
                'description' => 'არ დაამარქაფო ეს მოწყობილობის ტიპები',
                'help' => 'არ მოხდება ჩამოთვლილი მოწყობიპლობების ტიპების მარქაფი Oxidized-ით. დაუშვებს, მხოლოდ, არსებულ ტიპებს.',
            ],
            'reload_nodes' => [
                'description' => 'Oxidized-ის კვანძების სიის თავიდან ჩატვირთვა ყოველ ჯერზე, როცა მოწყობილობა დაემატება.',
            ],
            'maps' => [
                'description' => 'ცვლადების ასახვა',
                'help' => 'გამოიყენება ჯგუფის, ან სხვა ცვლადების დასაყენებლად, ან ოს-ის სახელის ასასახავად, რომელიც განსხვავდება.',
            ],
            'url' => [
                'description' => 'URL თქვენი Oxidized-ის API-მდე',
                'help' => 'Oxidized-ის API-ის url (მაგალითად: http://127.0.0.1:8888)',
            ],
        ],
        'password' => [
            'min_length' => [
                'description' => 'მინიმალური პაროლის სიგრძე',
                'help' => 'ამ სიგრძეზე მოკლე პაროლები უარყოფილი იქნება',
            ],
        ],
        'peeringdb' => [
            'enabled' => [
                'description' => 'PeeringDB-ში ძებნის ჩართვა',
                'help' => 'PeeringDB-ში ძებნის ჩართვა (მონაცემებს გადმოწერს სკრიპტი daily.sh)',
            ],
        ],
        'permission' => [
            'device_group' => [
                'allow_dynamic' => [
                    'description' => 'მომხმარებლის წვდომის ჩართვა დინამიკური მოწყობილობების ჯგუფებიდან',
                ],
            ],
        ],
        'bad_if' => [
            'description' => 'არასასურველი ინტერფეისის ifDescr',
            'help' => 'ქსელური ინტერფეისის IF-MIB:!:ifDescr რომელიც გამოტოვებული უნდა იყოს',
        ],
        'bad_if_regexp' => [
            'description' => 'არასასურველი ინტერფეისის ifDescr რეგულარული გამოსახულება',
            'help' => 'ქსელური ინტერფეისის IF-MIB:!:ifDescr რომელიც გამოტოვებული უნდა იყოს რეგულარული გამოსახულების გამოყენებით',
        ],
        'bad_ifalias_regexp' => [
            'description' => 'არასასურველი ინტერფეისის ifAlias რეგულარული გამოსახულება',
            'help' => 'ქსელური ინტერფეისის IF-MIB:!:ifAlias რომელიც გამოტოვებული უნდა იყოს რეგულარული გამოსახულების გამოყენებით',
        ],
        'bad_ifname_regexp' => [
            'description' => 'არასასურველი ინტერფეისის ifName რეგულარული გამოსახულება',
            'help' => 'ქსელური ინტერფეისის IF-MIB:!:ifName რომელიც გამოტოვებული უნდა იყოს რეგულარული გამოსახულების გამოყენებით',
        ],
        'bad_ifoperstatus' => [
            'description' => 'არასასურველი ინტერფეისის ifOperStatus სტატუსი',
            'help' => 'ქსელური ინტერფეისის IF-MIB:!:ifOperStatus რომელიც გამოტოვებული უნდა იყოს',
        ],
        'bad_iftype' => [
            'description' => 'არასასურველი ინტერფეისის ifType',
            'help' => 'ქსელური ინტერფეისის IF-MIB:!:ifType რომელიც გამოტოვებული უნდა იყოს',
        ],
        'ping' => [
            'description' => 'ბილიკი ping-მდე',
        ],
        'ping_rrd_step' => [
            'description' => 'პინგის სიხშირე',
            'help' => 'რამდენად ხშირად მოხდება შემოწმება. აყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის. ფრთხილად! თუ ამას შეცვლით, საჭირო იქნება დამატებითი ცვლილებებიც.  გადახედეთ სწრაფი პინგის დოკუმენტაციას.',
        ],
        'poller_modules' => [
            'unix-agent' => [
                'description' => 'Unix-ის აგენტი',
            ],
            'os' => [
                'description' => 'ოს',
            ],
            'ipmi' => [
                'description' => 'IPMI',
            ],
            'qos' => [
                'description' => 'QoS',
            ],
            'sensors' => [
                'description' => 'სენსორები',
            ],
            'processors' => [
                'description' => 'პროცესორები',
            ],
            'mempools' => [
                'description' => 'მეხსიერება',
            ],
            'storage' => [
                'description' => 'საცავი',
            ],
            'netstats' => [
                'description' => 'ქსელის სტატისტიკა',
            ],
            'hr-mib' => [
                'description' => 'HR Mib',
            ],
            'ucd-mib' => [
                'description' => 'Ucd Mib',
            ],
            'ipSystemStats' => [
                'description' => 'ipSystemStats',
            ],
            'ports' => [
                'description' => 'პორტები',
            ],
            'bgp-peers' => [
                'description' => 'BGP პირები',
            ],
            'junose-atm-vp' => [
                'description' => 'JunOS ATM VP',
            ],
            'ucd-diskio' => [
                'description' => 'UCD DiskIO',
            ],
            'wireless' => [
                'description' => 'უსადენო',
            ],
            'ospf' => [
                'description' => 'OSPF',
            ],
            'ospfv3' => [
                'description' => 'OSPFv3',
            ],
            'isis' => [
                'description' => 'ISIS',
            ],
            'cisco-ipsec-flow-monitor' => [
                'description' => 'Cisco IPSec-ის დინების მონიტორი',
            ],
            'cisco-remote-access-monitor' => [
                'description' => 'Cisco-ის დაშორებული წვდომის მონიტორი',
            ],
            'cisco-cef' => [
                'description' => 'Cisco CEF',
            ],
            'slas' => [
                'description' => 'მომსახურების დონის შესახებ შეთანხმების თვალყურის დევნება',
            ],
            'cisco-mac-accounting' => [
                'description' => 'Cisco MAC აღრიცხვა',
            ],
            'cipsec-tunnels' => [
                'description' => 'Cipsec გვირაბები',
            ],
            'cisco-ace-loadbalancer' => [
                'description' => 'Cisco ACE დატვირთვის განმანაწილებელი',
            ],
            'cisco-ace-serverfarms' => [
                'description' => 'Cisco ACE-ის სერვერული ფერმები',
            ],
            'cisco-otv' => [
                'description' => 'Cisco OTV',
            ],
            'cisco-qfp' => [
                'description' => 'Cisco QFP',
            ],
            'cisco-vpdn' => [
                'description' => 'Cisco VPDN',
            ],
            'nac' => [
                'description' => 'NAC',
            ],
            'netscaler-vsvr' => [
                'description' => 'Netscaler VSVR',
            ],
            'aruba-controller' => [
                'description' => 'Aruba Controller',
            ],
            'availability' => [
                'description' => 'ხელმისაწვდომობა',
            ],
            'entity-physical' => [
                'description' => 'ფიზიკური ობიექტი',
            ],
            'entity-state' => [
                'description' => 'ობიექტის მდგომარეობა',
            ],
            'applications' => [
                'description' => 'აპლიკაციები',
            ],
            'stp' => [
                'description' => 'STP',
            ],
            'vminfo' => [
                'description' => 'ჰაიპერვიზორის VM ინფორმაცია',
            ],
            'ntp' => [
                'description' => 'NTP',
            ],
            'loadbalancers' => [
                'description' => 'დატვირთვის განმანაწილებლები',
            ],
            'mef' => [
                'description' => 'MEF',
            ],
            'mpls' => [
                'description' => 'MPLS',
            ],
            'xdsl' => [
                'description' => 'xDSL',
            ],
            'printer-supplies' => [
                'description' => 'პრინტერის მარაგები',
            ],
        ],
        'ports_fdb_purge' => [
            'description' => 'პორტის FDB ჩანაწერები, ძველები, ვიდრე',
            'help' => 'გასუფთავებას ახდენს სკრიპტი daily.sh',
        ],
        'ports_nac_purge' => [
            'description' => 'პორტის NAC ჩანაწერები, ძველები, ვიდრე',
            'help' => 'გასუფთავებას ახდენს სკრიპტი daily.sh',
        ],
        'ports_purge' => [
            'description' => 'წაშლილი პორტების გასუფთავება',
            'help' => 'გასუფთავებას ახდენს სკრიპტი daily.sh',
        ],
        'prometheus' => [
            'enable' => [
                'description' => 'ჩართვა',
                'help' => 'გაიტანს მეტრიკებს Prometheus Push Gateway-ში',
            ],
            'url' => [
                'description' => 'URL',
                'help' => 'Prometheus Push Gateway-ის URL მონაცემების გასაგზავნად',
            ],
            'Job' => [
                'description' => 'დავალება',
                'help' => 'დავალების ჭდე გატანილი მეტრიკებისთვის',
            ],
            'attach_sysname' => [
                'description' => 'მოწყობილობის sysName-ის მიმაგრება',
                'help' => 'sysName-ის ინფორმაციის მიმაგრება Prometheus-სთვის.',
            ],
            'prefix' => [
                'description' => 'პრეფიქსი',
                'help' => 'არასავალდებულო ტექსტი გატანილი მეტრიკის სახელებისთვის თავში მისაწერად',
            ],
        ],
        'public_status' => [
            'description' => 'სტატუსის საჯაროდ ჩვენება',
            'help' => 'აჩენებს ზოგიერთი მოწყობილობის სტატუსს შესვლის გვერდზე ავთენტიკაციის გარეშე.',
        ],
        'routes_max_number' => [
            'description' => 'აღმოჩენისთვის დაშვებული რაუტების მაქს. რაოდენობა',
            'help' => 'რაუტები აღმოჩენილი არ იქნება,, თუ რაუტინგის ცხრილის ზომა ამ რიცხვზე დიდია',
        ],
        'default_port_group' => [
            'description' => 'ნაგულისხმევი პორტების ჯგუფი',
            'help' => 'ახალი აღმოჩნეილი პორტები ამ პორტების ჯგუფს მიენიჭება.',
        ],
        'nets' => [
            'description' => 'ქსელების ავტოაღმოჩენა',
            'help' => 'რომელი მოწყობილობებიდან იქნება ქსელები ავტომატურად აღმოჩენილი.',
        ],
        'autodiscovery' => [
            'bgp' => [
                'description' => 'BGP მეზობლის აღმოჩენის ჩართვა',
                'help' => 'ბმულებისა და მეზობლების დამატება BPG პირებზე დაყრდნობით',
            ],
            'cdp_exclude' => [
                'platform_regexp' => [
                    'description' => 'CDP-დან პლატფორმის ამოღების რეგულარული გამოსახულება',
                    'help' => 'მოწყობილობების CDP-ის მიერ დამატების თავიდან აცილება, თუ sysName ამ რეგულარულ გამოსახულებას აკმაყოფილებს',
                ],
            ],
            'nets-exclude' => [
                'description' => 'გამოსატოვებელი IP-ები/ქსელები',
                'help' => 'ქსელები/IP-ები, რომლების აღმოჩენაც ავტომატურად არ მოხდება. ასევე გამოტოვებს IP-ებს ავტოაღმოჩენის ქსელებიდან',
            ],
            'ospf' => [
                'description' => 'OSPF-ის მეზობლის აღმოჩენის ჩართვა',
                'help' => 'ბმულების და მეზობლების დამატება OSPF პირებზე დამოკიდებულებით',
            ],
            'ospfv3' => [
                'description' => 'OSPFv3-ის მეზობლის აღმოჩენის ჩართვა',
                'help' => 'ბმულების და მეზობლების დამატება OSPFv3 პირებზე დამოკიდებულებით',
            ],
            'xdp' => [
                'description' => 'xDP აღმოჩენის პროტოკოლების ჩართვა',
                'help' => 'LLDP, CDP და სხვა პროტოკოლების გამოყენება ქსელის ტოპოლოგიის და მეზობლების აღმოსაჩენად და მათი LibreNMS-ში დასამატებლად',
            ],
            'xdp_exclude' => [
                'sysname_regexp' => [
                    'description' => 'xDP-დან ამოსაღები sysName-ის რეგგამოსი',
                    'help' => 'მოწყობილობის დამატების თავიდან აცილება, თუ sysName აკმაყოფილებს რეგულარულ გამოსახულებას',
                ],
                'sysdesc_regexp' => [
                    'description' => 'xDP-დან ამოსაღები sysDescr-ის რეგგამოსი',
                    'help' => 'მოწყობილობის დამატების თავიდან აცილება, თუ sysDescr აკმაყოფილებს რეგულარულ გამოსახულებას',
                ],
            ],
        ],
        'radius' => [
            'default_roles' => [
                'description' => 'ნაგულისხმევი მომხმარებლის როლები',
                'help' => 'დააყენებს როლებს, რომლებიც მიენიჭება მომხმარებელს იმ შემთხვევის გარდა, თუ Radius გამოაგზავნის ატრიბუტებს, რომლებიც როლებს შეიცავს',
            ],
            'enforce_roles' => [
                'description' => 'ნაძალადევი როლები შესვლისას',
                'help' => 'თუ ჩართულია, როლები მიენიჭება მათ, ვისაც შესვლისას აქვს ჩართული ატრიბუტები Filter-ID ან radius.default_roles.  სხვა შემთხვევაში ისინი დაყენებული იქნება მოხმარებლის შექმნისას და არასდროს მის შემდეგ.',
            ],
        ],
        'reporting' => [
            'error' => [
                'description' => 'შეცდომის ანგარიშების გაგზავნა',
                'help' => 'ზოგიერთი შეცდომის გაგზავნა LibreNMS-სთვის ანალიზისა და გასწორებისთვის',
            ],
            'usage' => [
                'description' => 'გამოყენების ანგარიშების გაგზავნა',
                'help' => 'გამოყენების და ვერსიების გაგზავნა LibreNMS-სთვის. ანონიმური სტატისტიკის წასაშლელად ეწვიეთ გვერდს "შესახებ". სტატისტიკის ნახვა შეგიძლიათ მისამართზე https://stats.librenms.org',
            ],
            'dump_errors' => [
                'description' => 'გამართვის შეცდომების ჩამოყრა (შეუძლია პროგრამის თქვენი ვერსიის გაფუჭება)',
                'help' => 'ჩამოყრის შეცდომებს, რომლებიც ჩვეულებრივ დამალულია, რომ თქვენ, როგორც პროგრამისტმა, შეძლოთ და იპოვოთ შესაძლო პრობლემები.',
            ],
            'throttle' => [
                'description' => 'შეცდომის ანგარიშების შეზღუდვა',
                'help' => 'ანგარიშების გაგზავნა, მხოლოდ, ყოველ მითითებული რაოდენობის წამის შემდეგ მოხდება. ამის გარეშე, თუ გაქვთ შეცდომა საერთო კოდში, ანგარიშების გაგზავნა, შეიძლება, ხელიდან წავიდეს. 0 გამორთავს შეზღუდვას.',
            ],
        ],
        'route_purge' => [
            'description' => 'რაუტების ჩანაწერები, რომლებიც ძველია, ვიდრე',
            'help' => 'გასუფთავებას ახდენს სკრიპტი daily.sh',
        ],
        'rrd' => [
            'heartbeat' => [
                'description' => 'rrd-ის გულისცემის მნიშვნელობის შეცვლა (ნაგულისხმევი 600)',
            ],
            'step' => [
                'description' => 'rrd-ის ნაბიჯის მნიშვნელობის შეცვლა (ნაგულისხმევი 300)',
            ],
        ],
        'rrd_dir' => [
            'description' => 'RRD-ის მდებარეობა',
            'help' => 'rrd ფაილების მდებარეობა.  ნაგულისხმევია rrd LibreNMS-ის საქაღალდის შიგნით. ამ პარამეტრის ცვლილება rrd ფაილებს არ გადაიტანს.',
        ],
        'rrd_purge' => [
            'description' => 'RRD ფაილის ჩანაწერები, რომლებიც ძველია, ვიდრე',
            'help' => 'გასუფთავებას ახდენს სკრიპტი daily.sh',
        ],
        'rrd_rra' => [
            'description' => 'RRD-ის ფორმატის მორგება',
            'help' => 'ამას ვერ შეცვლით თქვენი არსებული RRD ფაილების წაშლის გარეშე. მართალია, შესაძლებელია, თითოეული RRA-ის ზომის გაზრდა ან შემცირება, თუ გაქვთ წარმადობის პრობლემები, ან თუ გაქვთ ძალიან მაღალი შეტანა/გამოტანის მქონე სისტემა და არ ნაღვლობთ წარმადობაზე.',
        ],
        'rrdcached' => [
            'description' => 'rrdcached-ის ჩართვა (სოკეტი)',
            'help' => 'ჩართავს rrdcached-ს rrdcached-ის სოკეტის მდებარეობის დაყენებით. შეიძლება იყოს unix ან ქსელის სოკეტი (unix:/run/rrdcached.sock ან localhost:42217)',
        ],
        'rrdtool' => [
            'description' => 'ბილიკი rrdtool-მდე',
        ],
        'rrdtool_tune' => [
            'description' => 'ყველა rrd პორტის ფაილისთვის მაქს. მნიშვნელობების მორგება',
            'help' => 'rrd პორტის ფაილებისთვის მაქსიმალური მნიშვნელობის ავტომორგება',
        ],
        'rrdtool_version' => [
            'description' => 'აყენებს rrdtool-ის ვერსიას თქვენს სერვერზე',
            'help' => 'ყველაფერს, რაც 1.5.5-ზე ახალია, აქვს ყველა ის ფუნქცია, რასაც LibreNMS იყენებთ, ნუ დააყენებთ სისტემაში არსებულ ვერსიაზე უფრო მაღალზე',
        ],
        'schedule_type' => [
            'alerting' => [
                'description' => 'განგაშები',
                'help' => 'განგაშების ამოცანის დაგეგმვის მეთოდი. მოძველებული გამოიყენებს cron-ს, თუ crontab-ის ჩანაწერი არსებობს დადისპეჩერის სერვისს, თუ მოძველებული კონფიგურაციის პარამეტრი service_billing_enabled ჭეშმარიტზეა დაყენებული.',
                'options' => [
                    'legacy' => 'მოძველებული (შეუზღუდავი)',
                    'cron' => 'Cron (alerts.php)',
                    'dispatcher' => 'დისპეჩერის სერვისი',
                ],
            ],
            'billing' => [
                'description' => 'ბილინგი',
                'help' => 'ბილინგის ამოცანის დაგეგმვის მეთოდი. მოძველებული გამოიყენებს cron-ს, თუ crontab-ის ჩანაწერი არსებობს დადისპეჩერის სერვისს, თუ მოძველებული კონფიგურაციის პარამეტრი service_billing_enabled ჭეშმარიტზეა დაყენებული.',
                'options' => [
                    'legacy' => 'მოძველებული (შეუზღუდავი)',
                    'cron' => 'Cron (poll-billing.php and billing-calculate.php)',
                    'dispatcher' => 'დისპეჩერის სერვისი',
                ],
            ],
            'discovery' => [
                'description' => 'აღმოჩენა',
                'help' => 'აღმოჩენის ამოცანის დაგეგმვის მეთოდი. მოძველებული გამოიყენებს cron-ს, თუ crontab-ის ჩანაწერი არსებობს დადისპეჩერის სერვისს, თუ მოძველებული კონფიგურაციის პარამეტრი service_billing_enabled ჭეშმარიტზეა დაყენებული.',
                'options' => [
                    'legacy' => 'მოძველებული (შეუზღუდავი)',
                    'cron' => 'Cron (discovery.php)',
                    'dispatcher' => 'დისპეჩერის სერვისი',
                ],
            ],
            'ping' => [
                'description' => 'სწრაფი პინგი',
                'help' => 'სწრაფი პინგის ამოცანის დაგეგმვის მეთოდი. მოძველებული გამოიყენებს cron-ს, თუ crontab-ის ჩანაწერი არსებობს დადისპეჩერის სერვისს, თუ მოძველებული კონფიგურაციის პარამეტრი service_billing_enabled ჭეშმარიტზეა დაყენებული.',
                'options' => [
                    'legacy' => 'მოძველებული (შეუზღუდავი)',
                    'disabled' => 'Disabled (pings only during polling)',
                    'cron' => 'Cron (ping.php)',
                    'dispatcher' => 'დისპეჩერის სერვისი',
                ],
            ],
            'poller' => [
                'description' => 'გამომთხოვი',
                'help' => 'გამომთხოვის ამოცანის დაგეგმვის მეთოდი. მოძველებული გამოიყენებს cron-ს, თუ crontab-ის ჩანაწერი არსებობს დადისპეჩერის სერვისს, თუ მოძველებული კონფიგურაციის პარამეტრი service_billing_enabled ჭეშმარიტზეა დაყენებული.',
                'options' => [
                    'legacy' => 'მოძველებული (შეუზღუდავი)',
                    'cron' => 'Cron (poller.php)',
                    'dispatcher' => 'დისპეჩერის სერვისი',
                ],
            ],
            'services' => [
                'description' => 'სერვისები',
                'help' => 'სერვისების ამოცანის დაგეგმვის მეთოდი. მოძველებული გამოიყენებს cron-ს, თუ crontab-ის ჩანაწერი არსებობს დადისპეჩერის სერვისს, თუ მოძველებული კონფიგურაციის პარამეტრი service_billing_enabled ჭეშმარიტზეა დაყენებული.',
                'options' => [
                    'legacy' => 'მოძველებული (შეუზღუდავი)',
                    'cron' => 'Cron (check-services.php)',
                    'dispatcher' => 'დისპეჩერის სერვისი',
                ],
            ],
        ],
        'service_master_timeout' => [
            'description' => 'მთავარი დისპეჩერის მოლოდინის ვადა',
            'help' => 'დროის რაოდენობა, სანამ მთავარი ბლოკის ვადა ამოიწურება. თუ მთავარი აღარ იარსებებს, მეორე კვანძს ამდენი დრო დასჭირდება, რომ სამუშაო თავის თავზე აიღოს.  მაგრამ, თუ სამუშაოს გაშვებას მეტი დრო სჭირდება, შეიძლება, ერთზე მეტი მთავარი დისპეჩერი აღმოგაჩნდეთ',
        ],
        'service_poller_workers' => [
            'description' => 'გამოთხოვნის დამხმარე პროცესები',
            'help' => 'გასაშვები გამომთხოვი დამხმარე პროცესების რაოდენობა. დააყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_poller_frequency' => [
            'description' => 'გამომთხოვის სიხშირე (ფრთხილად!)',
            'help' => 'რამდენად ხშირად მოხდება მონაცემების გამოთხოვა მოწყობილობებიდან. დააყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის. ფრთხილად! ამის შეცვლა rrd ფაილების გასწორების გარეშე გრაფიკებს გააფუჭებს. მეტი ინფორმაციისთვის იხილეთ დოკუმენტაცია.',
        ],
        'service_poller_down_retry' => [
            'description' => 'თავიდან ცდების რაოდენობა, როცა მოწყობილობა არ პასუხობს',
            'help' => 'თუ მოწყობილობა გამორთულია, როცა მოხდება გამოთხოვის მცდელობა, ეს ის დროის რაოდემობაა რომელსაც თავიდან ცდამდე მოვიცდით. დააყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_discovery_workers' => [
            'description' => 'აღმოჩენის დამხმარე პროცესები',
            'help' => 'აღმოჩენის დამხმარე პროცესების რაოდენობა გასაშვებად. მეტისმეტად დიდი მნიშვნელობას სერვერის მეტისმეტი დატვირთვა შეუძლია. აყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_discovery_frequency' => [
            'description' => 'აღმოჩენის სიხშირე',
            'help' => 'რამდენად ხშირად უნდა გაეშვას მოწყობილობების აღმოჩენა. დააყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის. ნაგულსიხმევია 4-ჯერ დღეში.',
        ],
        'service_services_workers' => [
            'description' => 'სერვისის დამხმარე პროცესები',
            'help' => 'სერვისების დამხმარე პროცესების რაოდენობა. დააყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_services_frequency' => [
            'description' => 'სერვისების სიხშირე',
            'help' => 'რამდენად ხშირად გაეშვება სერვისები. ეს უნდა ემთხევოდეს გამომთხოვის სიხშირეს. აყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_billing_frequency' => [
            'description' => 'ბილინგის სიხშირე',
            'help' => 'რამდენად ხშირად მოხდება ბილინგის მონაცემების მოგროვება. აყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_billing_calculate_frequency' => [
            'description' => 'ბილინგის გამოთვლის სიხშირე',
            'help' => 'რამდენად ხშირად მოხდება გადასახდელი ანგარიშის გამოთვლა. აყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_alerting_frequency' => [
            'description' => 'განგაშების სიხშირე',
            'help' => 'რამდენად ხშირად შემოწმდება განგაშის წესები. დაიამხსოვრეთ, რომ მონაცემები, მხოლოდ, გამომთხოვის სიხშირის მიხედვით განახლდება. აყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_update_enabled' => [
            'description' => 'დღიური რემონტი ჩართულია',
            'help' => 'daily.sh რემონტის სკრიპტის გაშვება და შემდეგ დისპეჩერის სერვისის გადარტვირთვა. აყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_update_frequency' => [
            'description' => 'რემონტის სიხშირე',
            'help' => 'რამდენად ხშირად გაეშვება ყოველდღიური რემონტი. ნაგულისხმევი მნიშვნელობაა 1 დღე. მკაცრად გირჩევთ, ეს არ შეცვალოთ. აყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_loglevel' => [
            'description' => 'ჟურნალის დონე',
            'help' => 'ჟურნალის დონე დდისპეჩერის სერვისისთვის. აყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_watchdog_enabled' => [
            'description' => 'საკონტროლო ტაიმერი ჩართულია',
            'help' => 'საკონტროლო ტაიმერი თვალყურს ადევნებს ჟურნალის ფაილს და გადატვირთავს სერვისს, თუ ის არ განახლდება. აყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_watchdog_log' => [
            'description' => 'საკონტროლო ჟურნალის ფაილი',
            'help' => 'ნაგულისხმევი მნიშვნელობაა LibreNMS-ის ჟურნალის ფაილი. აყენებს ნაგულისხმევ მნიშვნელობას ყველა კვანძისთვის.',
        ],
        'service_health_file' => [
            'description' => 'სერვისის ჯანმრთელობის ფაილი',
            'help' => 'ბილიკი ჯანმრთელობის ფაილამდე, რომ დავრწმუნდეთ, რომ დისპეჩერის სერვისი გაშვებულია',
        ],
        'sfdp' => [
            'description' => 'ბილიკი sfdp-მდე',
        ],
        'shorthost_target_length' => [
            'description' => 'შემოკლებული ჰოსტის სახელის მაქსიმალური სიგრძე',
            'help' => 'შეამოკლებს ჰოსტის სახელს მაქსიმალურ სიგრძემდე, მაგრამ ყოველთვის სრული ქვედომენის ნაწილებით',
        ],
        'site_style' => [
            'description' => 'ნაგულისხმევი თემა',
            'options' => [
                'blue' => 'ლურჯი',
                'dark' => 'მუქი',
                'light' => 'ღია',
                'mono' => 'მონო',
            ],
        ],
        'snmp' => [
            'transports' => [
                'description' => 'ტრანსპორტი (პრიორიტეტი)',
                'help' => 'აირჩიეთ ჩართული ტრანსპორტები და დაალაგეთ ისინი, როგორც გნებავთ, რომ მათი ცდა მოხდეს.',
            ],
            'version' => [
                'description' => 'ვერსია (პრიორიტეტი)',
                'help' => 'აირჩიეთ ჩართული ვერსიები და დაალაგეთ ისინი, როგორც გნებავთ, რომ მათი ცდა მოხდეს.',
            ],
            'community' => [
                'description' => 'საზოგადოებები (პრიორიტეტი)',
                'help' => 'შეიყვანეთ საზოგადოების სტრიქონები v1 და v2c ვერსიებისთვის და დაალაგეთ ისინი იმ მიმდევრობით, რომლითაც გნებავთ, მათი ცდა მოხდეს',
            ],
            'max_oid' => [
                'description' => 'მაქს OID-ენი',
                'help' => 'მაქს. OID-ები თითოეულ მოთხოვნაში. გადაფარვა შესაძლებელია ოს-ის და მოწყობილობის დონეზე.',
            ],
            'max_repeaters' => [
                'description' => 'მაქს. გამმეორებლები',
                'help' => 'დააყენეთ გამმეორებლები, რომლებიც SNMP-ის bulk მოთხოვნებში გამოსაყენებლად',
            ],
            'oids' => [
                'no_bulk' => [
                    'description' => 'snmp bulk-ის გამორთვა OID-ებისთვის',
                    'help' => 'snmp bulk ოპერაციის გამორთვა ზოგიერთი OID-ებისთვის. ზოგადად, ეს ოს-ზე უნდა დააყენოთ. ფორმატი უნდა იყოს MIB::OID',
                ],
                'unordered' => [
                    'description' => 'არეული snmp-ის პასუხების დაშვება OID-ებისთვის',
                    'help' => 'დაულაგებელი OID-ების გამოტოვება snmp-ის პასუხებში ზოგიერთი OID-ებისთვის. არეულმა OID-ებმა, შეიძლება, გამოიწვიონ oid-ის მარყუჟი snmpwalk-ის დროს. ზოგადად, ეს ოს-ში უნდა დააყენოთ. ფორმატი უნდა იყოს MIB::OID',
                ],
            ],
            'port' => [
                'description' => 'პორტი',
                'help' => 'დააყენეთ tcp/udp პორტი SNMP-სთვის',
            ],
            'timeout' => [
                'description' => 'მოლოდინის ვადა',
                'help' => 'SNMP-ის მოლოდინის ვადა წამებში',
            ],
            'retries' => [
                'description' => 'თავიდან ცდები',
                'help' => 'რამდენჯერ ვცადო თავიდან მოთხოვნა',
            ],
            'v3' => [
                'description' => 'SNMP v3 ავთენტიკაცია (პრიორიტეტი)',
                'help' => 'დააყენეთ v3 ავთენტიკაციის ცვლადები და დაალაგეთ ისინი ისე, როგორც გნებავთ, რომ ვცადოთ',
                'auth' => 'ავთენტიკაცია',
                'crypto' => 'კრიპტო',
                'fields' => [
                    'authalgo' => 'ალგორითმი',
                    'authlevel' => 'დონე',
                    'authname' => 'მომხმარებლის სახელი',
                    'authpass' => 'პაროლი',
                    'cryptoalgo' => 'ალგორითმი',
                    'cryptopass' => 'პაროლი',
                ],
                'level' => [
                    'noAuthNoPriv' => 'ავთენტიკაციის გარეშე, კონფიდენციალობის გარეშე',
                    'authNoPriv' => 'ავთენტიკაცია, კონფიდენციალობის გარეშე',
                    'authPriv' => 'ავთენტიკაცია და კონფიდენციალობა',
                ],
            ],
        ],
        'snmpbulkwalk' => [
            'description' => 'ბილიკი snmpbulkwalk-მდე',
        ],
        'snmpget' => [
            'description' => 'ბილიკი snmpget',
        ],
        'snmpgetnext' => [
            'description' => 'ბილიკი snmpgetnext-მდე',
        ],
        'snmptranslate' => [
            'description' => 'ბილიკი snmptranslate-მდე',
        ],
        'snmptraps' => [
            'eventlog' => [
                'description' => 'მოვლენების ჟურნალის შექმნა SNMPtraps-სთვის',
                'help' => 'დამოუკიდებლად ქმედებისგან, რომელიც შეიძლება დაკავშირებული იყოს ამ ხაფანგთან',
            ],
            'eventlog_detailed' => [
                'description' => 'დეტალური ჟურნალის ჩართვა',
                'help' => 'ხაფანგით მიღებული ყველა OID-ის ჩაწერა მოვლენების ჟურნალში',
            ],
        ],
        'snmpwalk' => [
            'description' => 'ბილიკი snmpwalk-მდე',
        ],
        'syslog_filter' => [
            'description' => 'syslog-ის შეტყობინებების გაფილტვრა. შეიცავს',
        ],
        'syslog_purge' => [
            'description' => 'Syslog-ის ჩანაწერები, ძველი, ვიდრე',
            'help' => 'გასუფთავებას ახდენს სკრიპტი daily.sh',
        ],
        'title_image' => [
            'description' => 'სათაურის გამოსახულება',
            'help' => 'გადაფარავს ნაგულისხმევ სათაურის გამოსახულებას.',
        ],
        'traceroute' => [
            'description' => 'ბილიკი traceroute-მდე',
        ],
        'twofactor' => [
            'description' => '2FA',
            'help' => 'მომხმარებლებისთვის უფლების დართვა, გაააქტიურონ და ჩართონ დროზე დამოკიდებული (TOTP), ან მთვლელზე დამოკიდებული ერთჯერადი პაროლები (OTP)',
        ],
        'twofactor_lock' => [
            'description' => '2FA-ის შეზღუდვის დრო (წამებში)',
            'help' => 'დაბლოკვის მოლოდინის დრო წამებში, სანამ შემდეგი მცდელობა შესაძლებელი იქნება, თუ 2FA ზედიზედ სამჯერ ჩავარდება - მომხმარებელს ვთხოვთ, რომ ამ დროით დაგველოდოს.  დააყენეთ 0-ზე, რომ დაბლოკვა სინამდვილეში სამუდამო იყოს და ადმინისტრატორს შეტყობინება გაეგზავნოს',
        ],
        'unix-agent' => [
            'connection-timeout' => [
                'description' => 'Unix-ის აგენტთან დაკავშირების ვადა',
            ],
            'port' => [
                'description' => 'ნაგულისხმევი unix-აგენტის პორტი',
                'help' => 'ნაგულისხმევი პორტი unix-აგენტისთვის (check_mk)',
            ],
            'read-timeout' => [
                'description' => 'Unix-აგენტიდან წაკთხვის მოლოდინის ვადა ამოიწურა',
            ],
        ],
        'update' => [
            'description' => './daily.sh-ში განახლებების ჩართვა',
        ],
        'update_channel' => [
            'description' => 'განახლების არხი',
            'options' => [
                'master' => 'დღიური',
                'release' => 'თვიური',
            ],
        ],
        'uptime_warning' => [
            'description' => 'მოწყობილობის ჩვენება, როგორც გასაფრთხილებლის, თუ ჩართულობის დრო ნაკლებია, ვიდრე .. (წამებში)',
            'help' => 'აცვენებს მოწყობილობას, როგორც გასაფრთხილებელს, თუ ჩართულობის დრო ამ მნიშვნელობაზე დაბალია. მორგებული რუკების სტატუსი გაჩვენებთ ამ პარამეტრს. 0 გამორთავს გაფრთხილებას.ნაგულისხმევია 24სთ',
        ],
        'virsh' => [
            'description' => 'ბილიკი virsh-მდე',
        ],
        'webui' => [
            'availability_map_box_size' => [
                'description' => 'ხელმისაწვდომობის დიალოგის სიგანე',
                'help' => 'შეიყვანეთ სასურველი ფილის სიგანე პიქსელებში დიალოგის ზომისთვის სრულ ხედში',
            ],
            'availability_map_compact' => [
                'description' => 'ხელმისაწვდომის რუკის კომპაქტური ხედი',
                'help' => 'ხელმისაწვდომობის რუკის ხედი პატარა მაჩვენებლებით',
            ],
            'availability_map_sort_status' => [
                'description' => 'სტატუსით დალაგება',
                'help' => 'მოწყობილობებისა და სერვისების დალაგება სტატუსით',
            ],
            'availability_map_use_device_groups' => [
                'description' => 'მოწყობილობის ჯგუფების ფილტრის გამოყენება',
                'help' => 'ჩართავს მოწყობილობის ჯგუფების ფილტრის გამოყენებას',
            ],
            'default_dashboard_id' => [
                'description' => 'ნაგულისხმევი სამუშაო დაფა',
                'help' => 'გლობალური ნაგულისხმევი dashboard_id ყველა მომხმარებლისთვის, რომლებსაც საკუთარი არ აქვს დაყენებული',
            ],
            'dynamic_graphs' => [
                'description' => 'დინამიკური გრაფიკების ჩართვა',
                'help' => 'ჩართავს დინამიკურ გრაფიკებს და გრაფიკების დამასშტაბებას და პანორამირებას',
            ],
            'global_search_result_limit' => [
                'description' => 'დააყენეთ მაქს. ძებნის შედეგების ლიმიტზე',
                'help' => 'გლობალური ძებნის შედეგების ლიმიტი',
            ],
            'graph_stacked' => [
                'description' => 'ანაწყობი გრაფიკების გამოყენება',
                'help' => 'ანაწყობი გრაფიკების ჩვენება შებრუნებულების მაგიერ',
            ],
            'graph_type' => [
                'description' => 'გრაფიკის ტიპის დაყენება',
                'help' => 'დააყენეთ ნაგულისხმევი გრაფიკის ტიპი',
                'options' => [
                    'png' => 'PNG',
                    'svg' => 'SVG',
                ],
            ],
            'min_graph_height' => [
                'description' => 'მინიმალური გრაფიკის სიმაღლის დაყენება',
                'help' => 'მინიმალური გრაფიკის სიმაღლე (ნაგულისხმევი: 300)',
            ],
            'graph_stat_percentile_disable' => [
                'description' => 'სტატისტიკის გრაფიკებისთვის პროცენტულობის გლობალურად გამორთვა',
                'help' => 'გამორთავს პროცენტული მნიშვნელობებისა და ხაზების ჩვენება გრაფიკებისთვის, რომლებსაც ესენი გააჩნია',
            ],
        ],
        'device_display_default' => [
            'description' => 'ნაგულისხმევი მოწყობილობის საჩვენებელი სახელის შაბლონი',
            'help' => 'აყენებს ნაგულისხმევ საჩვენებელ სახელს ყველა მოწყობილობისთვის (შეიძლება, გადაფარული იქნას თითოეული მოწყობილობისთვის).  ჰოსტის სახელი/IP: უბრალოდ ნაჩვენები იქნება ჰოსტის სახელი, ან IP, რომლითაც მოწყობილობა დაემატა. sysName: ნაჩვენები იქნება sysName snmp-დან. ჰოსტის სახელი ან sysName: ჰოსტის სახელის ჩვენება, მაგრამ თუ ის IP მისამართია, ნაჩვენები იქნება sysName.',
            'options' => [
                'hostname' => 'ჰოსტის სახელი / IP',
                'sysName_fallback' => 'ჰოსტის სახელი, გადართვა sysName-ზე IP-ებისთვის',
                'sysName' => 'sysName',
                'ip' => 'IP (ჰოსტის სახელიდან IP ან ამოხსნილი)',
            ],
        ],
        'device_location_map_open' => [
            'description' => 'მდებარეობის რუკა ღიაა',
            'help' => 'მდებარეობის რუკა ნაგულისხმევად ნაჩვენებია',
        ],
        'device_location_map_show_devices' => [
            'description' => 'მოწყობილობების ჩვენება მდებარეობების რუკაზე',
            'help' => 'ყველა მოწყობილობის ჩვენება მდებარეობის რუკაზე, როცა ის ხილულია',
        ],
        'device_location_map_show_device_dependencies' => [
            'description' => 'მოწყობილობის დამოკიდებულებების ჩვენება მდებარეობის რუკაზე',
            'help' => 'მოწყობილობებს შორის ბმულების ჩვენება მდებარეობის რუკაზე მშობელი დამოკიდებულებების მიხედვით',
        ],
        'whois' => [
            'description' => 'ბილიკი პროგრამამდე whois',
        ],
        'smokeping.integration' => [
            'description' => 'ჩართვა',
            'help' => 'smokeping-ის ინტეგრაციის ჩართვა',
        ],
        'smokeping.dir' => [
            'description' => 'ბილიკი rrd ფაილებამდე',
            'help' => 'სრული ბილიკი Smokeping-ის RRD-აბამდე',
        ],
        'smokeping.pings' => [
            'description' => 'პინგები',
            'help' => 'Smokeping-ში მორგებული პინგების რაოდენობა',
        ],
        'smokeping.url' => [
            'description' => 'smokeping-ის URL',
            'help' => 'სრული URL smokeping-ის ინტერფეისამდე',
        ],
    ],
    'twofactor' => [
        'description' => '2FA-ის ჩართვა',
        'help' => 'ჩართავს ჩაშენებულ ორფაქტორიან ავთენტიკაციას. მის გასააქტიურებლად თითოეული ანგარიში ცალ-ცალკე უნდა მოირგოთ.',
    ],
    'units' => [
        'days' => 'დღე',
        'ms' => 'მწმ',
        'seconds' => 'წამი',
    ],
    'validate' => [
        'boolean' => ':value არასწორი ლოგიკური მნიშვნელობაა',
        'color' => ':value არასწორი თექვსმეტობითი ფერის კოდი',
        'email' => ':value არასწორი ელფოსტაა',
        'float' => ':value არასწორი მცურავმძიმიანი რიცხვია',
        'integer' => ':value არასწორი მთელი რიცხვია',
        'password' => 'პაროლი არასწორია',
        'select' => ':value დაუშვებელი მნიშვნელობაა',
        'text' => ':value დაუშვებელია',
        'array' => 'არასწორი ფორმატი',
        'executable' => ':value არასწორი გამშვები ფაილია',
        'directory' => ':value არასწორი საქაღალდეა',
    ],
];
