/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instrumentation.api.types;

import java.util.EnumSet;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorType;
import org.gradle.internal.instrumentation.api.types.FilterableBytecodeInterceptor;
import org.gradle.internal.instrumentation.api.types.FilterableBytecodeInterceptorFactory;

public enum BytecodeInterceptorFilter {
    INSTRUMENTATION_ONLY(EnumSet.of(BytecodeInterceptorType.INSTRUMENTATION)),
    INSTRUMENTATION_AND_BYTECODE_REPORT(EnumSet.of(BytecodeInterceptorType.INSTRUMENTATION, BytecodeInterceptorType.BYTECODE_UPGRADE_REPORT)),
    INSTRUMENTATION_AND_BYTECODE_UPGRADE(EnumSet.of(BytecodeInterceptorType.INSTRUMENTATION, BytecodeInterceptorType.BYTECODE_UPGRADE)),
    ALL(EnumSet.of(BytecodeInterceptorType.INSTRUMENTATION, BytecodeInterceptorType.BYTECODE_UPGRADE_REPORT, BytecodeInterceptorType.BYTECODE_UPGRADE));

    private final EnumSet<BytecodeInterceptorType> instrumentationTypes;

    private BytecodeInterceptorFilter(EnumSet<BytecodeInterceptorType> instrumentationTypes) {
        this.instrumentationTypes = instrumentationTypes;
    }

    public boolean matches(FilterableBytecodeInterceptor bytecodeInterceptor) {
        return this.instrumentationTypes.contains((Object)bytecodeInterceptor.getType());
    }

    public boolean matches(FilterableBytecodeInterceptorFactory bytecodeInterceptorFactory) {
        return this.instrumentationTypes.contains((Object)bytecodeInterceptorFactory.getType());
    }
}

