/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationDetails;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationType;
import org.gradle.internal.execution.WorkExecutionTracker;
import org.gradle.internal.operations.BuildOperationAncestryTracker;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.operations.UncategorizedBuildOperations;

public class DefaultWorkExecutionTracker
implements WorkExecutionTracker,
Closeable {
    private final BuildOperationAncestryTracker buildOperationAncestryTracker;
    private final BuildOperationListenerManager buildOperationListenerManager;
    private final CurrentBuildOperationRef currentBuildOperationRef = CurrentBuildOperationRef.instance();
    private final OperationListener operationListener = new OperationListener();

    public DefaultWorkExecutionTracker(BuildOperationAncestryTracker buildOperationAncestryTracker, BuildOperationListenerManager buildOperationListenerManager) {
        this.buildOperationAncestryTracker = buildOperationAncestryTracker;
        this.buildOperationListenerManager = buildOperationListenerManager;
        buildOperationListenerManager.addListener((BuildOperationListener)this.operationListener);
    }

    @Override
    public Optional<TaskInternal> getCurrentTask() {
        return this.buildOperationAncestryTracker.findClosestExistingAncestor(this.currentBuildOperationRef.getId(), this.operationListener.runningTasks::get);
    }

    @Override
    public Optional<TaskInternal> getCurrentTask(OperationIdentifier id) {
        return this.buildOperationAncestryTracker.findClosestExistingAncestor(id, this.operationListener.runningTasks::get);
    }

    @Override
    public boolean isExecutingTransformAction() {
        return this.buildOperationAncestryTracker.findClosestMatchingAncestor(this.currentBuildOperationRef.getId(), this.operationListener.runningTransformActions::contains).isPresent();
    }

    @Override
    public void close() throws IOException {
        this.buildOperationListenerManager.removeListener((BuildOperationListener)this.operationListener);
        assert (!this.operationListener.hasRunningWork());
    }

    private static class OperationListener
    implements BuildOperationListener {
        final Map<OperationIdentifier, TaskInternal> runningTasks = new ConcurrentHashMap<OperationIdentifier, TaskInternal>();
        final Set<OperationIdentifier> runningTransformActions = ConcurrentHashMap.newKeySet();

        private OperationListener() {
        }

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            if (OperationListener.isTransformAction(buildOperation)) {
                this.runningTransformActions.add(this.mandatoryIdOf(buildOperation));
            } else {
                Object details = buildOperation.getDetails();
                if (details instanceof ExecuteTaskBuildOperationDetails) {
                    this.runningTasks.put(this.mandatoryIdOf(buildOperation), ((ExecuteTaskBuildOperationDetails)details).getTask());
                }
            }
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            if (OperationListener.isTransformAction(buildOperation)) {
                this.runningTransformActions.remove(this.mandatoryIdOf(buildOperation));
            } else {
                TaskInternal removed;
                Object details = buildOperation.getDetails();
                if (details instanceof ExecuteTaskBuildOperationType.Details && (removed = this.runningTasks.remove(this.mandatoryIdOf(buildOperation))) == null) {
                    throw new IllegalStateException(String.format("Task build operation %s was finished without being started.", buildOperation));
                }
            }
        }

        private OperationIdentifier mandatoryIdOf(BuildOperationDescriptor buildOperation) {
            OperationIdentifier id = buildOperation.getId();
            if (id == null) {
                throw new IllegalStateException(String.format("Build operation %s has no valid id", buildOperation));
            }
            return id;
        }

        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
        }

        public boolean hasRunningWork() {
            return !this.runningTasks.isEmpty() || !this.runningTransformActions.isEmpty();
        }

        private static boolean isTransformAction(BuildOperationDescriptor buildOperation) {
            return UncategorizedBuildOperations.TRANSFORM_ACTION.equals((Object)buildOperation.getMetadata());
        }
    }
}

