/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.packages;

import org.graalvm.visualvm.lib.profiler.snaptracer.TracerPackage;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProbe;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProbeDescriptor;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.IdeSnapshot;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.packages.TestProbe;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.packages.UiGesturesProbe;

class TestPackage
extends TracerPackage {
    private TracerProbeDescriptor descriptor1;
    private TracerProbeDescriptor descriptor2;
    private TracerProbe probe1;
    private TracerProbe probe2;
    private IdeSnapshot snapshot;

    TestPackage(IdeSnapshot snapshot) {
        super("Test Package", "Package for testing purposes", null, 1);
        this.snapshot = snapshot;
    }

    @Override
    public TracerProbeDescriptor[] getProbeDescriptors() {
        if (this.snapshot.hasUiGestures()) {
            this.descriptor1 = new TracerProbeDescriptor("UI Actions", "Shows UI actions performed by the user in the IDE", null, 1, true);
            this.descriptor2 = new TracerProbeDescriptor("Stack depth", "Reports the cumulative depth of all running threads", null, 2, true);
            return new TracerProbeDescriptor[]{this.descriptor1, this.descriptor2};
        }
        this.descriptor2 = new TracerProbeDescriptor("Stack depth", "Reports the cumulative depth of all running threads", null, 2, true);
        return new TracerProbeDescriptor[]{this.descriptor2};
    }

    @Override
    public TracerProbe getProbe(TracerProbeDescriptor descriptor) {
        if (descriptor == this.descriptor1) {
            if (this.probe1 == null) {
                this.probe1 = new UiGesturesProbe(this.snapshot);
            }
            return this.probe1;
        }
        if (descriptor == this.descriptor2) {
            if (this.probe2 == null) {
                this.probe2 = new TestProbe(this.snapshot);
            }
            return this.probe2;
        }
        return null;
    }
}

