/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.updater.ModuleDeactivator;
import org.netbeans.updater.ModuleUpdater;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdatingContext;
import org.netbeans.updater.XMLUtil;

public final class UpdaterDispatcher
implements Runnable {
    private Boolean disable = null;
    private Boolean enable = null;
    private Boolean install = null;
    private Boolean uninstall = null;
    public static final String UPDATE_DIR = "update";
    public static final String DEACTIVATE_DIR = "deactivate";
    public static final String NEW_UPDATER_DIR = "new_updater";
    public static final String DEACTIVATE_LATER = "deactivate_later.txt";
    public static final String LAST_MODIFIED = ".lastModified";
    private final UpdatingContext context;

    UpdaterDispatcher(UpdatingContext updatingContext) {
        this.context = updatingContext;
    }

    private void dispatch() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        try {
            if (this.isUninstallScheduled()) {
                new ModuleDeactivator(this.context).delete();
            }
            if (this.isDisableScheduled()) {
                new ModuleDeactivator(this.context).enableDisable(false);
            }
            if (this.isEnableScheduled()) {
                new ModuleDeactivator(this.context).enableDisable(true);
            }
            if (this.isInstallScheduled()) {
                try {
                    ModuleUpdater moduleUpdater = new ModuleUpdater(this.context);
                    moduleUpdater.start();
                    moduleUpdater.join();
                }
                catch (InterruptedException interruptedException) {
                    XMLUtil.LOG.log(Level.SEVERE, "Error", interruptedException);
                }
            }
        }
        catch (Exception exception) {
            XMLUtil.LOG.log(Level.WARNING, "Handling delete throws", exception);
        }
        finally {
            this.context.unpackingFinished();
        }
    }

    private boolean isDisableScheduled() {
        if (this.disable == null) {
            this.exploreUpdateDir();
        }
        return this.disable;
    }

    private boolean isEnableScheduled() {
        if (this.enable == null) {
            this.exploreUpdateDir();
        }
        return this.enable;
    }

    private boolean isUninstallScheduled() {
        if (this.uninstall == null) {
            this.exploreUpdateDir();
        }
        return this.uninstall;
    }

    private boolean isInstallScheduled() {
        if (this.install == null) {
            this.exploreUpdateDir();
        }
        return this.install;
    }

    private void exploreUpdateDir() {
        this.install = false;
        this.uninstall = false;
        this.disable = false;
        this.enable = false;
        for (File file : UpdateTracking.clusters(true)) {
            File file2 = new File(file, UPDATE_DIR);
            if (!file2.exists() || !file2.isDirectory()) continue;
            if (this.install == null || !this.install.booleanValue()) {
                this.install = !ModuleUpdater.getModulesToInstall(file).isEmpty();
            }
            if (this.uninstall == null || !this.uninstall.booleanValue()) {
                this.uninstall = ModuleDeactivator.hasModulesForDelete(file2);
            }
            if (this.disable == null || !this.disable.booleanValue()) {
                this.disable = ModuleDeactivator.hasModulesForDisable(file2);
            }
            if (this.enable != null && this.enable.booleanValue()) continue;
            this.enable = ModuleDeactivator.hasModulesForEnable(file2);
        }
    }

    @Override
    public void run() {
        this.dispatch();
        this.context.disposeSplash();
    }

    public static void touchLastModified(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            File file2 = new File(file, LAST_MODIFIED);
            if (!file2.exists() && !file2.createNewFile()) {
                throw new IOException("Can`t create stamp file " + file2);
            }
            if (!file2.setLastModified(System.currentTimeMillis())) {
                file2.delete();
                file2.createNewFile();
                file2.setLastModified(System.currentTimeMillis());
            }
        }
        catch (IOException iOException) {
            XMLUtil.LOG.log(Level.WARNING, null, iOException);
        }
    }
}

