/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import nu.validator.servlet.DelegatingServletInputStream;

public final class InboundGzipFilter
implements Filter {
    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        response.setHeader("Accept-Encoding", "gzip");
        String ce = request.getHeader("Content-Encoding");
        if (ce != null && "gzip".equalsIgnoreCase(ce.trim())) {
            chain.doFilter(new RequestWrapper(request), res);
        } else {
            chain.doFilter(req, res);
        }
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
    }

    private final class RequestWrapper
    extends HttpServletRequestWrapper {
        private ServletInputStream stream;

        public RequestWrapper(HttpServletRequest req) throws IOException {
            super(req);
            this.stream = null;
        }

        @Override
        public long getDateHeader(String name) {
            if ("Content-Length".equalsIgnoreCase(name)) {
                return -1L;
            }
            if ("Content-MD5".equalsIgnoreCase(name)) {
                return -1L;
            }
            if ("Content-Encoding".equalsIgnoreCase(name)) {
                return -1L;
            }
            return super.getDateHeader(name);
        }

        @Override
        public String getHeader(String name) {
            if ("Content-Length".equalsIgnoreCase(name)) {
                return null;
            }
            if ("Content-MD5".equalsIgnoreCase(name)) {
                return null;
            }
            if ("Content-Encoding".equalsIgnoreCase(name)) {
                return null;
            }
            return super.getHeader(name);
        }

        public Enumeration getHeaderNames() {
            Enumeration<String> e = super.getHeaderNames();
            ArrayList<String> list = new ArrayList<String>();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                if ("Content-Length".equalsIgnoreCase(name) || "Content-MD5".equalsIgnoreCase(name) || "Content-Encoding".equalsIgnoreCase(name)) continue;
                list.add(name);
            }
            return Collections.enumeration(list);
        }

        public Enumeration getHeaders(String name) {
            if ("Content-Length".equalsIgnoreCase(name)) {
                return Collections.enumeration(Collections.EMPTY_SET);
            }
            if ("Content-MD5".equalsIgnoreCase(name)) {
                return Collections.enumeration(Collections.EMPTY_SET);
            }
            if ("Content-Encoding".equalsIgnoreCase(name)) {
                return Collections.enumeration(Collections.EMPTY_SET);
            }
            return super.getHeaders(name);
        }

        @Override
        public int getIntHeader(String name) {
            if ("Content-Length".equalsIgnoreCase(name)) {
                return -1;
            }
            if ("Content-MD5".equalsIgnoreCase(name)) {
                return -1;
            }
            if ("Content-Encoding".equalsIgnoreCase(name)) {
                return -1;
            }
            return super.getIntHeader(name);
        }

        @Override
        public int getContentLength() {
            return -1;
        }

        @Override
        public ServletInputStream getInputStream() throws IOException {
            if (this.stream == null) {
                this.stream = new DelegatingServletInputStream(new GZIPInputStream(super.getInputStream()));
            }
            return this.stream;
        }
    }
}

