/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicColorChooserUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthColorChooserUI
extends BasicColorChooserUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthColorChooserUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthColorChooserUI();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        SynthContext synthContext = this.getContext(this.chooser, 1);
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = (AbstractColorChooserPanel[])synthContext.getStyle().get(synthContext, "ColorChooser.panels");
        synthContext.dispose();
        if (abstractColorChooserPanelArray == null) {
            abstractColorChooserPanelArray = ColorChooserComponentFactory.getDefaultChooserPanels();
        }
        return abstractColorChooserPanelArray;
    }

    protected void installDefaults() {
        this.updateStyle(this.chooser);
    }

    private void updateStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.chooser, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        super.uninstallDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        this.chooser.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintColorChooserBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintColorChooserBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JColorChooser)propertyChangeEvent.getSource());
        }
    }
}

