/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.net.URL;
import sun.net.ProgressMonitor;

public class ProgressSource {
    private URL url;
    private String method;
    private String contentType;
    private int progress = 0;
    private int lastProgress = 0;
    private int expected = -1;
    private State state;
    private boolean connected = false;
    private int threshold = 8192;
    private ProgressMonitor progressMonitor;

    public ProgressSource(URL uRL, String string) {
        this(uRL, string, -1);
    }

    public ProgressSource(URL uRL, String string, int n) {
        this.url = uRL;
        this.method = string;
        this.contentType = "content/unknown";
        this.progress = 0;
        this.lastProgress = 0;
        this.expected = n;
        this.state = State.NEW;
        this.progressMonitor = ProgressMonitor.getDefault();
        this.threshold = this.progressMonitor.getProgressUpdateThreshold();
    }

    public boolean connected() {
        if (!this.connected) {
            this.connected = true;
            this.state = State.CONNECTED;
            return false;
        }
        return true;
    }

    public void close() {
        this.state = State.DELETE;
    }

    public URL getURL() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getExpected() {
        return this.expected;
    }

    public State getState() {
        return this.state;
    }

    public void beginTracking() {
        this.progressMonitor.registerSource(this);
    }

    public void finishTracking() {
        this.progressMonitor.unregisterSource(this);
    }

    public void updateProgress(int n, int n2) {
        this.lastProgress = this.progress;
        this.progress = n;
        this.expected = n2;
        this.state = !this.connected() ? State.CONNECTED : State.UPDATE;
        if (this.lastProgress / this.threshold != this.progress / this.threshold) {
            this.progressMonitor.updateProgress(this);
        }
        if (this.expected != -1 && this.progress >= this.expected && this.progress != 0) {
            this.close();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.getClass().getName() + "[url=" + this.url + ", method=" + this.method + ", state=" + (Object)((Object)this.state) + ", content-type=" + this.contentType + ", progress=" + this.progress + ", expected=" + this.expected + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NEW,
        CONNECTED,
        UPDATE,
        DELETE;

    }
}

