/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.EncodingConstants;
import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithmFactory;
import com.sun.xml.internal.fastinfoset.org.apache.xerces.util.XMLChar;
import com.sun.xml.internal.fastinfoset.util.CharArrayIntMap;
import com.sun.xml.internal.fastinfoset.util.LocalNameQualifiedNamesMap;
import com.sun.xml.internal.fastinfoset.util.StringIntMap;
import com.sun.xml.internal.fastinfoset.vocab.SerializerVocabulary;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithm;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithmException;
import com.sun.xml.internal.org.jvnet.fastinfoset.ExternalVocabulary;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetException;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetSerializer;
import com.sun.xml.internal.org.jvnet.fastinfoset.VocabularyApplicationData;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Encoder
extends DefaultHandler
implements FastInfosetSerializer {
    public static final String CHARACTER_ENCODING_SCHEME_SYSTEM_PROPERTY = "com.sun.xml.internal.fastinfoset.serializer.character-encoding-scheme";
    protected static final String _characterEncodingSchemeSystemDefault;
    protected static int[] NUMERIC_CHARACTERS_TABLE;
    protected static int[] DATE_TIME_CHARACTERS_TABLE;
    private boolean _ignoreDTD;
    private boolean _ignoreComments;
    private boolean _ignoreProcessingInstructions;
    private boolean _ignoreWhiteSpaceTextContent;
    private boolean _useLocalNameAsKeyForQualifiedNameLookup;
    private boolean _encodingStringsAsUtf8 = true;
    private int _nonIdentifyingStringOnThirdBitCES;
    private int _nonIdentifyingStringOnFirstBitCES;
    private Map _registeredEncodingAlgorithms = new HashMap();
    protected SerializerVocabulary _v;
    protected VocabularyApplicationData _vData;
    private boolean _vIsInternal;
    protected boolean _terminate = false;
    protected int _b;
    protected OutputStream _s;
    protected char[] _charBuffer = new char[512];
    protected byte[] _octetBuffer = new byte[1024];
    protected int _octetBufferIndex;
    protected int _markIndex = -1;
    protected int attributeValueSizeConstraint = 32;
    protected int attributeValueMapTotalCharactersConstraint = 0x3FFFFFFF;
    protected int characterContentChunkSizeContraint = 32;
    protected int characterContentChunkMapTotalCharactersConstraint = 0x3FFFFFFF;
    private int _bitsLeftInOctet;
    private EncodingBufferOutputStream _encodingBufferOutputStream = new EncodingBufferOutputStream();
    private byte[] _encodingBuffer = new byte[512];
    private int _encodingBufferIndex;

    private static String getDefaultEncodingScheme() {
        String string = System.getProperty(CHARACTER_ENCODING_SCHEME_SYSTEM_PROPERTY, "UTF-8");
        if (string.equals("UTF-16BE")) {
            return "UTF-16BE";
        }
        return "UTF-8";
    }

    private static int maxCharacter(String string) {
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            if (c >= string.charAt(i)) continue;
            c = string.charAt(i);
        }
        return c;
    }

    protected Encoder() {
        this.setCharacterEncodingScheme(_characterEncodingSchemeSystemDefault);
    }

    protected Encoder(boolean bl) {
        this.setCharacterEncodingScheme(_characterEncodingSchemeSystemDefault);
        this._useLocalNameAsKeyForQualifiedNameLookup = bl;
    }

    public final void setIgnoreDTD(boolean bl) {
        this._ignoreDTD = bl;
    }

    public final boolean getIgnoreDTD() {
        return this._ignoreDTD;
    }

    public final void setIgnoreComments(boolean bl) {
        this._ignoreComments = bl;
    }

    public final boolean getIgnoreComments() {
        return this._ignoreComments;
    }

    public final void setIgnoreProcesingInstructions(boolean bl) {
        this._ignoreProcessingInstructions = bl;
    }

    public final boolean getIgnoreProcesingInstructions() {
        return this._ignoreProcessingInstructions;
    }

    public final void setIgnoreWhiteSpaceTextContent(boolean bl) {
        this._ignoreWhiteSpaceTextContent = bl;
    }

    public final boolean getIgnoreWhiteSpaceTextContent() {
        return this._ignoreWhiteSpaceTextContent;
    }

    public void setCharacterEncodingScheme(String string) {
        if (string.equals("UTF-16BE")) {
            this._encodingStringsAsUtf8 = false;
            this._nonIdentifyingStringOnThirdBitCES = 132;
            this._nonIdentifyingStringOnFirstBitCES = 16;
        } else {
            this._encodingStringsAsUtf8 = true;
            this._nonIdentifyingStringOnThirdBitCES = 128;
            this._nonIdentifyingStringOnFirstBitCES = 0;
        }
    }

    public String getCharacterEncodingScheme() {
        return this._encodingStringsAsUtf8 ? "UTF-8" : "UTF-16BE";
    }

    public void setRegisteredEncodingAlgorithms(Map map) {
        this._registeredEncodingAlgorithms = map;
        if (this._registeredEncodingAlgorithms == null) {
            this._registeredEncodingAlgorithms = new HashMap();
        }
    }

    public Map getRegisteredEncodingAlgorithms() {
        return this._registeredEncodingAlgorithms;
    }

    public void setCharacterContentChunkSizeLimit(int n) {
        if (n < 0) {
            n = 0;
        }
        this.characterContentChunkSizeContraint = n;
    }

    public int getCharacterContentChunkSizeLimit() {
        return this.characterContentChunkSizeContraint;
    }

    public void setCharacterContentChunkMapMemoryLimit(int n) {
        if (n < 0) {
            n = 0;
        }
        this.characterContentChunkMapTotalCharactersConstraint = n / 2;
    }

    public int getCharacterContentChunkMapMemoryLimit() {
        return this.characterContentChunkMapTotalCharactersConstraint * 2;
    }

    public boolean isCharacterContentChunkLengthMatchesLimit(int n, CharArrayIntMap charArrayIntMap) {
        return n < this.characterContentChunkSizeContraint && charArrayIntMap.getTotalCharacterCount() + n < this.characterContentChunkMapTotalCharactersConstraint;
    }

    public void setAttributeValueSizeLimit(int n) {
        if (n < 0) {
            n = 0;
        }
        this.attributeValueSizeConstraint = n;
    }

    public int getAttributeValueSizeLimit() {
        return this.attributeValueSizeConstraint;
    }

    public void setAttributeValueMapMemoryLimit(int n) {
        if (n < 0) {
            n = 0;
        }
        this.attributeValueMapTotalCharactersConstraint = n / 2;
    }

    public int getAttributeValueMapMemoryLimit() {
        return this.attributeValueMapTotalCharactersConstraint * 2;
    }

    public boolean isAttributeValueLengthMatchesLimit(int n) {
        return n < this.attributeValueSizeConstraint && this._v.attributeValue.getTotalCharacterCount() + n < this.attributeValueMapTotalCharactersConstraint;
    }

    public void setExternalVocabulary(ExternalVocabulary externalVocabulary) {
        this._v = new SerializerVocabulary();
        SerializerVocabulary serializerVocabulary = new SerializerVocabulary(externalVocabulary.vocabulary, this._useLocalNameAsKeyForQualifiedNameLookup);
        this._v.setExternalVocabulary(externalVocabulary.URI, serializerVocabulary, false);
        this._vIsInternal = true;
    }

    public void setVocabularyApplicationData(VocabularyApplicationData vocabularyApplicationData) {
        this._vData = vocabularyApplicationData;
    }

    public VocabularyApplicationData getVocabularyApplicationData() {
        return this._vData;
    }

    public void reset() {
        this._terminate = false;
    }

    public void setOutputStream(OutputStream outputStream) {
        this._octetBufferIndex = 0;
        this._markIndex = -1;
        this._s = outputStream;
    }

    public void setVocabulary(SerializerVocabulary serializerVocabulary) {
        this._v = serializerVocabulary;
        this._vIsInternal = false;
    }

    protected final void encodeHeader(boolean bl) throws IOException {
        if (bl) {
            this._s.write(EncodingConstants.XML_DECLARATION_VALUES[0]);
        }
        this._s.write(EncodingConstants.BINARY_HEADER);
    }

    protected final void encodeInitialVocabulary() throws IOException {
        if (this._v == null) {
            this._v = new SerializerVocabulary();
            this._vIsInternal = true;
        } else if (this._vIsInternal) {
            this._v.clear();
            if (this._vData != null) {
                this._vData.clear();
            }
        }
        if (!this._v.hasInitialVocabulary() && !this._v.hasExternalVocabulary()) {
            this.write(0);
        } else if (this._v.hasInitialVocabulary()) {
            this._b = 32;
            this.write(this._b);
            SerializerVocabulary serializerVocabulary = this._v.getReadOnlyVocabulary();
            if (serializerVocabulary.hasExternalVocabulary()) {
                this._b = 16;
                this.write(this._b);
                this.write(0);
            }
            if (serializerVocabulary.hasExternalVocabulary()) {
                this.encodeNonEmptyOctetStringOnSecondBit(this._v.getExternalVocabularyURI());
            }
        } else if (this._v.hasExternalVocabulary()) {
            this._b = 32;
            this.write(this._b);
            this._b = 16;
            this.write(this._b);
            this.write(0);
            this.encodeNonEmptyOctetStringOnSecondBit(this._v.getExternalVocabularyURI());
        }
    }

    protected final void encodeDocumentTermination() throws IOException {
        this.encodeElementTermination();
        this.encodeTermination();
        this._flush();
        this._s.flush();
    }

    protected final void encodeElementTermination() throws IOException {
        this._terminate = true;
        switch (this._b) {
            case 240: {
                this._b = 255;
                break;
            }
            case 255: {
                this.write(255);
            }
            default: {
                this._b = 240;
            }
        }
    }

    protected final void encodeTermination() throws IOException {
        if (this._terminate) {
            this.write(this._b);
            this._b = 0;
            this._terminate = false;
        }
    }

    protected final void encodeNamespaceAttribute(String string, String string2) throws IOException {
        this._b = 204;
        if (string.length() > 0) {
            this._b |= 2;
        }
        if (string2.length() > 0) {
            this._b |= 1;
        }
        this.write(this._b);
        if (string.length() > 0) {
            this.encodeIdentifyingNonEmptyStringOnFirstBit(string, this._v.prefix);
        }
        if (string2.length() > 0) {
            this.encodeIdentifyingNonEmptyStringOnFirstBit(string2, this._v.namespaceName);
        }
    }

    protected final void encodeCharacters(char[] cArray, int n, int n2) throws IOException {
        boolean bl = this.isCharacterContentChunkLengthMatchesLimit(n2, this._v.characterContentChunk);
        this.encodeNonIdentifyingStringOnThirdBit(cArray, n, n2, this._v.characterContentChunk, bl, true);
    }

    protected final void encodeCharactersNoClone(char[] cArray, int n, int n2) throws IOException {
        boolean bl = this.isCharacterContentChunkLengthMatchesLimit(n2, this._v.characterContentChunk);
        this.encodeNonIdentifyingStringOnThirdBit(cArray, n, n2, this._v.characterContentChunk, bl, false);
    }

    protected final void encodeFourBitCharacters(int n, int[] nArray, char[] cArray, int n2, int n3, boolean bl) throws FastInfosetException, IOException {
        int n4;
        if (bl && (n4 = this._v.characterContentChunk.obtainIndex(cArray, n2, n3, true)) != -1) {
            this._b = 160;
            this.encodeNonZeroIntegerOnFourthBit(n4);
            return;
        }
        this._b = bl ? 152 : 136;
        this.write(this._b);
        this._b = n << 2;
        this.encodeNonEmptyFourBitCharacterStringOnSeventhBit(nArray, cArray, n2, n3);
    }

    protected final void encodeAlphabetCharacters(String string, char[] cArray, int n, int n2, boolean bl) throws FastInfosetException, IOException {
        int n3;
        if (bl && (n3 = this._v.characterContentChunk.obtainIndex(cArray, n, n2, true)) != -1) {
            this._b = 160;
            this.encodeNonZeroIntegerOnFourthBit(n3);
            return;
        }
        n3 = this._v.restrictedAlphabet.get(string);
        if (n3 == -1) {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.restrictedAlphabetNotPresent"));
        }
        this._b = bl ? 152 : 136;
        this._b |= ((n3 += 32) & 0xC0) >> 6;
        this.write(this._b);
        this._b = (n3 & 0x3F) << 2;
        this.encodeNonEmptyNBitCharacterStringOnSeventhBit(string, cArray, n, n2);
    }

    protected final void encodeProcessingInstruction(String string, String string2) throws IOException {
        this.write(225);
        this.encodeIdentifyingNonEmptyStringOnFirstBit(string, this._v.otherNCName);
        boolean bl = this.isCharacterContentChunkLengthMatchesLimit(string2.length(), this._v.characterContentChunk);
        this.encodeNonIdentifyingStringOnFirstBit(string2, this._v.otherString, bl);
    }

    protected final void encodeDocumentTypeDeclaration(String string, String string2) throws IOException {
        this._b = 196;
        if (string != null && string.length() > 0) {
            this._b |= 2;
        }
        if (string2 != null && string2.length() > 0) {
            this._b |= 1;
        }
        this.write(this._b);
        if (string != null && string.length() > 0) {
            this.encodeIdentifyingNonEmptyStringOnFirstBit(string, this._v.otherURI);
        }
        if (string2 != null && string2.length() > 0) {
            this.encodeIdentifyingNonEmptyStringOnFirstBit(string2, this._v.otherURI);
        }
    }

    protected final void encodeComment(char[] cArray, int n, int n2) throws IOException {
        this.write(226);
        boolean bl = this.isCharacterContentChunkLengthMatchesLimit(n2, this._v.otherString);
        this.encodeNonIdentifyingStringOnFirstBit(cArray, n, n2, this._v.otherString, bl, true);
    }

    protected final void encodeCommentNoClone(char[] cArray, int n, int n2) throws IOException {
        this.write(226);
        boolean bl = this.isCharacterContentChunkLengthMatchesLimit(n2, this._v.otherString);
        this.encodeNonIdentifyingStringOnFirstBit(cArray, n, n2, this._v.otherString, bl, false);
    }

    protected final void encodeElementQualifiedNameOnThirdBit(String string, String string2, String string3) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.elementName.obtainEntry(string3);
        if (entry._valueIndex > 0) {
            QualifiedName[] qualifiedNameArray = entry._value;
            for (int i = 0; i < entry._valueIndex; ++i) {
                if (string2 != qualifiedNameArray[i].prefix && !string2.equals(qualifiedNameArray[i].prefix) || string != qualifiedNameArray[i].namespaceName && !string.equals(qualifiedNameArray[i].namespaceName)) continue;
                this.encodeNonZeroIntegerOnThirdBit(qualifiedNameArray[i].index);
                return;
            }
        }
        this.encodeLiteralElementQualifiedNameOnThirdBit(string, string2, string3, entry);
    }

    protected final void encodeLiteralElementQualifiedNameOnThirdBit(String string, String string2, String string3, LocalNameQualifiedNamesMap.Entry entry) throws IOException {
        QualifiedName qualifiedName = new QualifiedName(string2, string, string3, "", this._v.elementName.getNextIndex());
        entry.addQualifiedName(qualifiedName);
        int n = -1;
        int n2 = -1;
        if (string.length() > 0) {
            n = this._v.namespaceName.get(string);
            if (n == -1) {
                throw new IOException(CommonResourceBundle.getInstance().getString("message.namespaceURINotIndexed", new Object[]{string}));
            }
            if (string2.length() > 0 && (n2 = this._v.prefix.get(string2)) == -1) {
                throw new IOException(CommonResourceBundle.getInstance().getString("message.prefixNotIndexed", new Object[]{string2}));
            }
        }
        int n3 = this._v.localName.obtainIndex(string3);
        this._b |= 0x3C;
        if (n >= 0) {
            this._b |= 1;
            if (n2 >= 0) {
                this._b |= 2;
            }
        }
        this.write(this._b);
        if (n >= 0) {
            if (n2 >= 0) {
                this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n2);
            }
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n);
        }
        if (n3 >= 0) {
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n3);
        } else {
            this.encodeNonEmptyOctetStringOnSecondBit(string3);
        }
    }

    protected final void encodeAttributeQualifiedNameOnSecondBit(String string, String string2, String string3) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.attributeName.obtainEntry(string3);
        if (entry._valueIndex > 0) {
            QualifiedName[] qualifiedNameArray = entry._value;
            for (int i = 0; i < entry._valueIndex; ++i) {
                if (string2 != qualifiedNameArray[i].prefix && !string2.equals(qualifiedNameArray[i].prefix) || string != qualifiedNameArray[i].namespaceName && !string.equals(qualifiedNameArray[i].namespaceName)) continue;
                this.encodeNonZeroIntegerOnSecondBitFirstBitZero(qualifiedNameArray[i].index);
                return;
            }
        }
        this.encodeLiteralAttributeQualifiedNameOnSecondBit(string, string2, string3, entry);
    }

    protected final boolean encodeLiteralAttributeQualifiedNameOnSecondBit(String string, String string2, String string3, LocalNameQualifiedNamesMap.Entry entry) throws IOException {
        int n = -1;
        int n2 = -1;
        if (string.length() > 0) {
            n = this._v.namespaceName.get(string);
            if (n == -1) {
                if (string == "http://www.w3.org/2000/xmlns/" || string.equals("http://www.w3.org/2000/xmlns/")) {
                    return false;
                }
                throw new IOException(CommonResourceBundle.getInstance().getString("message.namespaceURINotIndexed", new Object[]{string}));
            }
            if (string2.length() > 0 && (n2 = this._v.prefix.get(string2)) == -1) {
                throw new IOException(CommonResourceBundle.getInstance().getString("message.prefixNotIndexed", new Object[]{string2}));
            }
        }
        int n3 = this._v.localName.obtainIndex(string3);
        QualifiedName qualifiedName = new QualifiedName(string2, string, string3, "", this._v.attributeName.getNextIndex());
        entry.addQualifiedName(qualifiedName);
        this._b = 120;
        if (string.length() > 0) {
            this._b |= 1;
            if (string2.length() > 0) {
                this._b |= 2;
            }
        }
        this.write(this._b);
        if (n >= 0) {
            if (n2 >= 0) {
                this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n2);
            }
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n);
        } else if (string != "") {
            this.encodeNonEmptyOctetStringOnSecondBit("xml");
            this.encodeNonEmptyOctetStringOnSecondBit("http://www.w3.org/XML/1998/namespace");
        }
        if (n3 >= 0) {
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n3);
        } else {
            this.encodeNonEmptyOctetStringOnSecondBit(string3);
        }
        return true;
    }

    protected final void encodeNonIdentifyingStringOnFirstBit(String string, StringIntMap stringIntMap, boolean bl) throws IOException {
        if (string == null || string.length() == 0) {
            this.write(255);
        } else if (bl) {
            int n = stringIntMap.obtainIndex(string);
            if (n == -1) {
                this._b = 0x40 | this._nonIdentifyingStringOnFirstBitCES;
                this.encodeNonEmptyCharacterStringOnFifthBit(string);
            } else {
                this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n);
            }
        } else {
            this._b = this._nonIdentifyingStringOnFirstBitCES;
            this.encodeNonEmptyCharacterStringOnFifthBit(string);
        }
    }

    protected final void encodeNonIdentifyingStringOnFirstBit(String string, CharArrayIntMap charArrayIntMap, boolean bl) throws IOException {
        if (string == null || string.length() == 0) {
            this.write(255);
        } else if (bl) {
            int n;
            char[] cArray = string.toCharArray();
            int n2 = charArrayIntMap.obtainIndex(cArray, 0, n = string.length(), false);
            if (n2 == -1) {
                this._b = 0x40 | this._nonIdentifyingStringOnFirstBitCES;
                this.encodeNonEmptyCharacterStringOnFifthBit(cArray, 0, n);
            } else {
                this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n2);
            }
        } else {
            this._b = this._nonIdentifyingStringOnFirstBitCES;
            this.encodeNonEmptyCharacterStringOnFifthBit(string);
        }
    }

    protected final void encodeNonIdentifyingStringOnFirstBit(char[] cArray, int n, int n2, CharArrayIntMap charArrayIntMap, boolean bl, boolean bl2) throws IOException {
        if (n2 == 0) {
            this.write(255);
        } else if (bl) {
            int n3 = charArrayIntMap.obtainIndex(cArray, n, n2, bl2);
            if (n3 == -1) {
                this._b = 0x40 | this._nonIdentifyingStringOnFirstBitCES;
                this.encodeNonEmptyCharacterStringOnFifthBit(cArray, n, n2);
            } else {
                this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n3);
            }
        } else {
            this._b = this._nonIdentifyingStringOnFirstBitCES;
            this.encodeNonEmptyCharacterStringOnFifthBit(cArray, n, n2);
        }
    }

    protected final void encodeNonIdentifyingStringOnFirstBit(int n, int[] nArray, String string, boolean bl) throws IOException, FastInfosetException {
        int n2;
        if (string == null || string.length() == 0) {
            this.write(255);
            return;
        }
        if (bl && (n2 = this._v.attributeValue.obtainIndex(string)) != -1) {
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n2);
            return;
        }
        this._b = bl ? 96 : 32;
        this.write(this._b | (n & 0xF0) >> 4);
        this._b = (n & 0xF) << 4;
        n2 = string.length();
        int n3 = n2 / 2;
        int n4 = n2 % 2;
        this.encodeNonZeroOctetStringLengthOnFifthBit(n3 + n4);
        this.encodeNonEmptyFourBitCharacterString(nArray, string.toCharArray(), 0, n3, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void encodeNonIdentifyingStringOnFirstBit(String string, int n, Object object) throws FastInfosetException, IOException {
        if (string != null) {
            n = this._v.encodingAlgorithm.get(string);
            if (n == -1) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.EncodingAlgorithmURI", new Object[]{string}));
            }
            n += 32;
            EncodingAlgorithm encodingAlgorithm = (EncodingAlgorithm)this._registeredEncodingAlgorithms.get(string);
            if (encodingAlgorithm != null) {
                this.encodeAIIObjectAlgorithmData(n, object, encodingAlgorithm);
                return;
            } else {
                if (!(object instanceof byte[])) throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.nullEncodingAlgorithmURI"));
                byte[] byArray = (byte[])object;
                this.encodeAIIOctetAlgorithmData(n, byArray, 0, byArray.length);
            }
            return;
        } else if (n <= 9) {
            int n2 = 0;
            switch (n) {
                case 0: 
                case 1: {
                    n2 = ((byte[])object).length;
                    break;
                }
                case 2: {
                    n2 = ((short[])object).length;
                    break;
                }
                case 3: {
                    n2 = ((int[])object).length;
                    break;
                }
                case 4: 
                case 8: {
                    n2 = ((long[])object).length;
                    break;
                }
                case 5: {
                    n2 = ((boolean[])object).length;
                    break;
                }
                case 6: {
                    n2 = ((float[])object).length;
                    break;
                }
                case 7: {
                    n2 = ((double[])object).length;
                    break;
                }
                case 9: {
                    throw new UnsupportedOperationException(CommonResourceBundle.getInstance().getString("message.CDATA"));
                }
                default: {
                    throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.UnsupportedBuiltInAlgorithm", new Object[]{n}));
                }
            }
            this.encodeAIIBuiltInAlgorithmData(n, object, 0, n2);
            return;
        } else {
            if (n < 32) throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.identifiers10to31Reserved"));
            if (!(object instanceof byte[])) throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.nullEncodingAlgorithmURI"));
            byte[] byArray = (byte[])object;
            this.encodeAIIOctetAlgorithmData(n, byArray, 0, byArray.length);
        }
    }

    protected final void encodeAIIOctetAlgorithmData(int n, byte[] byArray, int n2, int n3) throws IOException {
        this.write(0x30 | (n & 0xF0) >> 4);
        this._b = (n & 0xF) << 4;
        this.encodeNonZeroOctetStringLengthOnFifthBit(n3);
        this.write(byArray, n2, n3);
    }

    protected final void encodeAIIObjectAlgorithmData(int n, Object object, EncodingAlgorithm encodingAlgorithm) throws FastInfosetException, IOException {
        this.write(0x30 | (n & 0xF0) >> 4);
        this._b = (n & 0xF) << 4;
        this._encodingBufferOutputStream.reset();
        encodingAlgorithm.encodeToOutputStream(object, this._encodingBufferOutputStream);
        this.encodeNonZeroOctetStringLengthOnFifthBit(this._encodingBufferIndex);
        this.write(this._encodingBuffer, this._encodingBufferIndex);
    }

    protected final void encodeAIIBuiltInAlgorithmData(int n, Object object, int n2, int n3) throws IOException {
        this.write(0x30 | (n & 0xF0) >> 4);
        this._b = (n & 0xF) << 4;
        int n4 = BuiltInEncodingAlgorithmFactory.table[n].getOctetLengthFromPrimitiveLength(n3);
        this.encodeNonZeroOctetStringLengthOnFifthBit(n4);
        this.ensureSize(n4);
        BuiltInEncodingAlgorithmFactory.table[n].encodeToBytes(object, n2, n3, this._octetBuffer, this._octetBufferIndex);
        this._octetBufferIndex += n4;
    }

    protected final void encodeNonIdentifyingStringOnThirdBit(char[] cArray, int n, int n2, CharArrayIntMap charArrayIntMap, boolean bl, boolean bl2) throws IOException {
        if (bl) {
            int n3 = charArrayIntMap.obtainIndex(cArray, n, n2, bl2);
            if (n3 == -1) {
                this._b = 0x10 | this._nonIdentifyingStringOnThirdBitCES;
                this.encodeNonEmptyCharacterStringOnSeventhBit(cArray, n, n2);
            } else {
                this._b = 160;
                this.encodeNonZeroIntegerOnFourthBit(n3);
            }
        } else {
            this._b = this._nonIdentifyingStringOnThirdBitCES;
            this.encodeNonEmptyCharacterStringOnSeventhBit(cArray, n, n2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void encodeNonIdentifyingStringOnThirdBit(String string, int n, Object object) throws FastInfosetException, IOException {
        if (string != null) {
            n = this._v.encodingAlgorithm.get(string);
            if (n == -1) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.EncodingAlgorithmURI", new Object[]{string}));
            }
            n += 32;
            EncodingAlgorithm encodingAlgorithm = (EncodingAlgorithm)this._registeredEncodingAlgorithms.get(string);
            if (encodingAlgorithm != null) {
                this.encodeCIIObjectAlgorithmData(n, object, encodingAlgorithm);
                return;
            } else {
                if (!(object instanceof byte[])) throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.nullEncodingAlgorithmURI"));
                byte[] byArray = (byte[])object;
                this.encodeCIIOctetAlgorithmData(n, byArray, 0, byArray.length);
            }
            return;
        } else if (n <= 9) {
            int n2 = 0;
            switch (n) {
                case 0: 
                case 1: {
                    n2 = ((byte[])object).length;
                    break;
                }
                case 2: {
                    n2 = ((short[])object).length;
                    break;
                }
                case 3: {
                    n2 = ((int[])object).length;
                    break;
                }
                case 4: 
                case 8: {
                    n2 = ((long[])object).length;
                    break;
                }
                case 5: {
                    n2 = ((boolean[])object).length;
                    break;
                }
                case 6: {
                    n2 = ((float[])object).length;
                    break;
                }
                case 7: {
                    n2 = ((double[])object).length;
                    break;
                }
                case 9: {
                    throw new UnsupportedOperationException(CommonResourceBundle.getInstance().getString("message.CDATA"));
                }
                default: {
                    throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.UnsupportedBuiltInAlgorithm", new Object[]{n}));
                }
            }
            this.encodeCIIBuiltInAlgorithmData(n, object, 0, n2);
            return;
        } else {
            if (n < 32) throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.identifiers10to31Reserved"));
            if (!(object instanceof byte[])) throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.nullEncodingAlgorithmURI"));
            byte[] byArray = (byte[])object;
            this.encodeCIIOctetAlgorithmData(n, byArray, 0, byArray.length);
        }
    }

    protected final void encodeNonIdentifyingStringOnThirdBit(String string, int n, byte[] byArray, int n2, int n3) throws FastInfosetException, IOException {
        if (string != null) {
            n = this._v.encodingAlgorithm.get(string);
            if (n == -1) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.EncodingAlgorithmURI", new Object[]{string}));
            }
            n += 32;
        }
        this.encodeCIIOctetAlgorithmData(n, byArray, n2, n3);
    }

    protected final void encodeCIIOctetAlgorithmData(int n, byte[] byArray, int n2, int n3) throws IOException {
        this.write(0x8C | (n & 0xC0) >> 6);
        this._b = (n & 0x3F) << 2;
        this.encodeNonZeroOctetStringLengthOnSenventhBit(n3);
        this.write(byArray, n2, n3);
    }

    protected final void encodeCIIObjectAlgorithmData(int n, Object object, EncodingAlgorithm encodingAlgorithm) throws FastInfosetException, IOException {
        this.write(0x8C | (n & 0xC0) >> 6);
        this._b = (n & 0x3F) << 2;
        this._encodingBufferOutputStream.reset();
        encodingAlgorithm.encodeToOutputStream(object, this._encodingBufferOutputStream);
        this.encodeNonZeroOctetStringLengthOnSenventhBit(this._encodingBufferIndex);
        this.write(this._encodingBuffer, this._encodingBufferIndex);
    }

    protected final void encodeCIIBuiltInAlgorithmData(int n, Object object, int n2, int n3) throws FastInfosetException, IOException {
        this.write(0x8C | (n & 0xC0) >> 6);
        this._b = (n & 0x3F) << 2;
        int n4 = BuiltInEncodingAlgorithmFactory.table[n].getOctetLengthFromPrimitiveLength(n3);
        this.encodeNonZeroOctetStringLengthOnSenventhBit(n4);
        this.ensureSize(n4);
        BuiltInEncodingAlgorithmFactory.table[n].encodeToBytes(object, n2, n3, this._octetBuffer, this._octetBufferIndex);
        this._octetBufferIndex += n4;
    }

    protected final void encodeCIIBuiltInAlgorithmDataAsCDATA(char[] cArray, int n, int n2) throws FastInfosetException, IOException {
        this.write(140);
        this._b = 36;
        n2 = this.encodeUTF8String(cArray, n, n2);
        this.encodeNonZeroOctetStringLengthOnSenventhBit(n2);
        this.write(this._encodingBuffer, n2);
    }

    protected final void encodeIdentifyingNonEmptyStringOnFirstBit(String string, StringIntMap stringIntMap) throws IOException {
        int n = stringIntMap.obtainIndex(string);
        if (n == -1) {
            this.encodeNonEmptyOctetStringOnSecondBit(string);
        } else {
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n);
        }
    }

    protected final void encodeNonEmptyOctetStringOnSecondBit(String string) throws IOException {
        int n = this.encodeUTF8String(string);
        this.encodeNonZeroOctetStringLengthOnSecondBit(n);
        this.write(this._encodingBuffer, n);
    }

    protected final void encodeNonZeroOctetStringLengthOnSecondBit(int n) throws IOException {
        if (n < 65) {
            this.write(n - 1);
        } else if (n < 321) {
            this.write(64);
            this.write(n - 65);
        } else {
            this.write(96);
            this.write((n -= 321) >>> 24);
            this.write(n >> 16 & 0xFF);
            this.write(n >> 8 & 0xFF);
            this.write(n & 0xFF);
        }
    }

    protected final void encodeNonEmptyCharacterStringOnFifthBit(String string) throws IOException {
        int n = this._encodingStringsAsUtf8 ? this.encodeUTF8String(string) : this.encodeUtf16String(string);
        this.encodeNonZeroOctetStringLengthOnFifthBit(n);
        this.write(this._encodingBuffer, n);
    }

    protected final void encodeNonEmptyCharacterStringOnFifthBit(char[] cArray, int n, int n2) throws IOException {
        n2 = this._encodingStringsAsUtf8 ? this.encodeUTF8String(cArray, n, n2) : this.encodeUtf16String(cArray, n, n2);
        this.encodeNonZeroOctetStringLengthOnFifthBit(n2);
        this.write(this._encodingBuffer, n2);
    }

    protected final void encodeNonZeroOctetStringLengthOnFifthBit(int n) throws IOException {
        if (n < 9) {
            this.write(this._b | n - 1);
        } else if (n < 265) {
            this.write(this._b | 8);
            this.write(n - 9);
        } else {
            this.write(this._b | 0xC);
            this.write((n -= 265) >>> 24);
            this.write(n >> 16 & 0xFF);
            this.write(n >> 8 & 0xFF);
            this.write(n & 0xFF);
        }
    }

    protected final void encodeNonEmptyCharacterStringOnSeventhBit(char[] cArray, int n, int n2) throws IOException {
        n2 = this._encodingStringsAsUtf8 ? this.encodeUTF8String(cArray, n, n2) : this.encodeUtf16String(cArray, n, n2);
        this.encodeNonZeroOctetStringLengthOnSenventhBit(n2);
        this.write(this._encodingBuffer, n2);
    }

    protected final void encodeNonEmptyFourBitCharacterStringOnSeventhBit(int[] nArray, char[] cArray, int n, int n2) throws FastInfosetException, IOException {
        int n3 = n2 / 2;
        int n4 = n2 % 2;
        this.encodeNonZeroOctetStringLengthOnSenventhBit(n3 + n4);
        this.encodeNonEmptyFourBitCharacterString(nArray, cArray, n, n3, n4);
    }

    protected final void encodeNonEmptyFourBitCharacterString(int[] nArray, char[] cArray, int n, int n2, int n3) throws FastInfosetException, IOException {
        this.ensureSize(n2 + n3);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if ((n4 = nArray[cArray[n++]] << 4 | nArray[cArray[n++]]) < 0) {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.characterOutofAlphabetRange"));
            }
            this._octetBuffer[this._octetBufferIndex++] = (byte)n4;
        }
        if (n3 == 1) {
            n4 = nArray[cArray[n]] << 4 | 0xF;
            if (n4 < 0) {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.characterOutofAlphabetRange"));
            }
            this._octetBuffer[this._octetBufferIndex++] = (byte)n4;
        }
    }

    protected final void encodeNonEmptyNBitCharacterStringOnSeventhBit(String string, char[] cArray, int n, int n2) throws FastInfosetException, IOException {
        int n3 = 1;
        while (1 << n3 <= string.length()) {
            ++n3;
        }
        int n4 = n2 * n3;
        int n5 = n4 / 8;
        int n6 = n4 % 8;
        int n7 = n5 + (n6 > 0 ? 1 : 0);
        this.encodeNonZeroOctetStringLengthOnSenventhBit(n7);
        this.resetBits();
        this.ensureSize(n7);
        int n8 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[n + i];
            for (n8 = 0; n8 < string.length() && c != string.charAt(n8); ++n8) {
            }
            if (n8 == string.length()) {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.characterOutofAlphabetRange"));
            }
            this.writeBits(n3, n8);
        }
        if (n6 > 0) {
            this._b |= (1 << 8 - n6) - 1;
            this.write(this._b);
        }
    }

    private final void resetBits() {
        this._bitsLeftInOctet = 8;
        this._b = 0;
    }

    private final void writeBits(int n, int n2) throws IOException {
        while (n > 0) {
            int n3 = (n2 & 1 << --n) > 0 ? 1 : 0;
            this._b |= n3 << --this._bitsLeftInOctet;
            if (this._bitsLeftInOctet != 0) continue;
            this.write(this._b);
            this._bitsLeftInOctet = 8;
            this._b = 0;
        }
    }

    protected final void encodeNonZeroOctetStringLengthOnSenventhBit(int n) throws IOException {
        if (n < 3) {
            this.write(this._b | n - 1);
        } else if (n < 259) {
            this.write(this._b | 2);
            this.write(n - 3);
        } else {
            this.write(this._b | 3);
            this.write((n -= 259) >>> 24);
            this.write(n >> 16 & 0xFF);
            this.write(n >> 8 & 0xFF);
            this.write(n & 0xFF);
        }
    }

    protected final void encodeNonZeroIntegerOnSecondBitFirstBitOne(int n) throws IOException {
        if (n < 64) {
            this.write(0x80 | n);
        } else if (n < 8256) {
            this._b = 0xC0 | (n -= 64) >> 8;
            this.write(this._b);
            this.write(n & 0xFF);
        } else if (n < 0x100000) {
            this._b = 0xE0 | (n -= 8256) >> 16;
            this.write(this._b);
            this.write(n >> 8 & 0xFF);
            this.write(n & 0xFF);
        } else {
            throw new IOException(CommonResourceBundle.getInstance().getString("message.integerMaxSize", new Object[]{0x100000}));
        }
    }

    protected final void encodeNonZeroIntegerOnSecondBitFirstBitZero(int n) throws IOException {
        if (n < 64) {
            this.write(n);
        } else if (n < 8256) {
            this._b = 0x40 | (n -= 64) >> 8;
            this.write(this._b);
            this.write(n & 0xFF);
        } else {
            this._b = 0x60 | (n -= 8256) >> 16;
            this.write(this._b);
            this.write(n >> 8 & 0xFF);
            this.write(n & 0xFF);
        }
    }

    protected final void encodeNonZeroIntegerOnThirdBit(int n) throws IOException {
        if (n < 32) {
            this.write(this._b | n);
        } else if (n < 2080) {
            this._b |= 0x20 | (n -= 32) >> 8;
            this.write(this._b);
            this.write(n & 0xFF);
        } else if (n < 526368) {
            this._b |= 0x28 | (n -= 2080) >> 16;
            this.write(this._b);
            this.write(n >> 8 & 0xFF);
            this.write(n & 0xFF);
        } else {
            this._b |= 0x30;
            this.write(this._b);
            this.write((n -= 526368) >> 16);
            this.write(n >> 8 & 0xFF);
            this.write(n & 0xFF);
        }
    }

    protected final void encodeNonZeroIntegerOnFourthBit(int n) throws IOException {
        if (n < 16) {
            this.write(this._b | n);
        } else if (n < 1040) {
            this._b |= 0x10 | (n -= 16) >> 8;
            this.write(this._b);
            this.write(n & 0xFF);
        } else if (n < 263184) {
            this._b |= 0x14 | (n -= 1040) >> 16;
            this.write(this._b);
            this.write(n >> 8 & 0xFF);
            this.write(n & 0xFF);
        } else {
            this._b |= 0x18;
            this.write(this._b);
            this.write((n -= 263184) >> 16);
            this.write(n >> 8 & 0xFF);
            this.write(n & 0xFF);
        }
    }

    protected final void encodeNonEmptyUTF8StringAsOctetString(int n, String string, int[] nArray) throws IOException {
        char[] cArray = string.toCharArray();
        this.encodeNonEmptyUTF8StringAsOctetString(n, cArray, 0, cArray.length, nArray);
    }

    protected final void encodeNonEmptyUTF8StringAsOctetString(int n, char[] cArray, int n2, int n3, int[] nArray) throws IOException {
        n3 = this.encodeUTF8String(cArray, n2, n3);
        this.encodeNonZeroOctetStringLength(n, n3, nArray);
        this.write(this._encodingBuffer, n3);
    }

    protected final void encodeNonZeroOctetStringLength(int n, int n2, int[] nArray) throws IOException {
        if (n2 < nArray[0]) {
            this.write(n | n2 - 1);
        } else if (n2 < nArray[1]) {
            this.write(n | nArray[2]);
            this.write(n2 - nArray[0]);
        } else {
            this.write(n | nArray[3]);
            this.write((n2 -= nArray[1]) >>> 24);
            this.write(n2 >> 16 & 0xFF);
            this.write(n2 >> 8 & 0xFF);
            this.write(n2 & 0xFF);
        }
    }

    protected final void encodeNonZeroInteger(int n, int n2, int[] nArray) throws IOException {
        if (n2 < nArray[0]) {
            this.write(n | n2);
        } else if (n2 < nArray[1]) {
            this.write(n | nArray[3] | (n2 -= nArray[0]) >> 8);
            this.write(n2 & 0xFF);
        } else if (n2 < nArray[2]) {
            this.write(n | nArray[4] | (n2 -= nArray[1]) >> 16);
            this.write(n2 >> 8 & 0xFF);
            this.write(n2 & 0xFF);
        } else if (n2 < 0x100000) {
            this.write(n | nArray[5]);
            this.write((n2 -= nArray[2]) >> 16);
            this.write(n2 >> 8 & 0xFF);
            this.write(n2 & 0xFF);
        } else {
            throw new IOException(CommonResourceBundle.getInstance().getString("message.integerMaxSize", new Object[]{0x100000}));
        }
    }

    protected final void mark() {
        this._markIndex = this._octetBufferIndex;
    }

    protected final void resetMark() {
        this._markIndex = -1;
    }

    protected final boolean hasMark() {
        return this._markIndex != -1;
    }

    protected final void write(int n) throws IOException {
        if (this._octetBufferIndex < this._octetBuffer.length) {
            this._octetBuffer[this._octetBufferIndex++] = (byte)n;
        } else if (this._markIndex == -1) {
            this._s.write(this._octetBuffer);
            this._octetBufferIndex = 1;
            this._octetBuffer[0] = (byte)n;
        } else {
            this.resize(this._octetBuffer.length * 3 / 2);
            this._octetBuffer[this._octetBufferIndex++] = (byte)n;
        }
    }

    protected final void write(byte[] byArray, int n) throws IOException {
        this.write(byArray, 0, n);
    }

    protected final void write(byte[] byArray, int n, int n2) throws IOException {
        if (this._octetBufferIndex + n2 < this._octetBuffer.length) {
            System.arraycopy(byArray, n, this._octetBuffer, this._octetBufferIndex, n2);
            this._octetBufferIndex += n2;
        } else if (this._markIndex == -1) {
            this._s.write(this._octetBuffer, 0, this._octetBufferIndex);
            this._s.write(byArray, n, n2);
            this._octetBufferIndex = 0;
        } else {
            this.resize((this._octetBuffer.length + n2) * 3 / 2 + 1);
            System.arraycopy(byArray, n, this._octetBuffer, this._octetBufferIndex, n2);
            this._octetBufferIndex += n2;
        }
    }

    private void ensureSize(int n) {
        if (this._octetBufferIndex + n > this._octetBuffer.length) {
            this.resize((this._octetBufferIndex + n) * 3 / 2 + 1);
        }
    }

    private void resize(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this._octetBuffer, 0, byArray, 0, this._octetBufferIndex);
        this._octetBuffer = byArray;
    }

    private void _flush() throws IOException {
        if (this._octetBufferIndex > 0) {
            this._s.write(this._octetBuffer, 0, this._octetBufferIndex);
            this._octetBufferIndex = 0;
        }
    }

    protected final int encodeUTF8String(String string) throws IOException {
        int n = string.length();
        if (n < this._charBuffer.length) {
            string.getChars(0, n, this._charBuffer, 0);
            return this.encodeUTF8String(this._charBuffer, 0, n);
        }
        char[] cArray = string.toCharArray();
        return this.encodeUTF8String(cArray, 0, n);
    }

    private void ensureEncodingBufferSizeForUtf8String(int n) {
        int n2 = 4 * n;
        if (this._encodingBuffer.length < n2) {
            this._encodingBuffer = new byte[n2];
        }
    }

    protected final int encodeUTF8String(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        this.ensureEncodingBufferSizeForUtf8String(n2);
        int n4 = n + n2;
        while (n4 != n) {
            char c;
            if ((c = cArray[n++]) < '\u0080') {
                this._encodingBuffer[n3++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                this._encodingBuffer[n3++] = (byte)(0xC0 | c >> 6);
                this._encodingBuffer[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > '\uffff') continue;
            if (!XMLChar.isHighSurrogate(c) && !XMLChar.isLowSurrogate(c)) {
                this._encodingBuffer[n3++] = (byte)(0xE0 | c >> 12);
                this._encodingBuffer[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._encodingBuffer[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            this.encodeCharacterAsUtf8FourByte(c, cArray, n, n4, n3);
            n3 += 4;
            ++n;
        }
        return n3;
    }

    private void encodeCharacterAsUtf8FourByte(int n, char[] cArray, int n2, int n3, int n4) throws IOException {
        if (n2 == n3) {
            throw new IOException("");
        }
        char c = cArray[n2];
        if (!XMLChar.isLowSurrogate(c)) {
            throw new IOException("");
        }
        int n5 = ((n & 0x3FF) << 10 | c & 0x3FF) + 65536;
        if (n5 < 0 || n5 >= 0x200000) {
            throw new IOException("");
        }
        this._encodingBuffer[n4++] = (byte)(0xF0 | n5 >> 18);
        this._encodingBuffer[n4++] = (byte)(0x80 | n5 >> 12 & 0x3F);
        this._encodingBuffer[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
        this._encodingBuffer[n4++] = (byte)(0x80 | n5 & 0x3F);
    }

    protected final int encodeUtf16String(String string) throws IOException {
        int n = string.length();
        if (n < this._charBuffer.length) {
            string.getChars(0, n, this._charBuffer, 0);
            return this.encodeUtf16String(this._charBuffer, 0, n);
        }
        char[] cArray = string.toCharArray();
        return this.encodeUtf16String(cArray, 0, n);
    }

    private void ensureEncodingBufferSizeForUtf16String(int n) {
        int n2 = 2 * n;
        if (this._encodingBuffer.length < n2) {
            this._encodingBuffer = new byte[n2];
        }
    }

    protected final int encodeUtf16String(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        this.ensureEncodingBufferSizeForUtf16String(n2);
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            char c = cArray[i];
            this._encodingBuffer[n3++] = (byte)(c >> 8);
            this._encodingBuffer[n3++] = (byte)(c & 0xFF);
        }
        return n3;
    }

    public static String getPrefixFromQualifiedName(String string) {
        int n = string.indexOf(58);
        String string2 = "";
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static boolean isWhiteSpace(char[] cArray, int n, int n2) {
        if (!XMLChar.isSpace(cArray[n])) {
            return false;
        }
        int n3 = n + n2;
        while (++n < n3 && XMLChar.isSpace(cArray[n])) {
        }
        return n == n3;
    }

    public static boolean isWhiteSpace(String string) {
        if (!XMLChar.isSpace(string.charAt(0))) {
            return false;
        }
        int n = string.length();
        int n2 = 1;
        while (n2 < n && XMLChar.isSpace(string.charAt(n2++))) {
        }
        return n2 == n;
    }

    static /* synthetic */ byte[] access$202(Encoder encoder, byte[] byArray) {
        encoder._encodingBuffer = byArray;
        return byArray;
    }

    static {
        int n;
        _characterEncodingSchemeSystemDefault = Encoder.getDefaultEncodingScheme();
        NUMERIC_CHARACTERS_TABLE = new int[Encoder.maxCharacter("0123456789-+.E ") + 1];
        DATE_TIME_CHARACTERS_TABLE = new int[Encoder.maxCharacter("0123456789-:TZ ") + 1];
        for (n = 0; n < NUMERIC_CHARACTERS_TABLE.length; ++n) {
            Encoder.NUMERIC_CHARACTERS_TABLE[n] = -1;
        }
        for (n = 0; n < DATE_TIME_CHARACTERS_TABLE.length; ++n) {
            Encoder.DATE_TIME_CHARACTERS_TABLE[n] = -1;
        }
        for (n = 0; n < "0123456789-+.E ".length(); ++n) {
            Encoder.NUMERIC_CHARACTERS_TABLE["0123456789-+.E ".charAt((int)n)] = n;
        }
        for (n = 0; n < "0123456789-:TZ ".length(); ++n) {
            Encoder.DATE_TIME_CHARACTERS_TABLE["0123456789-:TZ ".charAt((int)n)] = n;
        }
    }

    private class EncodingBufferOutputStream
    extends OutputStream {
        private EncodingBufferOutputStream() {
        }

        public void write(int n) throws IOException {
            if (Encoder.this._encodingBufferIndex < Encoder.this._encodingBuffer.length) {
                ((Encoder)Encoder.this)._encodingBuffer[((Encoder)Encoder.this)._encodingBufferIndex++] = (byte)n;
            } else {
                byte[] byArray = new byte[Math.max(Encoder.this._encodingBuffer.length << 1, Encoder.this._encodingBufferIndex)];
                System.arraycopy(Encoder.this._encodingBuffer, 0, byArray, 0, Encoder.this._encodingBufferIndex);
                Encoder.access$202(Encoder.this, byArray);
                ((Encoder)Encoder.this)._encodingBuffer[((Encoder)Encoder.this)._encodingBufferIndex++] = (byte)n;
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            int n3 = Encoder.this._encodingBufferIndex + n2;
            if (n3 > Encoder.this._encodingBuffer.length) {
                byte[] byArray2 = new byte[Math.max(Encoder.this._encodingBuffer.length << 1, n3)];
                System.arraycopy(Encoder.this._encodingBuffer, 0, byArray2, 0, Encoder.this._encodingBufferIndex);
                Encoder.access$202(Encoder.this, byArray2);
            }
            System.arraycopy(byArray, n, Encoder.this._encodingBuffer, Encoder.this._encodingBufferIndex, n2);
            Encoder.this._encodingBufferIndex = n3;
        }

        public int getLength() {
            return Encoder.this._encodingBufferIndex;
        }

        public void reset() {
            Encoder.this._encodingBufferIndex = 0;
        }
    }
}

