// __________ Imports __________

// base classes
import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.*;

// property access
import com.sun.star.beans.*;

// name access
import com.sun.star.container.*;

// text
import com.sun.star.text.*;
import com.sun.star.style.*;

// application specific classes
import com.sun.star.drawing.*;

// presentation specific classes
import com.sun.star.presentation.*;

// Point, Size, ..
import com.sun.star.awt.*;
import java.io.File;


// __________ Implementation __________

/** text demo
    @author Sven Jacobi
 */

public class TextDemo
{
    public static void main( String args[] )
    {
		XComponent xDrawDoc = null;
		try
		{
			String sConnection;
			if ( args.length >= 1 )
				sConnection = args[ 1 ];
			else
				sConnection = "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager";
			XMultiServiceFactory xServiceFactory =
				Helper.connect( sConnection );

			// suppress Presentation Autopilot when opening the document
			// properties are the same as described for com.sun.star.document.MediaDescriptor
			PropertyValue[] pPropValues = new PropertyValue[ 1 ];
			pPropValues[ 0 ] = new PropertyValue();
			pPropValues[ 0 ].Name = "Silent";
			pPropValues[ 0 ].Value = new Boolean( true );

			xDrawDoc = Helper.createDocument( xServiceFactory,
				"private:factory/sdraw", "_blank", 0, pPropValues );

			XDrawPage xPage = PageHelper.getDrawPageByIndex( xDrawDoc, 0 );			
			XShapes xShapes = (XShapes)
					UnoRuntime.queryInterface( XShapes.class, xPage );


			XShape		 xRectangle;
			XPropertySet xTextPropSet, xShapePropSet;
			LineSpacing  aLineSpacing = new LineSpacing();
			aLineSpacing.Mode = LineSpacingMode.PROP;



			// first shape
			xRectangle = ShapeHelper.createShape( xDrawDoc,
				new Point( 0, 0 ),
					new Size( 15000, 7500 ),
						"com.sun.star.drawing.RectangleShape" );
			xShapes.add( xRectangle );
			xShapePropSet = (XPropertySet)
					UnoRuntime.queryInterface( XPropertySet.class, xRectangle );


			// first paragraph
			xTextPropSet = ShapeHelper.addPortion( xRectangle, "Portion1", false );
			xTextPropSet.setPropertyValue( "CharColor", new Integer( 0xff0000 ) );
			xTextPropSet = ShapeHelper.addPortion( xRectangle, "Portion2", false );
			xTextPropSet.setPropertyValue( "CharColor", new Integer( 0x8080ff ) );
			aLineSpacing.Height = 100;
			ShapeHelper.setPropertyForLastParagraph( xRectangle, "ParaLineSpacing", aLineSpacing );

			// second paragraph
			xTextPropSet = ShapeHelper.addPortion( xRectangle, "Portion3", true );
			xTextPropSet.setPropertyValue( "CharColor", new Integer( 0xff ) );
			aLineSpacing.Height = 200;
			ShapeHelper.setPropertyForLastParagraph( xRectangle, "ParaLineSpacing", aLineSpacing );



			// second shape
			xRectangle = ShapeHelper.createShape( xDrawDoc,
				new Point( 0, 10000 ),
					new Size( 21000, 12500 ),
						"com.sun.star.drawing.RectangleShape" );			
			xShapes.add( xRectangle );
			xShapePropSet = (XPropertySet)
					UnoRuntime.queryInterface( XPropertySet.class, xRectangle );
			xShapePropSet.setPropertyValue( "TextFitToSize", TextFitToSizeType.PROPORTIONAL );
			xShapePropSet.setPropertyValue( "TextLeftDistance",  new Integer( 2500 ) );
			xShapePropSet.setPropertyValue( "TextRightDistance", new Integer( 2500 ) );
			xShapePropSet.setPropertyValue( "TextUpperDistance", new Integer( 2500 ) );
			xShapePropSet.setPropertyValue( "TextLowerDistance", new Integer( 2500 ) );
			xTextPropSet = ShapeHelper.addPortion( xRectangle, "using TextFitToSize", false );
			xTextPropSet.setPropertyValue( "ParaAdjust", ParagraphAdjust.CENTER );
			xTextPropSet.setPropertyValue( "CharColor",  new Integer( 0xff00 ) );
			xTextPropSet = ShapeHelper.addPortion( xRectangle, "and a Border distance of 2,5 cm", true );
			xTextPropSet.setPropertyValue( "CharColor",  new Integer( 0xff0000 ) );

		}
		catch( Exception ex )
		{
            System.out.println( ex );
		}
		System.exit( 0 );
    }
}
