import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.Type;
import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import java.lang.reflect.Field;

// Importing the interfaces for accelerating and steering
import org.OpenOffice.XAccelerationControl;
import org.OpenOffice.XDrivingDirection;

public class Car {
    // The class should implement the interfaces for accelerating and steering
    static public class _Car extends WeakBase implements XServiceInfo, XAccelerationControl,
    XDrivingDirection, XPropertySet {
        // The service should be addressable to the specified name
        static private final String __serviceName = "org.OpenOffice.Car";
        
        // Number of seats in the car
        public Short Seats = new Short( ( short ) 4 );
        
        // Color of the car
        public Long Color = new Long( 0 );
        
        // Providing the current speed of the car
        private static double doubleSpeed = 0;
        
        // Providing the current angle of the car
        private static double doubleAngle = 0;
        
        // Implementing the method slowDown() from the interface XAccelerationControl
        public void slowDown(double doubleKilometer) {
            this.doubleSpeed -= doubleKilometer;
            if ( this.doubleSpeed < 0 )
                this.doubleSpeed = 0;
        }
        
        // Implementing the method speedUp() from the interface XAccelerationControl
        public void speedUp(double doubleKilometer) {
            this.doubleSpeed += doubleKilometer;
        }
        
        // Implementing the method turnRight() from the interface XDrivingDirection
        public void turnRight(double doubleAngle) {
            this.doubleAngle -= doubleAngle;
            this.doubleAngle += 360;
            this.doubleAngle %= 360;
        }
        
        // Implementing the method turnLeft() from the interface XDrivingDirection
        public void turnLeft(double doubleAngle) {
            this.doubleAngle += doubleAngle;
            this.doubleAngle %= 360;
        }

        // Implement methods from interface XServiceInfo
        public boolean supportsService(String stringServiceName) {
            return( stringServiceName.equals( __serviceName ) );
        }
        
        public String getImplementationName() {
            return( _Car.class.getName() );
        }
        
        public String[] getSupportedServiceNames() {
            String[] stringSupportedServiceNames = { __serviceName };
            return( stringSupportedServiceNames );
        }
        
        // Implementing the method setPropertyValue() from the interface XPropertySet
        public void setPropertyValue( String stringPropertyName, Object obj)
        throws UnknownPropertyException, PropertyVetoException,
        IllegalArgumentException, WrappedTargetException {
            try {
                getClass().getField( stringPropertyName ).set( this, obj );
            }
            catch ( Exception exception ) {
                System.err.println( exception );
            }
        }
        
        // Implementing the method getPropertyValue() from the interface XPropertySet
        public java.lang.Object getPropertyValue( String stringPropertyName )
        throws UnknownPropertyException, WrappedTargetException {
            Object objectProperty = null;
            
            try {
                objectProperty = getClass().getField( stringPropertyName ).get( this );
            }
            catch ( Exception exception ) {
                System.err.println( exception );
            }
            return( objectProperty );
        }
        
        // Implementing the method removePropertyChangeListener() from the interface XPropertySet
        public void removePropertyChangeListener( String string,
                                                  XPropertyChangeListener xPropertyChangeListener)
            throws UnknownPropertyException, WrappedTargetException {
        }
        
        // Implementing the method getPropertySetInfo() from the interface XPropertySet
        public XPropertySetInfo getPropertySetInfo() {
            return new PropertySetInfoCar( new Property[] {
                new Property( "Seats",   -1,
                new Type( Short.class ), Seats.shortValue() ),
                new Property( "Color", -1,
                new Type( Long.class ), Color.shortValue() ) } );
        }
        
        // Implementing the method removeVetoableChangeListener() from the interface XPropertySet
        public void removeVetoableChangeListener( String string,
                                                  XVetoableChangeListener xVetoableChangeListener)
            throws UnknownPropertyException, WrappedTargetException {
        }
        
        // Implementing the method addPropertyChangeListener() from the interface XPropertySet
        public void addPropertyChangeListener( String string,
        XPropertyChangeListener xPropertyChangeListener)
        throws UnknownPropertyException, WrappedTargetException {
        }
        
        // Implementing the method addVetoableChangeListener() from the interface XPropertySet
        public void addVetoableChangeListener( String string,
        XVetoableChangeListener xVetoableChangeListener)
        throws UnknownPropertyException, WrappedTargetException {
        }
        
        public static double getCurrentSpeed() {
            return( doubleSpeed );
        }
        
        public static double getCurrentAngle() {
            return( doubleAngle );
        }
    }
    
    /**
     * Returns a factory for creating the service.
     * This method is called by the <code>JavaLoader</code>
     * <p>
     * @return  returns a <code>XSingleServiceFactory</code> for creating the component
     * @param   implName     the name of the implementation for which a service is desired
     * @param   multiFactory the service manager to be used if needed
     * @param   regKey       the registryKey
     * @see                  com.sun.star.comp.loader.JavaLoader
     */
    public static XSingleServiceFactory __getServiceFactory(String implName,
    XMultiServiceFactory multiFactory,
    XRegistryKey regKey) {
        XSingleServiceFactory xSingleServiceFactory = null;
        
        if (implName.equals(_Car.class.getName()) )
            xSingleServiceFactory = FactoryHelper.getServiceFactory(_Car.class,
            _Car.__serviceName,
            multiFactory,
            regKey);
        
        return xSingleServiceFactory;
    }
    
    /**
     * Writes the service information into the given registry key.
     * This method is called by the <code>JavaLoader</code>
     * <p>
     * @return  returns true if the operation succeeded
     * @param   regKey       the registryKey
     * @see                  com.sun.star.comp.loader.JavaLoader
     */
    public static boolean __writeRegistryServiceInfo(XRegistryKey regKey) {
        return FactoryHelper.writeRegistryServiceInfo(_Car.class.getName(),
        _Car.__serviceName, regKey);
    }
}


// XPropertySetInfo implementation for getPropertySetInfo
class PropertySetInfoCar implements com.sun.star.beans.XPropertySetInfo {
    private com.sun.star.beans.Property[] property;
    
    public PropertySetInfoCar(
    com.sun.star.beans.Property[] propertyInitial ) {
        property = propertyInitial;
    }
    
    public com.sun.star.beans.Property[] getProperties() {
        return property;
    }
    
    public com.sun.star.beans.Property getPropertyByName( String stringName )
    throws com.sun.star.beans.UnknownPropertyException {
        for ( int intIndex = 0; intIndex < property.length; intIndex++ ) {
            if ( property[ intIndex ].Name.equals( stringName ) )
                return property[ intIndex ];
        }
        throw new com.sun.star.beans.UnknownPropertyException();
    }
    
    public boolean hasPropertyByName( String stringName ) {
        for ( int intIndex = 0; intIndex < property.length; intIndex++ ) {
            if ( property[ intIndex ].Name.equals( stringName ) )
                return true;
        }
        
        return false;
    }
}
