import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.container.XSet;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySetInfo;

import org.OpenOffice.XAccelerationControl;
import org.OpenOffice.XDrivingDirection;


/** The purpose of this class is to show how you can use the component Car.
 * Some methods for accelerating and controlling the direction will be invoked
 * for example.
 */
public class Test {
  public static void main(String args[]) {
    try {
      /* Bootstraps a component context with the jurt base components
         registered. Component context to be granted to a component for running.
         Arbitrary values can be retrieved from the context. */
      XComponentContext xcomponentcontext =
      com.sun.star.comp.helper.Bootstrap.createInitialComponentContext( null );
      
      /* Gets the service manager instance to be used (or null). This method has
         been added for convenience, because the service manager is a often used
         object. */
      XMultiComponentFactory xmulticomponentfactory =
      xcomponentcontext.getServiceManager();
      
      // Querying for the interface XSet on XMultiComponentFactory
      XSet xsetMultiComponentFactory = ( XSet ) UnoRuntime.queryInterface(
          XSet.class, xmulticomponentfactory );
      
      // Getting the XSingleServiceFactory for the Car component
      XSingleServiceFactory xsingleservicefactoryCar =
      Car.__getServiceFactory( "Car$_Car", ( XMultiServiceFactory )
          UnoRuntime.queryInterface( XMultiServiceFactory.class,
                                     xmulticomponentfactory ), null );
      
      // Inserting the XSingleServiceFactory into the container
      xsetMultiComponentFactory.insert( xsingleservicefactoryCar );
      
      // Creating an instance of the Car component
      Object objectCar = xmulticomponentfactory.createInstanceWithContext(
      "org.OpenOffice.Car", xcomponentcontext );
      
      // Querying for the interface XAccelerationControl
      XAccelerationControl xaccelerationcontrol = ( XAccelerationControl )
      UnoRuntime.queryInterface( XAccelerationControl.class, objectCar );
      
      // Print the current speed
      System.out.println( "Current speed: " + Car._Car.getCurrentSpeed() );
      
      // Speed up
      xaccelerationcontrol.speedUp( 123.55 );
      
      // Print the current speed
      System.out.println( "Current speed: " + Car._Car.getCurrentSpeed() );
      
      // Slow down
      xaccelerationcontrol.slowDown( 112.43 );
      
      // Print the current speed
      System.out.println( "Current speed: " + Car._Car.getCurrentSpeed() );
      
      // Querying for the interface XDrivingDirection
      XDrivingDirection xdrivingdirection = ( XDrivingDirection )
      UnoRuntime.queryInterface( XDrivingDirection.class, objectCar );
      
      // Print the current angle
      System.out.println( "Current angle: " + Car._Car.getCurrentAngle() );
      
      // Changing the direction
      xdrivingdirection.turnLeft( 100 );
      
      // Print the current angle
      System.out.println( "Current angle: " + Car._Car.getCurrentAngle() );
      
      xdrivingdirection.turnRight( 150 );
      
      // Print the current angle
      System.out.println( "Current angle: " + Car._Car.getCurrentAngle() );
      
      // Querying for the interface XPropertySet
      XPropertySet xpropertysetCar = ( XPropertySet )
      UnoRuntime.queryInterface( XPropertySet.class, objectCar );
      
      // Setting the number of seats
      xpropertysetCar.setPropertyValue( "Seats", new Short( ( short ) 5 ) );
      
      // Print the number of seats
      System.out.println( "Number of seats: " +
      xpropertysetCar.getPropertyValue( "Seats" ) );
      
      // Setting the color of the car
      xpropertysetCar.setPropertyValue( "Color", new Long( ( long ) 232 ) );
      
      // Print the color of the car
      System.out.println( "Color of the car: " +
      xpropertysetCar.getPropertyValue( "Color" ) );
      
      // Get properties from the car.
      XPropertySetInfo xpropertysetinfo = xpropertysetCar.getPropertySetInfo();
      
      // Print the number of the color of the car.
      System.out.println( "Color of the car: " +
      xpropertysetinfo.getPropertyByName( "Color" ).Attributes );

      // Removing the XSingleServiceFactory of Car from the container
      xsetMultiComponentFactory.remove( xsingleservicefactoryCar );
      
      System.exit(0);
    }
    catch( Exception exception ) {
      System.err.println( exception );
    }
  }
}
