/*
 * Decompiled with CFR 0.152.
 */
package stardiv.controller;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class ThreadDialog
extends Dialog {
    private List list = new List(10);
    private Thread[] threadList;
    private int selectedItem = -1;
    private Button killBtn;
    private Button suspendBtn;
    private Button resumeBtn;
    private Button closeBtn;
    private UpdaterThread updaterThread;

    public ThreadDialog(Frame frame) {
        super(frame, "Threads");
        Font font = new Font("Courier", 0, 10);
        this.list.setFont(font);
        Label label = new Label(" No.    Thread Name                     Thread Group              Is Alive Priority");
        label.setFont(font);
        label.setBackground(Color.lightGray);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ThreadDialog.this.setVisible(false);
            }
        });
        this.killBtn = new Button("Kill");
        this.suspendBtn = new Button("Suspend");
        this.resumeBtn = new Button("Resume");
        this.closeBtn = new Button("Close");
        this.list.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ThreadDialog.this.selectedItem = ThreadDialog.this.list.getSelectedIndex();
                ThreadDialog.this.enableButtons(ThreadDialog.this.selectedItem > -1);
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ThreadDialog.this.selectedItem > -1) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Kill")) {
                        ThreadDialog.this.threadList[ThreadDialog.this.selectedItem].stop();
                    } else if (string.equals("Suspend")) {
                        ThreadDialog.this.threadList[ThreadDialog.this.selectedItem].suspend();
                    } else if (string.equals("Resume")) {
                        ThreadDialog.this.threadList[ThreadDialog.this.selectedItem].resume();
                    } else if (string.equals("Close")) {
                        ThreadDialog.this.setVisible(false);
                    }
                }
            }
        };
        this.killBtn.addActionListener(actionListener);
        this.suspendBtn.addActionListener(actionListener);
        this.resumeBtn.addActionListener(actionListener);
        this.closeBtn.addActionListener(actionListener);
        Panel panel = new Panel(new GridLayout(2, 2));
        panel.add(this.suspendBtn);
        panel.add(this.resumeBtn);
        panel.add(this.killBtn);
        panel.add(this.closeBtn);
        this.setLayout(new BorderLayout());
        this.add("North", label);
        this.add("Center", this.list);
        this.add("South", panel);
        ((Component)this).setSize(700, 500);
    }

    public void setVisible(boolean bl) {
        try {
            if (bl) {
                this.updaterThread = new UpdaterThread();
                this.updaterThread.start();
            } else {
                this.updaterThread.stop();
                this.updaterThread = null;
            }
            super.setVisible(bl);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void update() {
        int n = Thread.activeCount();
        this.threadList = new Thread[n];
        n = Thread.enumerate(this.threadList);
        this.list.clear();
        int n2 = 0;
        while (n2 < n) {
            Thread thread = this.threadList[n2];
            String string = " " + n2 + ". ";
            while (string.length() < 8) {
                string = string + " ";
            }
            string = string + thread.getName() + " ";
            while (string.length() < 40) {
                string = string + " ";
            }
            string = string + thread.getThreadGroup().getName() + " ";
            while (string.length() < 66) {
                string = string + " ";
            }
            string = string + thread.isAlive() + " ";
            while (string.length() < 75) {
                string = string + " ";
            }
            string = string + thread.getPriority();
            this.list.add(string);
            ++n2;
        }
        if (this.selectedItem == -1 && n > 0) {
            this.selectedItem = 0;
        }
        this.list.select(this.selectedItem);
    }

    private void enableButtons(boolean bl) {
        this.killBtn.setEnabled(bl);
        this.suspendBtn.setEnabled(bl);
        this.resumeBtn.setEnabled(bl);
    }

    class UpdaterThread
    extends Thread {
        public UpdaterThread() {
            super("Thread Updater");
            this.setPriority(1);
        }

        public void run() {
            while (true) {
                ThreadDialog.this.update();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

