/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.ClassContext;
import com.sun.star.lib.sandbox.ProtectionDomain;
import com.sun.star.lib.sandbox.ResourceProxy;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

final class ClassContextImpl
extends ClassLoader
implements ClassContext {
    private static int instances;
    private static final boolean DEBUG = false;
    private URL codeBase;
    private ProtectionDomain protectionDomain;
    private boolean _bSecure;
    private Vector _cargoVector = new Vector();
    private ThreadGroup threadGroup;

    public ClassContextImpl(URL uRL, ProtectionDomain protectionDomain, ThreadGroup threadGroup, boolean bl) {
        this(uRL, protectionDomain, threadGroup);
        this._bSecure = bl;
    }

    public ClassContextImpl(URL uRL, ProtectionDomain protectionDomain, ThreadGroup threadGroup) {
        ++instances;
        this.codeBase = uRL;
        this.protectionDomain = protectionDomain;
        this.threadGroup = threadGroup;
    }

    public void finalize() {
        --instances;
    }

    public URL getBase() {
        return this.codeBase;
    }

    public void addCargo(Object object) {
        this._cargoVector.addElement(object);
    }

    public URL getCodeBase() {
        return this.getBase();
    }

    public boolean hasThreadGroup() {
        return this.threadGroup != null && !this.threadGroup.isDestroyed();
    }

    public ThreadGroup getThreadGroup() {
        if (this.threadGroup == null || this.threadGroup.isDestroyed()) {
            this.threadGroup = new ThreadGroup(this.codeBase.toString());
            this.threadGroup.setDaemon(true);
        }
        return this.threadGroup;
    }

    boolean checkSecurity() {
        return !this._bSecure;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null) {
            try {
                URL uRL = new URL(this.codeBase, string);
                if (ResourceProxy.isResource(uRL)) {
                    ResourceProxy resourceProxy = ResourceProxy.load(uRL, this.protectionDomain);
                    inputStream = resourceProxy.getInputStream();
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    public URL getResource(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL == null) {
            try {
                uRL = new URL(this.codeBase, string);
                uRL = !ResourceProxy.isResource(uRL) ? null : new URL("appletresource:" + this.codeBase + "/+/" + string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null && !string.startsWith("JSGen")) {
            this.getClass();
            clazz = Class.forName(string);
        }
        return clazz;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
            securityManager.checkPackageAccess(string.substring(0, n));
        }
        Class<?> clazz = null;
        try {
            clazz = this.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                ResourceProxy resourceProxy = ResourceProxy.load(new URL(this.codeBase, string.replace('.', '/') + ".class"), this.protectionDomain);
                byte[] byArray = resourceProxy.getBytes();
                clazz = this.defineClass(string, byArray, 0, byArray.length);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ClassNotFoundException("ClassContext.loadClass - MalformedURLException: " + malformedURLException + " " + string + " " + this.codeBase);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("ClassContext.loadClass - IOException: " + iOException + " " + string + " " + this.codeBase);
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassNotFoundException("ClassContext.loadClass - ClassFormatError: " + classFormatError + " " + string + " " + this.codeBase);
            }
        }
        if (clazz != null && bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public synchronized void dispose() {
        if (this.threadGroup != null) {
            this.threadGroup.list();
            new Thread((Runnable)new ThreadGroupKiller(this.threadGroup), this.codeBase.toString() + " killer thread").start();
            this.threadGroup = null;
        }
    }

    private void printHeader(byte[] byArray) {
        System.err.print("#### ClassContext.loadClass - bytes header:");
        int n = 0;
        while (n < 4) {
            System.err.print(" " + Integer.toHexString(byArray[n] & 0xFF));
            ++n;
        }
        System.err.println();
    }

    public ClassLoader getClassLoader() {
        return this;
    }

    static class ThreadGroupKiller
    implements Runnable {
        ThreadGroup threadGroup = null;

        ThreadGroupKiller(ThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
        }

        public void run() {
            try {
                System.err.println("#### ClassContext - killerThread start");
                this.threadGroup.stop();
                this.threadGroup.destroy();
                System.err.println("#### ClassContext - killerThread succeeded");
            }
            catch (Exception exception) {
                System.err.println("ClassContext.dispose:" + exception);
            }
        }
    }
}

